/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

import jp.sourceforge.mergedoc.pleiades.log.FileLogger;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.PopupFileLogger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/**
 * Pleiades N邽߂̃G[WFgłB
 * <p>
 * @author C/pHeR
 */
public class Pleiades {
	
	/** K[ */
	private static Logger log;
	
	/** Pleiades NIvV */
	private static PleiadesOption pleiadesOption;
	
	/** ̃NX̃VOgECX^X */
	private static Pleiades pleiades;
	
	/** RtBO[VEpX */
	public static final File configurationPath = getConfigurationPath();

	/** OEt@C */
	private static final File logFile = new File(configurationPath, "pleiades.log");
	
	/**
	 * RtBO[VEpX擾܂B
	 * @return RtBO[VEpX
	 */
	private static File getConfigurationPath() {
		
		File eclipseHome = FileSystem.resourceRoot.getParentFile().getParentFile().getParentFile();
		File configPath = new File(eclipseHome, "configuration");
		Properties configIni = FileSystem.loadProperties(new File(configPath, "config.ini"));
		
		final String CONFIG_AREA_KEY = "osgi.configuration.area";
		String configArea = configIni.getProperty(CONFIG_AREA_KEY);
		if (configArea == null) {
			configArea = System.getProperty(CONFIG_AREA_KEY);
		}
		
		File userConfigPath = null;
		if (configArea != null) {
			Matcher mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea);
			if (mat.find()) {
				String base = System.getProperty(mat.group(1));
				if (base != null) {
					File baseDir = new File(base);
					if (baseDir.exists()) {
						String childPath = mat.group(2);
						userConfigPath = new File(baseDir, childPath);
					}
				}
			}
		}
		if (userConfigPath == null) {
			userConfigPath = configPath;
		}
		File pleiadesConfigPath = new File(userConfigPath, "jp.sourceforge.mergedoc.pleiades/");
		pleiadesConfigPath.mkdirs();
		return pleiadesConfigPath;
	}
	
	/**
	 * NGg[E|CgƂȂ premain \bhłB
	 * <p>
	 * @param option -javaagent N
	 * @param inst CXgDe[V
	 * @throws Throwable łȂG[ꍇ
	 */
	public static void premain(String option, Instrumentation inst) throws Throwable {
		
		// Pleiades NIvV쐬
		pleiadesOption = new PleiadesOption(option);
		
		// K[̏
		System.setProperty(Logger.LOGGER_CLASS_NAME, PopupFileLogger.class.getName());
		System.setProperty(Logger.LOG_LEVEL, pleiadesOption.getLogLevel());
		System.setProperty(FileLogger.LOG_FILE_NAME, logFile.getAbsolutePath());
		log = Logger.getLogger(Pleiades.class);
		if (log.isDebugEnabled()) {
			Properties p = System.getProperties();
			FileSystem.storeProperties(p, new File(configurationPath, "system.properties"));
		}
		
		// Swing ̃tHg
		try {
			initSwingFont();
		} catch (Throwable e) {
			// Fedora6, 7  NPE 邪đs
			log.warn("Swing  LookAndFeel ݒɎs܂B" + e);
		}
		
		// G[WFgs
		try {
			pleiades = new Pleiades();
			pleiades.run(inst);
		} catch (Throwable e) {
			log.fatal("Pleiades AOP |Rei[̋NɎs܂B", e);
			Pleiades.exit();
		}
		log.info("Pleiades AOP |Rei[Jn܂BPleiades NIvV:" + option);
	}

	/**
	 * Swing ŎgptHg܂B
	 * Eclipse ̃vOC͒ʏ SWT gpĂ܂A
	 * ꕔ̃vOCł Swing pĂ܂B
	 * <p>
	 * @throws ClassNotFoundException LookAndFeel NXȂꍇ
	 * @throws InstantiationException NX̐VCX^X𐶐łȂꍇ
	 * @throws IllegalAccessException NX܂͏qɃANZXłȂꍇ
	 * @throws UnsupportedLookAndFeelException lnf.isSupportedLookAndFeel()  false ̏ꍇ
	 */
	private static void initSwingFont() throws
		ClassNotFoundException,
		InstantiationException,
		IllegalAccessException,
		UnsupportedLookAndFeelException
	{
		// LookAndFeel ̐ݒ
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		Toolkit.getDefaultToolkit().setDynamicLayout(true);
		
		// tHgݒ
		Object propoFont = new FontUIResource("MS UI Gothic", Font.TRUETYPE_FONT, 12);
		Object fixedFont = new FontUIResource("MS Gothic", Font.TRUETYPE_FONT, 12);
		String osName = System.getProperty("os.name", "");
		if (!osName.contains("Windows")) {
			
			// Windows ȊO͘_tHgŎw
			propoFont = new FontUIResource("sansserif", Font.TRUETYPE_FONT, 12);
			fixedFont = new FontUIResource("sansserif", Font.TRUETYPE_FONT, 12);
		}
		
		// UׂẴR|[lg̃tHgv|[ViɂB
		// tHg\[X̔͒l擾 instanceof FontUIResource 
		// SAUIDefaults  Lazy Value 𐶂ߖ̕ŔB
		for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
			String key = keyObj.toString();
			if (key.endsWith("font") || key.endsWith("Font")) {
				UIManager.put(key, propoFont);
			}
		}
		
		// R|[lg̃tHg𓙕ɂ
		UIManager.put("TextPane.font", fixedFont);
		UIManager.put("TextArea.font", fixedFont);
	}
	
	/**
	 * VM I܂B
	 */
	public static void exit() {
		System.exit(-1);
	}
	
	/**
	 * Pleiades CX^X擾܂B
	 * <p>
	 * @return Pleiades CX^X
	 */
	public static Pleiades getInstance() {
		return pleiades;
	}
	
	/** CXgDe[V */
	private Instrumentation instrumentation;
	
	/** ԌvK[̃Xg */
	private List<ITimingLogger> timeingLoggers;
	
	/**
	 * CXgDe[V擾܂B
	 * <p>
	 * @return CXgDe[V
	 */
	public Instrumentation getInstrumentation() {
		return instrumentation;
	}
	
	/**
	 * Pleiades NIvV擾܂B
	 * <p>
	 * @return Pleiades NIvV
	 */
	public PleiadesOption getPleiadesOption() {
		return pleiadesOption;
	}
	
	/**
	 * G[WFgs܂B
	 * <p>
	 * @param inst CXgDe[V
	 * @throws Throwable łȂG[ꍇ
	 */
	private void run(Instrumentation inst) throws Throwable {
		
		// NgXtH[}[Jn
		instrumentation = inst;
		if (log.isDebugEnabled()) {
			instrumentation.addTransformer(new LauncherLoggingTransformer());
		} else {
			instrumentation.addTransformer(new LauncherTransformer());
		}
	}

	/**
	 * ԌvK[o^܂B
	 * <p>
	 * @param timeingLogger ԌvK[
	 */
	public void registTimingLogger(ITimingLogger timeingLogger) {
		getTimeingLoggers().add(timeingLogger);
	}

	/**
	 * ԌvK[̃Xg擾܂B
	 * <p>
	 * @return ԌvK[̃Xg
	 */
	public List<ITimingLogger> getTimeingLoggers() {
		if (timeingLoggers == null) {
			timeingLoggers = new LinkedList<ITimingLogger>();
		}
		return timeingLoggers;
	}
}
