/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptRecycleSummary
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptRecycleSummary.class);
    private String posLinkBarcode;

    public ReceiptRecycleSummary(String posLinkBarcode) {
        this.posLinkBarcode = posLinkBarcode;
    }

    @Override
    protected void executeReceiptPrint(String slipNo) {
        log.info((Object)"\u8cb7\u53d6\u96c6\u8a08\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        list.add(this.getReceiptTitle("   \u8cb7\u53d6 \u96c6\u8a08   "));
        list.add(this.getReceiptTitle("  \uff08\u5e97\u8217 \u63a7\uff09  "));
        list.add(this.getReceiptLine());
        list.add("|4C" + PosStringUtils.fill("\u8cb7\u53d6\u70b9\u6570", String.valueOf(String.valueOf(this.journalHead.getTotalItemQuantity())) + "\u70b9", 15));
        list.add("|4C" + PosStringUtils.fill("\u5408\u8a08", PosNumberUtils.currencyFormat(this.journalHead.getTotalAmount()), 15));
        list.add(this.getReceiptLine());
        list.add("::       \u4fdd\u7ba1\u7528\u5e97\u8217\u63a7       ::");
        if (StringUtils.isNotEmpty((String)this.posLinkBarcode) && this.posLinkBarcode.length() == 13) {
            list.add(this.getReceiptLine());
            list.add(String.format("[%s]", this.posLinkBarcode));
        }
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(true));
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u8cb7\u53d6\u96c6\u8a08\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }
}

