/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.receipt;

import java.util.ArrayList;
import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiptRecycleCancel
extends ReceiptAbstract {
    private static Log log = LogFactory.getLog(ReceiptRecycleCancel.class);
    private long totalAmount = 0L;

    public ReceiptRecycleCancel(long totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Override
    public void executeReceiptPrint(String slipNo) {
        log.info((Object)"\u8cb7\u53d6\u53d6\u6d88\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:START");
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getStoreHeader());
        list.add(this.getEmptyLine());
        list.addAll(this.getReceiptHeader(slipNo));
        list.add(this.getEmptyLine());
        list.add(this.getReceiptTitle(" \u8cb7\u53d6 \u30ec\u30b7\u30fc\u30c8 "));
        list.add(this.getReceiptTitle("   \uff08\u53d6 \u6d88\uff09   "));
        list.add(this.getReceiptLine());
        Integer totalQuantity = 0;
        int i = 0;
        while (i < this.journalDetail.size()) {
            if (this.showItemName()) {
                list.add(((JournalDetail)this.journalDetail.get(i)).getItemName());
            } else {
                list.add(((JournalDetail)this.journalDetail.get(i)).getItemCd());
            }
            Integer quantity = ((JournalDetail)this.journalDetail.get(i)).getItemQuantity();
            totalQuantity = totalQuantity + quantity;
            String price = PosNumberUtils.currencyFormat(((JournalDetail)this.journalDetail.get(i)).getCost() * -1L);
            price = price.concat("   ");
            String itemQuantity = PosStringUtils.fill(quantity.toString(), 15);
            list.add(PosStringUtils.fill(itemQuantity, price, 30));
            ++i;
        }
        list.add(this.getReceiptLine());
        String totalItemQuantity = PosStringUtils.fill("\u53d7\u53d6\u91d1\u984d", String.valueOf(totalQuantity), 15);
        list.add(PosStringUtils.fill(totalItemQuantity, PosNumberUtils.currencyFormat(this.totalAmount * -1L), 27));
        list.add(this.getReceiptLine());
        list.add("\u203b   \u8cb7 \u53d6 \u30ad \u30e3 \u30f3 \u30bb \u30eb   \u203b");
        list.add(this.getReceiptLine());
        list.addAll(this.getReceiptFooter(false));
        OposReceiptPrinter rp = OposController.getInstance().getReceiptPrinter();
        rp.print(slipNo, list);
        list.clear();
        log.info((Object)"\u8cb7\u53d6\u53d6\u6d88\u30ec\u30b7\u30fc\u30c8\u51fa\u529b:END");
    }
}

