/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.label.barcode;

import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.swt.graphics.GC;

public class Barcode {
    private int posion = 0;
    private static final String[] oddEven4EAN = new String[]{"OOOOOO", "OOXOXX", "OOXXOX", "OOXXXO", "OXOOXX", "OXXOOX", "OXXXOO", "OXOXOX", "OXOXXO", "OXXOXO"};
    private static final String[] leftOddBar = new String[]{"0001101", "0011001", "0010011", "0111101", "0100011", "0110001", "0101111", "0111011", "0110111", "0001011"};
    private static final String[] leftEvenBar = new String[]{"0100111", "0110011", "0011011", "0100001", "0011101", "0111001", "0000101", "0010001", "0001001", "0010111"};
    private static final String[] rightBar = new String[]{"1110010", "1100110", "1101100", "1000010", "1011100", "1001110", "1010000", "1000100", "1001000", "1110100"};
    public int leftMargin = 0;
    public int barcodePlaceX = 1;
    public int barcodePlaceY = 73;
    public int barcodeHeight = 318;
    public int barcodeInterval = 2;
    public int barcodeWidth = 2;

    public void printBarcode(GC gc, String code) {
        char ch;
        int x = this.barcodePlaceX;
        int y = this.barcodePlaceY;
        int height = this.barcodeHeight;
        gc.setLineWidth(this.barcodeWidth);
        if (code == null || code.length() != 13) {
            return;
        }
        if (!NumberUtils.isDigits((String)code)) {
            return;
        }
        this.posion = 0;
        this.printBar(gc, "101", x, y, height);
        String oddEven = oddEven4EAN[code.charAt(0) - 48];
        int i = 1;
        while (i < 7) {
            ch = code.charAt(i);
            if (oddEven.charAt(i - 1) == 'O') {
                this.printBar(gc, leftOddBar[ch - 48], x, y, height);
            } else {
                this.printBar(gc, leftEvenBar[ch - 48], x, y, height);
            }
            ++i;
        }
        this.printBar(gc, "01010", x, y, height);
        i = 7;
        while (i < 13) {
            ch = code.charAt(i);
            this.printBar(gc, rightBar[ch - 48], x, y, height);
            ++i;
        }
        this.printBar(gc, "101", x, y, height);
    }

    private void printBar(GC gc, String bar, int x, int y, int height) {
        int i = 0;
        while (i < bar.length()) {
            if (bar.charAt(i) == '1') {
                gc.drawLine(this.leftMargin + x + this.posion, y, this.leftMargin + x + this.posion, height);
            }
            this.posion += this.barcodeInterval;
            ++i;
        }
    }
}

