/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.print.label;

import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.list.ItemList;
import jp.ne.k_tech.kposrcp.kpos.print.Print;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LabelAbstract {
    private static Log log = LogFactory.getLog(LabelAbstract.class);
    protected PosMain posMain = null;
    protected ItemList itemList = null;

    protected abstract Print executeLabelPrint(int var1);

    public void executePrint(PosMain posMain) {
        if (posMain == null) {
            return;
        }
        this.posMain = posMain;
        this.initItemList();
        this.labePrint();
    }

    private void labePrint() {
        log.info((Object)"\u30e9\u30d9\u30eb\u51fa\u529b:START");
        Print print = null;
        Thread nowThread = null;
        log.debug((Object)("\u5546\u54c1\u30ea\u30b9\u30c8\u6570:" + this.itemList.getBodyList().size()));
        int index = 0;
        while (index < this.itemList.getBodyList().size()) {
            log.debug((Object)("\u6570\u91cf:" + this.getQuantity(index)));
            int i = 0;
            while (i < this.getQuantity(index)) {
                print = this.executeLabelPrint(index);
                print.setPrinterData(this.posMain.getPrintService());
                if (print != null) {
                    nowThread = this.barcodePrintableThread(print, nowThread);
                    print = null;
                }
                ++i;
            }
            ++index;
        }
        if (!this.itemList.getFinished()) {
            this.itemList.finished();
        }
        log.info((Object)"\u30e9\u30d9\u30eb\u51fa\u529b:END");
    }

    private void initItemList() {
        this.itemList = this.posMain.getPosTabFolder().getPosAbstract()[this.getSelectionIndex()].getItemList();
    }

    private int getQuantity(int index) {
        return NumberUtils.toInt((String)this.itemList.getTableItemList().getItem(index).getText(10));
    }

    private int getSelectionIndex() {
        return this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex();
    }

    protected Thread barcodePrintableThread(Print print, Thread thread) {
        Thread printThread = new Thread(print);
        try {
            if (thread != null) {
                print.setWaittingThread(thread);
            }
            printThread.start();
            thread = printThread;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thread;
    }

    protected long toLongQuantity(Integer quantity) {
        if (quantity == null) {
            return 0L;
        }
        return quantity.longValue();
    }
}

