/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosFileUtils;
import jp.ne.k_tech.kposrcp.kpos.dialogs.ConfirmJournalDelete;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogJournalSearchResult;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.JournalSearchTableData;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Shell;

public class PosJournalSearchResult
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosJournalSearchResult.class);

    public PosJournalSearchResult(PosMain posMain, Shell self) {
        super(posMain, self);
    }

    public void enterDialog(DialogAbstract dialog) {
        log.info((Object)"\u30b8\u30e3\u30fc\u30ca\u30eb\u53d6\u6d88:START");
        DialogJournalSearchResult dialogJournalSearchResult = (DialogJournalSearchResult)dialog;
        List<JournalSearchTableData> list = dialogJournalSearchResult.getSelectedData();
        List<JournalSearchTableData> bodyList = dialogJournalSearchResult.getJournalSearchTableData();
        String kindCd = dialogJournalSearchResult.getKindCd();
        if (("U0".equals(kindCd) || "S0".equals(kindCd)) && list.size() > 0) {
            String slipNo = list.get(0).getSlipNo();
            int i = 0;
            while (i < list.size()) {
                JournalSearchTableData journalSearchTableData = list.get(i);
                if (!slipNo.equals(journalSearchTableData.getSlipNo()) || journalSearchTableData.getSeq() != i + 1) {
                    dialogJournalSearchResult.getButtonOk().setEnabled(true);
                    dialogJournalSearchResult.getJournalTable().setFocus();
                    if ("U0".equals(kindCd)) {
                        this.posMain.getStatusBar().setText("\u8ca9\u58f2\u306e\u30b8\u30e3\u30fc\u30ca\u30eb\u3092\u53d6\u308a\u6d88\u3059\u969b\u306b\u306f\u3001\u4f1d\u7968\u756a\u53f7\u5358\u4f4d\u3067\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    } else if ("S0".equals(kindCd)) {
                        this.posMain.getStatusBar().setText("\u5e97\u9593\u51fa\u5eab\u306e\u30b8\u30e3\u30fc\u30ca\u30eb\u3092\u53d6\u308a\u6d88\u3059\u969b\u306b\u306f\u3001\u4f1d\u7968\u756a\u53f7\u5358\u4f4d\u3067\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    }
                    log.debug((Object)"\u679d\u756a\u304c\u6b63\u3057\u304f\u306a\u3044\uff0e\uff0e");
                    return;
                }
                ++i;
            }
            int index = 0;
            index = 0;
            while (index < bodyList.size()) {
                if (slipNo.equals(bodyList.get(index).getSlipNo())) break;
                ++index;
            }
            int nextIndex = index + list.size();
            if (bodyList.size() != nextIndex && slipNo.equals(bodyList.get(nextIndex).getSlipNo())) {
                dialogJournalSearchResult.getButtonOk().setEnabled(true);
                dialogJournalSearchResult.getJournalTable().setFocus();
                log.debug((Object)"\u672a\u9078\u629e\u884c\u304c\u6b8b\u3063\u3066\u3044\u308b\uff0e\uff0e");
                if (PosConstants.SEARCH_MAX_RECORD <= nextIndex) {
                    this.posMain.getStatusBar().setText(String.format("%d\u4ef6\u76ee\u4ee5\u964d\u306b\u540c\u4e00\u4f1d\u7968\u756a\u53f7\u306e\u30b8\u30e3\u30fc\u30ca\u30eb\u304c\u5b58\u5728\u3057\u307e\u3059\u3002\u6761\u4ef6\u3092\u7d5e\u308a\u3001\u518d\u5ea6\u691c\u7d22\u3057\u3066\u304f\u3060\u3055\u3044\u3002", PosConstants.SEARCH_MAX_RECORD + 1));
                } else if ("U0".equals(kindCd)) {
                    this.posMain.getStatusBar().setText("\u8ca9\u58f2\u306e\u30b8\u30e3\u30fc\u30ca\u30eb\u3092\u53d6\u308a\u6d88\u3059\u969b\u306b\u306f\u3001\u4f1d\u7968\u756a\u53f7\u5358\u4f4d\u3067\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                } else if ("S0".equals(kindCd)) {
                    this.posMain.getStatusBar().setText("\u5e97\u9593\u51fa\u5eab\u306e\u30b8\u30e3\u30fc\u30ca\u30eb\u3092\u53d6\u308a\u6d88\u3059\u969b\u306b\u306f\u3001\u4f1d\u7968\u756a\u53f7\u5358\u4f4d\u3067\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                return;
            }
        }
        long sumAmount = 0L;
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).getAmount() != null) {
                sumAmount += list.get(i).getAmount().longValue();
            }
            ++i;
        }
        String message = String.valueOf(list.size()) + "\u4ef6\u306e\u30b8\u30e3\u30fc\u30ca\u30eb\u53d6\u6d88\u3057\u3092\u672c\u5f53\u306b\u78ba\u5b9a\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f\n\n\u78ba\u5b9a\u3057\u305f\u3042\u3068\u306b\u623b\u3059\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
        if (dialogJournalSearchResult.getKindCd().equals("U0")) {
            message = message.concat("\n\n\u8fd4\u91d1\u91d1\u984d\u306f " + sumAmount + "\u5186 \u3067\u3059\u3002");
        } else if (dialogJournalSearchResult.getKindCd().equals("B0")) {
            message = message.concat("\n\n\u53d7\u53d6\u91d1\u984d\u306f " + sumAmount + "\u5186 \u3067\u3059\u3002");
        }
        if (list.size() != 0) {
            ConfirmJournalDelete confirmJournalDelete;
            ConfirmJournalDelete confirm = confirmJournalDelete = new ConfirmJournalDelete(list, dialogJournalSearchResult.getKindCd(), sumAmount);
            confirm.execute(this.posMain, this.self, message);
            this.self.setFocus();
            if (confirmJournalDelete.isYes()) {
                this.self.close();
                if (dialogJournalSearchResult.getKindCd().equals("B0")) {
                    ArrayList<String> lineList = new ArrayList<String>();
                    String line = String.format("%d,%d", -1L * sumAmount, -1 * list.size());
                    lineList.add(line);
                    try {
                        PosFileUtils.appendLineToFile("recycle_summary.csv", lineList);
                    }
                    catch (IOException e) {
                        log.error((Object)("CSV\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(\u8cb7\u53d6\u5408\u8a08,\u4ef6\u6570) = (" + line + ")"), (Throwable)e);
                    }
                }
                this.posMain.getStatusBar().setText("\u691c\u7d22\u7d50\u679c\u4e00\u89a7\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            } else {
                dialogJournalSearchResult.getButtonOk().setEnabled(true);
                dialogJournalSearchResult.getJournalTable().setFocus();
                this.posMain.getStatusBar().setText("\u30b8\u30e3\u30fc\u30ca\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            dialogJournalSearchResult.getButtonOk().setEnabled(true);
            dialogJournalSearchResult.getJournalTable().setFocus();
            this.posMain.getStatusBar().setText("\u30b8\u30e3\u30fc\u30ca\u30eb\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        log.info((Object)"\u30b8\u30e3\u30fc\u30ca\u30eb\u53d6\u6d88:END");
    }
}

