/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.db.dao.ItemMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogItemSearch;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogItemSearchResult;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.ItemSearchTableData;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PosItemSearch
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosItemSearch.class);
    private static final int SEARCH_KEY_OFFICIAL_BARCODE = 0;
    private static final int SEARCH_KEY_ITEMCODE = 1;
    private static final int SEARCH_KEY_BARCODE = 2;
    private static final int SEARCH_KEY_ITEMNAME = 3;
    private List<ItemSearchTableData> listTable = null;

    public PosItemSearch(PosMain posMain, Shell self) {
        super(posMain, self);
    }

    public boolean enterDialog(DialogAbstract dialog) {
        log.info((Object)"\u691c\u7d22:START");
        DialogItemSearch dialogItemSearch = (DialogItemSearch)dialog;
        log.debug((Object)("\u30ad\u30fc\u30ef\u30fc\u30c9\uff1a" + dialogItemSearch.getKeyword()));
        log.debug((Object)("\u691c\u7d22\u65b9\u6cd5\uff1a" + dialogItemSearch.getKeyKindName()));
        dialogItemSearch.setKeyword(dialogItemSearch.getKeyword().trim());
        if (!dialogItemSearch.validate()) {
            log.info((Object)"\u691c\u7d22:END");
            return false;
        }
        ItemMstDAO itemMstDAO = new ItemMstDAO();
        List<ItemMst> list = null;
        itemMstDAO.setRownum(PosConstants.SEARCH_MAX_RECORD);
        switch (dialogItemSearch.getKeyKindCd()) {
            case 0: {
                list = itemMstDAO.findByOfficialBarcode(dialogItemSearch.getKeyword());
                this.setTableData(list);
                break;
            }
            case 1: {
                list = itemMstDAO.findByMakerCode(dialogItemSearch.getKeyword());
                this.setTableData(list);
                break;
            }
            case 2: {
                list = itemMstDAO.findByBarcode(dialogItemSearch.getKeyword());
                this.setTableData(list);
                break;
            }
            case 3: {
                list = itemMstDAO.findByItemname(dialogItemSearch.getKeyword());
                this.setTableData(list);
            }
        }
        log.debug((Object)("\u691c\u7d22\u7d50\u679c\u4ef6\u6570:" + this.listTable.size()));
        DialogItemSearchResult dialogItemSearchResult = new DialogItemSearchResult();
        dialogItemSearchResult.setSearchTableData(this.listTable);
        dialogItemSearchResult.setKindName(dialogItemSearch.getKeyKindName());
        dialogItemSearchResult.setKeyword(dialogItemSearch.getKeyword());
        this.self.close();
        DialogItemSearchResult dialogResult = dialogItemSearchResult;
        dialogResult.create(this.posMain, Display.getCurrent(), 0);
        this.posMain.getKeyEventHandler().setDialog(dialogResult);
        this.posMain.updateLabelSlipNo();
        this.posMain.getStatusBar().setText("\u691c\u7d22\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        log.info((Object)"\u691c\u7d22:END");
        return true;
    }

    public boolean enter(String barcode) {
        log.info((Object)"\u81ea\u52d5\u691c\u7d22:START");
        ItemMstDAO itemMstDAO = new ItemMstDAO();
        List<ItemMst> list = null;
        itemMstDAO.setRownum(PosConstants.SEARCH_MAX_RECORD);
        list = itemMstDAO.findByOfficialBarcode(barcode);
        this.setTableData(list);
        log.debug((Object)("\u81ea\u52d5\u691c\u7d22\u7d50\u679c\u4ef6\u6570:" + this.listTable.size()));
        DialogItemSearchResult dialogItemSearchResult = new DialogItemSearchResult();
        dialogItemSearchResult.setSearchTableData(this.listTable);
        dialogItemSearchResult.setKindName("JAN\u30b3\u30fc\u30c9(13\u6841)");
        dialogItemSearchResult.setKeyword(barcode);
        dialogItemSearchResult.create(this.posMain, Display.getCurrent(), 0);
        this.posMain.getKeyEventHandler().setDialog(dialogItemSearchResult);
        this.posMain.updateLabelSlipNo();
        this.posMain.getStatusBar().setText("\u691c\u7d22\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        log.info((Object)"\u81ea\u52d5\u691c\u7d22:END");
        return true;
    }

    private void setTableData(List<ItemMst> list) {
        this.listTable = new ArrayList<ItemSearchTableData>();
        ItemSearchTableData searchTableData = null;
        int i = 0;
        while (i < list.size()) {
            searchTableData = new ItemSearchTableData(list.get(i), null, 0L);
            this.listTable.add(searchTableData);
            ++i;
        }
    }
}

