/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.KindMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmSlip;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogExpense;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.receipt.ReceiptExpense;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PosExpense
extends LogicAbstract {
    private static Log log = LogFactory.getLog(PosExpense.class);
    private ReceiptAbstract receiptExpense = null;

    public PosExpense(PosMain posMain) {
        super(posMain);
    }

    public boolean enterDialog(DialogAbstract dialog) {
        log.info((Object)"\u51fa\u91d1:START");
        DialogExpense dialogExpense = (DialogExpense)dialog;
        log.debug((Object)("\u51fa\u91d1\u306e\u4f7f\u9014\uff1a" + dialogExpense.getReason()));
        log.debug((Object)("\u51fa\u91d1\u306e\u91d1\u984d\uff1a" + dialogExpense.getExpense()));
        if (!dialogExpense.validate()) {
            log.info((Object)"\u51fa\u91d1:END");
            return false;
        }
        DbmSlip dbmSlip = new DbmSlip();
        Slip slip = new Slip();
        try {
            slip.setKindMst(MstManager.getInstance().findKindMstByCD("O0"));
        }
        catch (AbsentMstException e) {
            log.debug((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            KindMst kindMst = new KindMst();
            kindMst.setKindCd("O0");
            slip.setKindMst(kindMst);
        }
        slip.setEmpCd(this.posMain.getPosEmpMst().getEmpCd().trim());
        JournalHead journalHead = new JournalHead();
        journalHead.setEmpCd(this.posMain.getPosEmpMst().getEmpCd().trim());
        journalHead.setOutMoney(Long.valueOf(dialogExpense.getExpense()));
        journalHead.setInfo(dialogExpense.getReason());
        String slipNo = dbmSlip.regist(slip, journalHead);
        this.receiptExpense = new ReceiptExpense();
        this.receiptExpense.setJournalHead(journalHead);
        this.receiptExpense.executePrint(this.posMain, slipNo);
        OposController.getInstance().getCashDrawer().open();
        this.posMain.updateLabelSlipNo();
        this.posMain.getStatusBar().setText("\u51fa\u91d1\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        log.info((Object)"\u51fa\u91d1:END");
        return true;
    }
}

