/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.logic;

import java.awt.Toolkit;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosCommon;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.exception.ItemNotFoundException;
import jp.ne.k_tech.kposrcp.kpos.db.dao.ItemMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMstPK;
import jp.ne.k_tech.kposrcp.kpos.dbm.DbmBarcode;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogScan;
import jp.ne.k_tech.kposrcp.kpos.list.ItemList;
import jp.ne.k_tech.kposrcp.kpos.logic.LogicAbstract;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;

public class BarcodeScanner
extends LogicAbstract {
    private static Log log = LogFactory.getLog(BarcodeScanner.class);
    private static final int MODE_SEARCH = 0;
    private static final int MODE_WAIT_978 = 10;
    private static final int MODE_WAIT_192 = 11;
    private ItemList itemList = null;
    private DbmBarcode dbmBarcode = null;
    private String upper = null;
    private String lower = null;
    private String magazine = null;
    private String classCd = null;
    private String genreCd = null;
    private int mode = -1;

    public BarcodeScanner(PosMain posMain, ItemList itemList) {
        super(posMain);
        this.itemList = itemList;
        this.dbmBarcode = MstManager.getInstance().getDbmBarcode();
        this.reset();
    }

    private boolean validate(String barcode) {
        if (barcode.startsWith("491")) {
            if (barcode.length() != 18) {
                this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u304c\u4e0d\u6b63\u3067\u3059\u3002[%s]", barcode));
                Toolkit.getDefaultToolkit().beep();
                return false;
            }
        } else {
            if (barcode.toUpperCase().endsWith("A")) {
                this.posMain.getStatusBar().setText(String.format("\u3053\u306e\u30d0\u30fc\u30b3\u30fc\u30c9\u306f\u3053\u3053\u3067\u306f\u30b9\u30ad\u30e3\u30f3\u3067\u304d\u307e\u305b\u3093\u3002[%s]", "\u793e\u54e1\u8a3c\u30d0\u30fc\u30b3\u30fc\u30c9"));
                return false;
            }
            if (barcode.length() != 13 || !NumberUtils.isDigits((String)barcode)) {
                this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u304c\u4e0d\u6b63\u3067\u3059\u3002[%s]", barcode));
                Toolkit.getDefaultToolkit().beep();
                return false;
            }
        }
        return true;
    }

    public void scan(String barcode) {
        barcode = PosCommon.convertISBN2JAN(barcode);
        barcode = PosCommon.convertDual2JAN(barcode);
        log.debug((Object)("\u30d0\u30fc\u30b3\u30fc\u30c9\uff1a" + barcode));
        if (!this.validate(barcode)) {
            return;
        }
        if (barcode.startsWith("491") || barcode.startsWith("11") || barcode.startsWith("192") || barcode.startsWith("191")) {
            this.normalScan(barcode);
        } else {
            try {
                this.masterScan(barcode);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                this.normalScan(barcode);
            }
        }
    }

    private void normalScan(String barcode) {
        log.debug((Object)"nomalScan");
        switch (this.mode) {
            case 11: {
                if (barcode.startsWith("192") || barcode.startsWith("191")) {
                    this.lower = barcode;
                    this.mode = 0;
                    this.classCd = this.dbmBarcode.findCategory(4000209);
                    this.genreCd = this.dbmBarcode.findGenre(0x2DD282);
                    try {
                        this.itemList.addRow(this.createItemMst());
                    }
                    catch (AbsentMstException e) {
                        log.info((Object)String.format("\u540d\u524d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[%s]", barcode), (Throwable)e);
                        this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode));
                    }
                    this.reset();
                    return;
                }
                this.reset();
                break;
            }
            case 10: {
                if (barcode.startsWith("978")) {
                    this.upper = barcode;
                    this.mode = 0;
                    this.classCd = this.dbmBarcode.findCategory(4000209);
                    this.genreCd = this.dbmBarcode.findGenre(0x2DD282);
                    try {
                        this.itemList.addRow(this.createItemMst());
                    }
                    catch (AbsentMstException e) {
                        log.info((Object)String.format("\u540d\u524d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[%s]", barcode), (Throwable)e);
                        this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode));
                    }
                    this.reset();
                    return;
                }
                this.reset();
                break;
            }
        }
        if (barcode.startsWith("491")) {
            this.magazine = barcode;
            this.classCd = this.dbmBarcode.findCategory(4000223);
            this.genreCd = this.dbmBarcode.findGenre(3003034);
            try {
                this.itemList.addRow(this.createItemMst());
            }
            catch (AbsentMstException e) {
                log.info((Object)String.format("\u540d\u524d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[%s]", barcode), (Throwable)e);
                this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode));
            }
            this.reset();
        } else if (barcode.startsWith("11")) {
            this.magazine = barcode;
            this.classCd = this.dbmBarcode.findCategory(4000223);
            this.genreCd = this.dbmBarcode.findGenre(3003034);
            try {
                this.itemList.addRow(this.createItemMst());
            }
            catch (AbsentMstException e) {
                log.info((Object)String.format("\u540d\u524d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[%s]", barcode), (Throwable)e);
                this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode));
            }
            this.reset();
        } else if (barcode.startsWith("192") || barcode.startsWith("191")) {
            this.lower = barcode;
            this.mode = 10;
            this.posMain.getStatusBar().setText("\u66f8\u7c4d\u4e0a\u6bb5\u30d0\u30fc\u30b3\u30fc\u30c9\u3092\u8aad\u307f\u53d6\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
        } else if (this.dbmBarcode.isStaffBarcode(barcode)) {
            this.reset();
            this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode));
        } else {
            try {
                ItemMst itemMst = this.search(barcode);
                if (itemMst != null) {
                    try {
                        this.itemList.addRow(itemMst);
                    }
                    catch (AbsentMstException e) {
                        log.debug((Object)String.format("\u540d\u524d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[%s]", barcode), (Throwable)e);
                        this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode));
                        throw new ItemNotFoundException(e);
                    }
                }
                this.reset();
            }
            catch (ItemNotFoundException itemNotFoundException) {
                if (barcode.startsWith("978")) {
                    this.upper = barcode;
                    this.mode = 11;
                    this.posMain.getStatusBar().setText("\u66f8\u7c4d\u4e0b\u6bb5\u30d0\u30fc\u30b3\u30fc\u30c9\u3092\u8aad\u307f\u53d6\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                this.mode = 0;
                this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode));
                this.reset();
            }
        }
    }

    private void masterScan(String barcode) throws ItemNotFoundException {
        log.debug((Object)"masterScan");
        String message = null;
        try {
            if (this.dbmBarcode.isItem(barcode)) {
                this.itemList.getTabindex();
                message = String.format("\u3053\u306e\u30d0\u30fc\u30b3\u30fc\u30c9\u306f\u3053\u3053\u3067\u306f\u30b9\u30ad\u30e3\u30f3\u3067\u304d\u307e\u305b\u3093\u3002[\u30b9\u30bf\u30c3\u30d5\u30d0\u30fc\u30b3\u30fc\u30c9]", new Object[0]);
                throw new ItemNotFoundException();
            }
            if (this.dbmBarcode.isStaffBarcode(barcode)) {
                throw new ItemNotFoundException();
            }
            ItemMst itemMst = this.search(barcode);
            if (itemMst != null) {
                try {
                    this.itemList.addRow(itemMst);
                }
                catch (AbsentMstException e) {
                    log.debug((Object)String.format("\u540d\u524d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[%s]", barcode), (Throwable)e);
                    message = String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode);
                    throw new ItemNotFoundException(e);
                }
            }
            this.reset();
        }
        catch (ItemNotFoundException e) {
            if (StringUtils.isEmpty(message)) {
                this.posMain.getStatusBar().setText(String.format("\u30d0\u30fc\u30b3\u30fc\u30c9\u306b\u8a72\u5f53\u3059\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002[%s]", barcode));
            } else {
                this.posMain.getStatusBar().setText(message);
            }
            this.reset();
            throw new ItemNotFoundException(e);
        }
    }

    private ItemMst search(String barcode) throws ItemNotFoundException {
        ItemMst itemMst = null;
        ItemMstDAO itemMstDAO = new ItemMstDAO();
        List<ItemMst> list = itemMstDAO.findByBarcode(barcode);
        switch (list.size()) {
            case 0: {
                throw new ItemNotFoundException();
            }
            case 1: {
                itemMst = list.get(0);
                break;
            }
            default: {
                DialogScan dialog = new DialogScan(barcode, list);
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.posMain.getKeyEventHandler().setDialog(dialog);
            }
        }
        return itemMst;
    }

    public void reset() {
        this.mode = 0;
        this.upper = null;
        this.lower = null;
        this.magazine = null;
        this.classCd = null;
        this.genreCd = null;
    }

    private ItemMst createItemMst() {
        long price = 0L;
        String barcode = null;
        String taxkind = null;
        String title = "";
        if (this.magazine != null && this.magazine.startsWith("491")) {
            price = NumberUtils.toLong((String)this.magazine.substring(14, 18));
            barcode = this.magazine.substring(0, 13);
            taxkind = "1";
            title = "\u96d1\u8a8c";
        } else if (this.magazine != null && this.magazine.startsWith("11")) {
            price = NumberUtils.toLong((String)this.magazine.substring(9, 12)) * 10L;
            barcode = this.magazine;
            taxkind = "0";
            title = "\u96d1\u8a8c";
        } else {
            price = NumberUtils.toLong((String)this.lower.substring(7, 12));
            barcode = this.upper;
            taxkind = "1";
            title = "\u66f8\u7c4d";
        }
        ItemMstPK itemMstPK = new ItemMstPK();
        ItemMst itemMst = new ItemMst();
        switch (this.itemList.getTabindex()) {
            case 0: {
                itemMstPK.setItemCd(barcode);
                itemMstPK.setSuppCd("0101");
                itemMst.setComp_id(itemMstPK);
                itemMst.setMakerCd(itemMstPK.getItemCd());
                itemMst.setItemName(title);
                itemMst.setLabelCd("000000");
                itemMst.setClassCd(this.classCd);
                itemMst.setGenreCd(this.genreCd);
                itemMst.setPrice(price);
                itemMst.setPriceTaxKind(taxkind);
                itemMst.setMakerPrice(price);
                itemMst.setCost(price);
                itemMst.setCostTaxKind(taxkind);
                itemMst.setBarcode(itemMstPK.getItemCd());
                itemMst.setStockKind("1");
                break;
            }
        }
        return itemMst;
    }
}

