/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.list;

import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.gui.component.ExGridData;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ScanList {
    private Table tableScanList = null;
    private List<ItemMst> bodyList = null;

    public ScanList(PosMain posMain, List<ItemMst> list) {
        this.bodyList = list;
    }

    public void createScanList(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, false));
        area.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.tableScanList = new Table(area, 67588);
        this.tableScanList.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.tableScanList.setLinesVisible(true);
        this.tableScanList.setHeaderVisible(true);
        this.initScanTableHeader();
        this.refreshBody();
        if (this.tableScanList.getItemCount() > 0) {
            this.tableScanList.setSelection(0);
        }
    }

    private void initScanTableHeader() {
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < PosConstants.COLUMN_NAME_SCAN.length) {
            TableColumn col = new TableColumn(this.tableScanList, 16384);
            col.setText(PosConstants.COLUMN_NAME_SCAN[i]);
            int w = PosConstants.COLUMN_WIDTH_SCAN[i];
            layout.addColumnData((ColumnLayoutData)(w > 0 ? new ColumnWeightData(w) : new ColumnPixelData(0)));
            col.setResizable(w > 0);
            if (ArrayUtils.contains((Object[])PosConstants.COLUMN_NAMES_ALIGN_RIGHT, (Object)PosConstants.COLUMN_NAME_SCAN[i])) {
                col.setAlignment(131072);
            }
            ++i;
        }
        this.tableScanList.setLayout((Layout)layout);
        this.tableScanList.layout();
    }

    private void refreshBody() {
        MstManager mstManager = MstManager.getInstance();
        ArrayList<ItemMst> resultList = new ArrayList<ItemMst>();
        int i = 0;
        while (i < this.bodyList.size()) {
            block3: {
                ItemMst itemMst = this.bodyList.get(i);
                String className = null;
                try {
                    className = mstManager.findClassNameByCD(itemMst.getClassCd());
                    mstManager.findSupplierNameByCD(itemMst.getComp_id().getSuppCd());
                    mstManager.findGenreNameByCD(itemMst.getGenreCd());
                    mstManager.findTaxKindNameByCD(itemMst.getCostTaxKind());
                }
                catch (AbsentMstException absentMstException) {
                    break block3;
                }
                TableItem item = new TableItem(this.tableScanList, 0);
                int count = this.tableScanList.getItemCount();
                item.setBackground(count % 2 == 1 ? JFaceResources.getColorRegistry().get("white") : JFaceResources.getColorRegistry().get("aliceblue"));
                item.setImage(Activator.getDefault().getImageRegistry().get("bgdummy"));
                int col = 0;
                item.setText(col++, this.toStr(this.tableScanList.getItemCount()));
                item.setText(col++, this.toStr(itemMst.getMakerCd()));
                item.setText(col++, className);
                item.setText(col++, this.toStr(itemMst.getItemName()));
                item.setText(col++, this.toStr(itemMst.getItemNum()));
                item.setText(col++, this.toCurrency(itemMst.getPrice()));
                resultList.add(itemMst);
            }
            ++i;
        }
        this.bodyList.clear();
        this.bodyList.addAll(resultList);
        this.tableScanList.select(0);
    }

    public Table getTableScanList() {
        return this.tableScanList;
    }

    public ItemMst getSelectedData() {
        int index = this.tableScanList.getSelectionIndex();
        return index < 0 ? null : this.bodyList.get(index);
    }

    private String toStr(Integer target) {
        return ObjectUtils.toString((Object)target);
    }

    private String toStr(int target) {
        return String.valueOf(target);
    }

    private String toStr(String target) {
        return StringUtils.defaultString((String)target);
    }

    private String toCurrency(long target) {
        return PosNumberUtils.currencyFormat(target);
    }
}

