/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.list;

import java.awt.Toolkit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosBeanUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosFileUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.SetMstDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ClassMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.SetMst;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogCannotRecycle;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogSetConfirm;
import jp.ne.k_tech.kposrcp.kpos.list.ItemList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ItemListRecycle
extends ItemList {
    private static Log log = LogFactory.getLog(ItemListRecycle.class);
    private List<BigDecimal> recycleUpAmountList;
    private int upRate = 0;
    private Set<String> scannedBarcodeSet;

    public ItemListRecycle(PosMain posMain, int tabindex) {
        super(posMain, tabindex);
        String filePath = "recycleBuyUp.txt";
        List<String> text = PosFileUtils.readTextFile2List(filePath);
        if (text.size() > 0) {
            this.upRate = NumberUtils.toInt((String)text.get(0), (int)0);
        }
        log.debug((Object)("\u8cb7\u53d6UP\u7387\uff1a" + this.upRate));
        if (this.recycleUpAmountList == null) {
            this.recycleUpAmountList = new ArrayList<BigDecimal>();
        } else {
            this.clearRecycleUpList();
        }
        this.scannedBarcodeSet = new HashSet<String>();
    }

    @Override
    public void addRow(ItemMst itemMst) throws AbsentMstException {
        if ("1".equals(itemMst.getUsedFlag())) {
            log.debug((Object)"\u8cb7\u53d6\u5bfe\u8c61\u5916\uff08\u4e2d\u53e4\uff09");
            this.posMain.getStatusBar().setText("\u65b0\u54c1\u5546\u54c1\u4ee5\u5916\u3092\u4e2d\u53e4\u8cb7\u53d6\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        ClassMst classMst = MstManager.getInstance().findClassMstByCD(itemMst.getClassCd());
        if ("0".equals(classMst.getRecycleFlag())) {
            Toolkit.getDefaultToolkit().beep();
            DialogCannotRecycle dialogCannotRecycle = new DialogCannotRecycle();
            dialogCannotRecycle.create(this.posMain, Display.getCurrent(), 0);
            this.posMain.getKeyEventHandler().setDialog(dialogCannotRecycle);
            log.debug((Object)String.format("\u8cb7\u53d6\u5bfe\u8c61\u5916\u5206\u985e[%s]", itemMst.getClassCd()));
            return;
        }
        super.addRow(itemMst);
        this.addBarcode(itemMst.getBarcode());
        this.upRate(this.tableItemList.getItemCount() - 1, itemMst.getClassCd());
        this.findSet(itemMst);
    }

    protected void findSet(ItemMst itemMst) throws AbsentMstException {
        SetMstDAO setMstDAO = new SetMstDAO();
        List<SetMst> list = setMstDAO.findByBarcode(itemMst.getBarcode());
        int i = 0;
        while (i < list.size()) {
            List<SetMst> setList = setMstDAO.findByParentBarcode(list.get(i).getComp_id().getParentBarcode());
            int[] indices = this.existAll(setList);
            if (indices != null) {
                log.debug((Object)("found all elements! indices are " + PosStringUtils.toString4Bean(indices)));
                DialogSetConfirm dialogSetConfirm = new DialogSetConfirm(setList);
                this.posMain.getKeyEventHandler().setDialog(dialogSetConfirm);
                int result = dialogSetConfirm.open(this.posMain, Display.getCurrent(), 0);
                if (result == 64) {
                    log.debug((Object)"buy by bundle.");
                    this.bundle(indices, dialogSetConfirm.getSetName(), dialogSetConfirm.getAdditionalAmount());
                } else {
                    log.debug((Object)"not buy by bundle.");
                }
            } else {
                log.debug((Object)String.format("not found all elements![%s]", itemMst.getBarcode()));
            }
            ++i;
        }
    }

    protected void bundle(int[] indices, String setName, long additionalAmount) throws AbsentMstException {
        log.debug((Object)"SET\u8cb7\u53d6\u51e6\u7406:START");
        List<ItemMst> bodyList = this.getBodyList();
        ItemMst itemMst = PosBeanUtils.cloneObject(bodyList.get(indices[indices.length - 1]));
        int[] revIndices = ArrayUtils.clone((int[])indices);
        log.debug((Object)("indices is " + PosStringUtils.toString4Bean(revIndices)));
        Arrays.sort(revIndices);
        ArrayUtils.reverse((int[])revIndices);
        log.debug((Object)("reversed indices is " + PosStringUtils.toString4Bean(revIndices)));
        log.debug((Object)("original indices is " + PosStringUtils.toString4Bean(indices)));
        long makerPrice = 0L;
        long price = 0L;
        long recycleSalePrice = 0L;
        long recycleBuyPrice = 0L;
        Table table = this.getTableItemList();
        long upAmountTotal = 0L;
        int i = 0;
        while (i < revIndices.length) {
            TableItem item = table.getItem(revIndices[i]);
            makerPrice += NumberUtils.toLong((String)item.getText(8));
            price += NumberUtils.toLong((String)item.getText(9));
            recycleSalePrice += NumberUtils.toLong((String)item.getText(10));
            recycleBuyPrice += NumberUtils.toLong((String)item.getText(11));
            upAmountTotal += this.recycleUpAmountList.get(revIndices[i]).longValue();
            this.recycleUpAmountList.remove(revIndices[i]);
            this.removeRow(revIndices[i]);
            ++i;
        }
        recycleBuyPrice += additionalAmount;
        itemMst.setSetFlag("1");
        itemMst.setEndFlag("1");
        itemMst.setItemName("[SET]" + setName);
        itemMst.setMakerPrice(makerPrice);
        itemMst.setPrice(price);
        this.addRow(itemMst);
        this.recycleUpAmountList.set(this.recycleUpAmountList.size() - 1, BigDecimal.valueOf(upAmountTotal));
        TableItem item = this.getTableItemSelected();
        item.setText(8, Long.toString(makerPrice));
        item.setText(9, Long.toString(price));
        item.setText(10, Long.toString(recycleSalePrice));
        item.setText(11, Long.toString(recycleBuyPrice));
        this.showDisplay();
        this.posMain.getPosTabFolder().updateTableFooter();
        log.debug((Object)"SET\u8cb7\u53d6\u51e6\u7406:END");
    }

    protected int[] existAll(List<SetMst> list) {
        int[] indices = null;
        List<ItemMst> bodyList = this.getBodyList();
        boolean found = false;
        for (SetMst setMst : list) {
            String barcode = setMst.getComp_id().getBarcode();
            found = false;
            int i = 0;
            while (i < bodyList.size()) {
                ItemMst itemMst = bodyList.get(i);
                if (!"1".equals(itemMst.getSetFlag()) && barcode.equals(itemMst.getBarcode())) {
                    indices = ArrayUtils.add((int[])indices, (int)i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            return null;
        }
        return indices;
    }

    @Override
    public void copyTableItem(int selectionIndex) throws AbsentMstException {
        log.debug((Object)("\u30b3\u30d4\u30fc\u5143 selectionIndex =" + selectionIndex));
        BigDecimal upAmount = this.recycleUpAmountList.get(selectionIndex);
        this.recycleUpAmountList.add(upAmount);
        log.debug((Object)("\u30b3\u30d4\u30fc\u884c\u306e\u8cb7\u53d6UP\u91d1\u984d: " + upAmount + "\u5186"));
        super.copyTableItem(selectionIndex);
    }

    @Override
    public void finished() {
        super.finished();
        this.clearRecycleUpList();
        log.debug((Object)"\u8cb7\u53d6\u78ba\u5b9a\uff01\uff01");
    }

    @Override
    public void removeRow() {
        int index = this.tableItemList.getSelectionIndex();
        ItemMst item = this.getBodyList().get(index);
        if ("1".equals(item.getSetFlag())) {
            this.removeSetBarcodes(item.getBarcode());
        } else {
            this.removeBarcode(item.getBarcode());
        }
        super.removeRow();
        if (index >= 0) {
            log.debug((Object)("\u8cb7\u53d6UP\u91d1\u524a\u9664:" + index));
            this.recycleUpAmountList.remove(index);
        }
    }

    private void upRate(int lineIndex, String classCd) {
        log.debug((Object)"\u8cb7\u53d6UP\u51e6\u7406START");
        long amount = 0L;
        TableItem tableItem = this.getTableItemList().getItem(lineIndex);
        int upRateOfClass = MstManager.getInstance().getUpRateByClassCd(classCd);
        amount = PosNumberUtils.multiplyPercent(NumberUtils.toLong((String)tableItem.getText(11)), this.upRate + upRateOfClass + 100, Activator.getDefault().getPreferenceStore().getInt("ROUNDING_MODE_RECYCLE"));
        this.recycleUpAmountList.add(BigDecimal.valueOf(amount - NumberUtils.toLong((String)tableItem.getText(11))));
        log.debug((Object)("\u8cb7\u53d6UP\u91d1\u984d: " + this.recycleUpAmountList.get(lineIndex) + "\u5186"));
        tableItem.setText(11, String.valueOf(amount));
        this.posMain.getPosTabFolder().updateTableFooter();
        if (upRateOfClass > 0) {
            this.posMain.getStatusBar().setText(String.format("\u5206\u985e\u5225\u8cb7\u53d6UP\u7387\u306e\u9069\u7528\u304c\u6b63\u5e38\u306b\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002[\u5206\u985e\uff1a%s UP\u7387\uff1a%d%%]", tableItem.getText(3), upRateOfClass));
        }
        log.debug((Object)"\u8cb7\u53d6UP\u51e6\u7406END");
    }

    public List<BigDecimal> getRecycleUpAmountList() {
        return this.recycleUpAmountList;
    }

    private void clearRecycleUpList() {
        this.recycleUpAmountList.clear();
    }

    public boolean existsSameItem(String barcode) {
        return this.scannedBarcodeSet.contains(barcode);
    }

    public void addBarcode(String barcode) {
        log.debug((Object)String.format("\u8a18\u61b6\u30d0\u30fc\u30b3\u30fc\u30c9\u30bb\u30c3\u30c8\u306b\u8ffd\u52a0[%s]", barcode));
        this.scannedBarcodeSet.add(barcode);
    }

    private void removeBarcode(String barcode) {
        log.debug((Object)String.format("\u8a18\u61b6\u30d0\u30fc\u30b3\u30fc\u30c9\u30bb\u30c3\u30c8\u304b\u3089\u524a\u9664[%s]", barcode));
        this.scannedBarcodeSet.remove(barcode);
    }

    private void removeSetBarcodes(String keyBarcode) {
        SetMstDAO setMstDAO = new SetMstDAO();
        List<SetMst> deleteTargetList = setMstDAO.findByParentBarcode(keyBarcode);
        for (SetMst deleteTarget : deleteTargetList) {
            this.removeBarcode(deleteTarget.getComp_id().getBarcode());
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        log.debug((Object)"\u8a18\u61b6\u30d0\u30fc\u30b3\u30fc\u30c9\u30bb\u30c3\u30c8\u30af\u30ea\u30a2");
        this.scannedBarcodeSet.clear();
        this.clearRecycleUpList();
    }

    public int getUpRate() {
        return this.upRate;
    }
}

