/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.list;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosBeanUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosDateUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.RankMst;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogSameItem;
import jp.ne.k_tech.kposrcp.kpos.gui.component.ExGridData;
import jp.ne.k_tech.kposrcp.kpos.gui.component.MoneyText;
import jp.ne.k_tech.kposrcp.kpos.gui.component.QuantityText;
import jp.ne.k_tech.kposrcp.kpos.list.EditableColumns;
import jp.ne.k_tech.kposrcp.kpos.list.ItemListRecycle;
import jp.ne.k_tech.kposrcp.kpos.logic.BarcodeScanner;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayAbstract;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplayItem;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ItemList {
    private static Log log = LogFactory.getLog(ItemList.class);
    protected PosMain posMain = null;
    protected Table tableItemList = null;
    private TableCursor cursor = null;
    private int tabindex = -1;
    private List<ItemMst> bodyList = null;
    private boolean finished = false;
    private BarcodeScanner barcodeScanner = null;
    private DisplayAbstract displayItem = null;
    private boolean isDisplay = true;

    public ItemList(PosMain posMain, int tabindex) {
        this.posMain = posMain;
        this.finished = false;
        this.bodyList = new ArrayList<ItemMst>();
        this.tabindex = tabindex;
        this.barcodeScanner = new BarcodeScanner(posMain, this);
        this.displayItem = new DisplayItem();
    }

    public void createItemList(Composite base, Composite parent, final EditableColumns editable) {
        Composite area;
        if (base == null) {
            area = new Composite(parent, 0);
            area.setLayout((Layout)new GridLayout(1, false));
            area.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
            Label label = new Label(area, 0);
            if (editable != null) {
                label.setText("\u5546\u54c1\u4e00\u89a7");
            } else {
                label.setText("\u5546\u54c1\u4e00\u89a7");
            }
        } else {
            area = base;
        }
        this.tableItemList = new Table(area, 67588);
        this.tableItemList.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.tableItemList.setLinesVisible(true);
        this.tableItemList.setHeaderVisible(true);
        this.tableItemList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemList.this.setTableSelectedIndex(ItemList.this.tableItemList);
            }
        });
        this.cursor = new TableCursor(this.tableItemList, 0);
        final ControlEditor editor = new ControlEditor((Composite)this.cursor);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemList.this.tableItemList.setSelection(new TableItem[]{ItemList.this.cursor.getRow()});
            }
        });
        if (editable != null) {
            this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    log.debug((Object)("widgetDefaultSelected():" + e.getSource().toString()));
                    ItemList.this.editCell(editable, editor);
                }
            });
            this.cursor.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    log.debug((Object)("mouseDoubleClick():" + e.getSource().toString()));
                    ItemList.this.editCell(editable, editor);
                }
            });
        }
        this.cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144 || e.keyCode == 131072 || (e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    ItemList.this.cursor.setVisible(false);
                }
            }
        });
        this.tableItemList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                e.doit = false;
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (ItemList.this.tableItemList.getItemCount() > 0) {
                    TableItem[] selection = ItemList.this.tableItemList.getSelection();
                    TableItem row = selection.length == 0 ? ItemList.this.tableItemList.getItem(ItemList.this.tableItemList.getTopIndex()) : selection[0];
                    ItemList.this.tableItemList.showItem(row);
                    ItemList.this.cursor.setSelection(row, 0);
                    ItemList.this.cursor.setVisible(true);
                    ItemList.this.cursor.setFocus();
                }
            }
        });
        this.cursor.setFont(this.posMain.getNormalFont());
        this.tableItemList.setFont(JFaceResources.getFontRegistry().getBold("mspgo12n"));
    }

    private void editCell(final EditableColumns editable, ControlEditor editor) {
        int column = this.cursor.getColumn();
        if (!editable.isEditable(this.tableItemList.getColumns()[column].getText())) {
            return;
        }
        final Text edittingText = this.tableItemList.getColumns()[column].getText().indexOf("\u6570") >= 0 ? new QuantityText(this.posMain, (Composite)this.cursor).getSmallText(true) : new MoneyText(this.posMain, (Composite)this.cursor).getSmallText(true);
        TableItem row = this.cursor.getRow();
        edittingText.setText(row.getText(column));
        edittingText.selectAll();
        edittingText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == '\u1000050') {
                    int column = ItemList.this.cursor.getColumn();
                    if (!editable.isEditable(ItemList.this.tableItemList.getColumns()[column].getText())) {
                        e.doit = false;
                        edittingText.dispose();
                        return;
                    }
                    TableItem row = ItemList.this.cursor.getRow();
                    String colName = ItemList.this.tableItemList.getColumns()[column].getText();
                    if (colName.indexOf("\u6570") < 0 || edittingText.getText().getBytes().length <= 4) {
                        long l = NumberUtils.toLong((String)edittingText.getText(), (long)-1L);
                        if (colName.indexOf("\u4ed5") >= 0 && l >= 0L) {
                            row.setText(column, String.valueOf(l));
                        } else if (colName.indexOf("\u6570") >= 0 && l > 0L) {
                            row.setText(column, String.valueOf(l));
                        } else if (colName.indexOf("\u8ca9") >= 0 && l > 0L) {
                            row.setText(column, String.valueOf(l));
                        } else if (colName.indexOf("\u91d1") >= 0 && l > 0L) {
                            row.setText(column, String.valueOf(l));
                        } else {
                            edittingText.dispose();
                        }
                    }
                    if (!edittingText.isDisposed()) {
                        edittingText.dispose();
                    }
                    ItemList.this.setRecyclePrice(ItemList.this.tableItemList.getSelectionIndex(), null);
                    ItemList.this.showDisplay();
                    ItemList.this.posMain.getPosTabFolder().updateTableFooter();
                    log.debug((Object)("widgetDefaultSelected():row=" + row + " column=" + column));
                }
                if (e.character == '\u001b') {
                    edittingText.dispose();
                }
            }
        });
        edittingText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                int column = ItemList.this.cursor.getColumn();
                if (!editable.isEditable(ItemList.this.tableItemList.getColumns()[column].getText())) {
                    edittingText.dispose();
                    return;
                }
                TableItem row = ItemList.this.cursor.getRow();
                String colName = ItemList.this.tableItemList.getColumns()[column].getText();
                if (colName.indexOf("\u6570") < 0 || edittingText.getText().getBytes().length <= 4) {
                    long l = NumberUtils.toLong((String)edittingText.getText(), (long)-1L);
                    if (colName.indexOf("\u4ed5") >= 0 && l >= 0L) {
                        row.setText(column, String.valueOf(l));
                    } else if (colName.indexOf("\u6570") >= 0 && l > 0L) {
                        row.setText(column, String.valueOf(l));
                    } else if (colName.indexOf("\u8ca9") >= 0 && l > 0L) {
                        row.setText(column, String.valueOf(l));
                    } else if (colName.indexOf("\u91d1") >= 0 && l > 0L) {
                        row.setText(column, String.valueOf(l));
                    } else {
                        edittingText.dispose();
                    }
                }
                if (!edittingText.isDisposed()) {
                    edittingText.dispose();
                }
                ItemList.this.setRecyclePrice(ItemList.this.tableItemList.getSelectionIndex(), null);
                ItemList.this.showDisplay();
                ItemList.this.posMain.getPosTabFolder().updateTableFooter();
                log.debug((Object)("widgetDefaultSelected():row=" + row + " column=" + column));
            }
        });
        editor.setEditor((Control)edittingText);
        edittingText.setFocus();
    }

    public void addRow(ItemMst itemMst) throws AbsentMstException {
        if (this.finished) {
            this.removeAll();
            this.finished = false;
        }
        MstManager mstManager = MstManager.getInstance();
        String className = mstManager.findClassNameByCD(itemMst.getClassCd());
        String labelName = mstManager.findLabelNameByCD(itemMst.getLabelCd());
        RankMst rankMst = null;
        String itemCd = itemMst.getMakerCd();
        rankMst = mstManager.findRank(itemMst.getClassCd(), itemMst.getOnsaleDate(), itemMst.getRankCd());
        TableItem item = new TableItem(this.tableItemList, 0);
        int count = this.tableItemList.getItemCount();
        item.setBackground(count % 2 == 1 ? JFaceResources.getColorRegistry().get("white") : JFaceResources.getColorRegistry().get("aliceblue"));
        item.setImage(Activator.getDefault().getImageRegistry().get("bgdummy"));
        int col = 0;
        item.setText(col++, this.toStr(this.tableItemList.getItemCount()));
        item.setText(col++, this.toStr(itemMst.getBarcode()));
        item.setText(col++, this.toStr(itemCd));
        item.setText(col++, className);
        item.setText(col++, this.toStr(itemMst.getItemName()));
        item.setText(col++, ObjectUtils.toString((Object)itemMst.getItemNum()));
        item.setText(col++, this.toStr(itemMst.getItemDetail2()));
        item.setText(col++, labelName);
        switch (this.tabindex) {
            case 0: {
                item.setText(col++, this.toStr(itemMst.getFirstDate()));
                item.setText(col++, this.toStr(itemMst.getLastDate()));
                item.setText(col++, String.valueOf(1));
                item.setText(col++, this.toStr(itemMst.getPrice()));
                item.setText(col++, "0");
                item.setText(col++, rankMst.getRankName());
                break;
            }
        }
        this.bodyList.add(itemMst);
        this.tableItemList.select(this.tableItemList.getItemCount() - 1);
        this.cursor.setSelection(this.tableItemList.getItemCount() - 1, this.cursor.getColumn());
        if (this.isDisplay) {
            this.showDisplay();
        }
        this.isDisplay = true;
        this.posMain.getPosTabFolder().updateTableFooter();
    }

    public void addRowSearchList(List<ItemMst> list) throws AbsentMstException {
        ItemListRecycle itemListRecycle = null;
        boolean existsItem = false;
        int i = 0;
        while (i < list.size()) {
            this.isDisplay = false;
            ItemMst item = list.get(i);
            if (itemListRecycle != null && itemListRecycle.existsSameItem(item.getBarcode())) {
                existsItem = true;
            } else {
                this.addRow(item);
            }
            ++i;
        }
        if (existsItem) {
            Toolkit.getDefaultToolkit().beep();
            DialogSameItem dialogSameItem = new DialogSameItem("\u3059\u3067\u306b\u8a08\u4e0a\u3055\u308c\u3066\u3044\u308b\u5546\u54c1\u306f\u30b9\u30ad\u30c3\u30d7\u3055\u308c\u307e\u3057\u305f\u3002");
            dialogSameItem.create(this.posMain, Display.getCurrent(), 0);
            this.posMain.getKeyEventHandler().setDialog(dialogSameItem);
        }
    }

    public void removeAll() {
        this.tableItemList.removeAll();
        this.bodyList.clear();
        this.posMain.getPosTabFolder().setSalesMoney(0L);
        this.posMain.getPosTabFolder().setSalesChange(0L);
        this.posMain.getPosTabFolder().updateTableFooter();
    }

    public void removeRow() {
        this.removeRow(this.tableItemList.getSelectionIndex());
    }

    public void removeRow(int index) {
        int col = this.cursor.getColumn();
        if (this.finished || index < 0) {
            return;
        }
        this.tableItemList.remove(index);
        this.bodyList.remove(index);
        int i = 0;
        while (i < this.tableItemList.getItemCount()) {
            TableItem item = this.tableItemList.getItem(i);
            item.setText(0, String.valueOf(i + 1));
            item.setBackground(i % 2 == 0 ? JFaceResources.getColorRegistry().get("white") : JFaceResources.getColorRegistry().get("aliceblue"));
            item.setImage(Activator.getDefault().getImageRegistry().get("bgdummy"));
            ++i;
        }
        if (this.tableItemList.getItemCount() > 0) {
            i = Math.min(this.tableItemList.getItemCount() - 1, index);
            this.tableItemList.select(i);
            this.cursor.setSelection(i, col);
        }
        this.posMain.getPosTabFolder().updateTableFooter();
    }

    public void increment() {
        int index = this.tableItemList.getSelectionIndex();
        if (this.finished || index < 0) {
            return;
        }
        if ("1".equals(this.bodyList.get(index).getUsedFlag())) {
            return;
        }
        int i = NumberUtils.toInt((String)this.tableItemList.getItem(index).getText(10));
        this.tableItemList.getItem(index).setText(10, String.valueOf(i + 1));
        this.showDisplay();
        this.posMain.getBase().setFocus();
        this.tableItemList.setFocus();
        this.posMain.getPosTabFolder().updateTableFooter();
    }

    public void decrement() {
        int index = this.tableItemList.getSelectionIndex();
        if (this.finished || index < 0) {
            return;
        }
        if ("1".equals(this.bodyList.get(index).getUsedFlag())) {
            return;
        }
        int i = NumberUtils.toInt((String)this.tableItemList.getItem(index).getText(10));
        if (i > 1) {
            this.tableItemList.getItem(index).setText(10, String.valueOf(i - 1));
            this.showDisplay();
        }
        this.posMain.getBase().setFocus();
        this.tableItemList.setFocus();
        this.posMain.getPosTabFolder().updateTableFooter();
    }

    public void upRank() {
        this.changeRank(true);
        this.posMain.getBase().setFocus();
        this.tableItemList.setFocus();
    }

    public void downRank() {
        this.changeRank(false);
        this.posMain.getBase().setFocus();
        this.tableItemList.setFocus();
    }

    private void changeRank(boolean up) {
        int index = this.tableItemList.getSelectionIndex();
        if (this.finished || index < 0) {
            return;
        }
        int colRank = -1;
        switch (this.tabindex) {
            case 0: {
                colRank = 13;
                break;
            }
        }
        MstManager mstManager = MstManager.getInstance();
        ItemMst itemMst = this.getBodyList().get(index);
        if ("1".equals(itemMst.getSetFlag())) {
            this.posMain.getStatusBar().setText("\u30bb\u30c3\u30c8\u5546\u54c1\u306f\u30e9\u30f3\u30af\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        String rankCd = null;
        try {
            rankCd = mstManager.findRankCdByRankName(itemMst.getClassCd(), this.tableItemList.getItem(index).getText(colRank));
        }
        catch (AbsentMstException e) {
            log.error((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            return;
        }
        RankMst rankMst = null;
        if (up) {
            try {
                rankMst = mstManager.upRank(itemMst.getClassCd(), rankCd);
            }
            catch (AbsentMstException e) {
                log.error((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
                return;
            }
        }
        try {
            rankMst = mstManager.downRank(itemMst.getClassCd(), rankCd);
        }
        catch (AbsentMstException e) {
            log.error((Object)"\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e", (Throwable)e);
            return;
        }
        this.tableItemList.getItem(index).setText(colRank, rankMst.getRankName());
        this.setRecyclePrice(index, rankMst);
        this.posMain.getPosTabFolder().updateTableFooter();
    }

    private void setRecyclePrice(int index, RankMst rankMst) {
    }

    public void arrowUp() {
        int index = this.tableItemList.getSelectionIndex();
        if (this.finished || index <= 0) {
            return;
        }
        this.tableItemList.select(index - 1);
        this.cursor.setSelection(index - 1, this.cursor.getColumn());
    }

    public void arrowDown() {
        int index = this.tableItemList.getSelectionIndex();
        if (this.finished || index < 0 || index + 1 >= this.tableItemList.getItemCount()) {
            return;
        }
        this.tableItemList.select(index + 1);
        this.cursor.setSelection(index + 1, this.cursor.getColumn());
    }

    private String toStr(int target) {
        return String.valueOf(target);
    }

    private String toStr(long target) {
        return String.valueOf(target);
    }

    private String toStr(String target) {
        return StringUtils.defaultString((String)target);
    }

    private String toStr(Date target) {
        return StringUtils.defaultString((String)PosDateUtils.format_yyyyMMdd(target));
    }

    public void finished() {
        this.finished = true;
        this.barcodeScanner.reset();
        this.posMain.updateHeaderTopLabels();
        int i = 0;
        while (i < this.tableItemList.getItemCount()) {
            TableItem item = this.tableItemList.getItem(i);
            item.setBackground(JFaceResources.getColorRegistry().get("bougainvillaea"));
            item.setForeground(JFaceResources.getColorRegistry().get("white"));
            ++i;
        }
        this.tableItemList.deselectAll();
    }

    public boolean getFinished() {
        return this.finished;
    }

    public List<ItemMst> getBodyList() {
        return this.bodyList;
    }

    public ItemMst getItemMstSelected() {
        int index = this.tableItemList.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return this.bodyList.get(index);
    }

    private void setTableSelectedIndex(Table table) {
    }

    public Table getTableItemList() {
        return this.tableItemList;
    }

    public TableItem getTableItemSelected() {
        int index = this.tableItemList.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return this.tableItemList.getItem(index);
    }

    public void copyTableItem(int selectionIndex) throws AbsentMstException {
        if (this.finished || selectionIndex < 0) {
            if (this.finished) {
                this.removeAll();
            }
            return;
        }
        int count = this.tableItemList.getItemCount();
        TableItem tableItem = this.tableItemList.getItem(selectionIndex);
        this.tableItemList.setItemCount(count + 1);
        TableItem item = this.tableItemList.getItems()[count];
        item.setText(0, String.valueOf(count + 1));
        item.setBackground(count % 2 == 0 ? JFaceResources.getColorRegistry().get("white") : JFaceResources.getColorRegistry().get("aliceblue"));
        item.setImage(Activator.getDefault().getImageRegistry().get("bgdummy"));
        int i = 1;
        while (i < this.tableItemList.getColumnCount()) {
            item.setText(i, tableItem.getText(i));
            ++i;
        }
        if (!this.bodyList.add(PosBeanUtils.cloneObject(this.bodyList.get(selectionIndex)))) {
            throw new AbsentMstException("\u5546\u54c1\u30de\u30b9\u30bf\u30ea\u30b9\u30c8\u306e\u8ffd\u52a0\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        this.tableItemList.select(this.tableItemList.getItemCount() - 1);
        this.cursor.setSelection(this.tableItemList.getItemCount() - 1, this.cursor.getColumn());
    }

    public BarcodeScanner getBarcodeScanner() {
        return this.barcodeScanner;
    }

    public int getTabindex() {
        return this.tabindex;
    }

    protected void showDisplay() {
        this.showDisplay(Long.valueOf(this.getTableItemSelected().getText(10)).intValue(), this.getTableItemSelected().getText(11), this.getItemMstSelected().getPriceTaxKind());
    }

    protected void showDisplay(int quantity, String prices, String taxKind) {
        ItemMst itemMst = this.getItemMstSelected();
        this.displayItem.setBarcode(itemMst.getBarcode());
        this.displayItem.setMakerCd(itemMst.getMakerCd());
        this.displayItem.setSetFlag(itemMst.getSetFlag());
        this.displayItem.setQuantity(quantity);
        this.displayItem.setPrice(prices);
        this.displayItem.setTaxKind(taxKind);
        this.displayItem.executePrint(this.posMain);
    }

    protected void updateTableItemList(int column, String value) {
        int index = this.tableItemList.getSelectionIndex();
        if (this.finished || index < 0) {
            return;
        }
        this.tableItemList.getItem(index).setText(column, this.toStr(value));
    }

    public void updateTableItemListAll(int column, String value) {
        int count = this.tableItemList.getItemCount();
        if (this.finished || count <= 0) {
            return;
        }
        int i = 0;
        while (i < count) {
            this.tableItemList.getItem(i).setText(column, this.toStr(value));
            ++i;
        }
    }

    protected boolean isSameSupp(ItemMst itemMst) {
        if (this.finished) {
            return true;
        }
        if (this.bodyList.size() == 0) {
            return true;
        }
        return StringUtils.equals((String)this.bodyList.get(0).getComp_id().getSuppCd(), (String)itemMst.getComp_id().getSuppCd());
    }

    protected boolean isSameStoreName(String fromStoreName) {
        if (this.finished) {
            return true;
        }
        if (this.bodyList.size() == 0) {
            return true;
        }
        return StringUtils.equals((String)this.tableItemList.getItem(0).getText(13), (String)fromStoreName);
    }

    protected boolean doIOCheck(ItemMst itemMst) {
        return false;
    }

    protected boolean doNotIOCheck(ItemMst itemMst) {
        if (ArrayUtils.contains((Object[])PosConstants.NO_IOCHECK_SUPP_CD, (Object)itemMst.getComp_id().getSuppCd())) {
            return true;
        }
        return ArrayUtils.contains((Object[])PosConstants.NO_IOCHECK_CLASS_CD, (Object)itemMst.getClassCd());
    }
}

