/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.dialogs;

import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.gui.component.ExGridData;
import jp.ne.k_tech.kposrcp.kpos.gui.component.MoneyText;
import jp.ne.k_tech.kposrcp.kpos.gui.component.QuantityText;
import jp.ne.k_tech.kposrcp.kpos.logic.PosSales;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DialogDiscount
extends DialogAbstract {
    private static Log log = LogFactory.getLog(DialogDiscount.class);
    private static final String BR = System.getProperty("line.separator");
    private Text salesItemQuantityTotal = null;
    private Text salesItemAmount = null;
    private Text salesItemTax = null;
    private Text salesItemAmountWithTax = null;
    private Text salesPercent = null;
    private Text salesPoint = null;
    private Text salesDiscount = null;
    private ItemMst itemMst = null;
    private TableItem tableItem = null;
    private long amountWithTax = 0L;

    @Override
    public Composite createDialog(Display display, final Shell shell) {
        log.debug((Object)"\u8ca9\u58f2\u5024\u5f15\u304d\u30c0\u30a4\u30a2\u30ed\u30b0\u751f\u6210\u958b\u59cb");
        this.itemMst = this.posMain.getPosTabFolder().getPosAbstract()[this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList().getItemMstSelected();
        this.tableItem = this.posMain.getPosTabFolder().getPosAbstract()[this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList().getTableItemSelected();
        Composite base = null;
        shell.setText("\u8ca9\u58f2\u5024\u5f15");
        shell.setSize(new Point(1050, 370));
        shell.setLayout((Layout)new GridLayout(1, true));
        base = new Composite((Composite)shell, 0);
        base.setLayout((Layout)new GridLayout(1, true));
        base.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        Composite headerArea = new Composite(base, 0);
        headerArea.setLayout((Layout)new GridLayout(1, false));
        Composite middleArea = new Composite(base, 2048);
        middleArea.setLayout((Layout)new GridLayout(9, true));
        middleArea.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        Composite footerArea = new Composite(base, 0);
        footerArea.setLayout((Layout)new GridLayout(10, false));
        Composite buttonArea = new Composite(base, 0);
        buttonArea.setLayout((Layout)new GridLayout(10, false));
        Label labelTopTitle = new Label(headerArea, 0);
        labelTopTitle.setText(shell.getText());
        labelTopTitle.setFont(this.posMain.getLargeFont());
        Label labelMessage = new Label(headerArea, 0);
        StringBuffer message = new StringBuffer();
        message.append(String.format("\u5546\u54c1\u756a\u53f7\uff1a%s", this.itemMst.getComp_id().getItemCd()));
        message.append(BR);
        message.append(String.format("\u5546\u54c1\u540d\uff1a%s", this.itemMst.getItemName()));
        message.append(BR);
        message.append(BR);
        message.append("\u5272\u5f15\u304d\u306e\uff05\u3001\u3042\u308b\u3044\u306f\u30dd\u30a4\u30f3\u30c8\u5229\u7528\u6570\u3001\u5024\u5f15\u304d\u91d1\u984d\u306e\u3044\u305a\u308c\u304b\u3092\u5165\u529b\u3057\u307e\u3059\u3002");
        message.append(BR);
        message.append("\u5024\u3092\u5165\u529b\u3057\u3066\uff3bEnter\uff3d\u30ad\u30fc\u3067\u6c7a\u5b9a\u3057\u307e\u3059\u3002");
        labelMessage.setText(message.toString());
        labelMessage.setFont(this.posMain.getNormalFont());
        Label labelSalesItemQuantityTotal = new Label(middleArea, 0);
        labelSalesItemQuantityTotal.setText("\u5546\u54c1\u70b9\u6570");
        labelSalesItemQuantityTotal.setFont(this.posMain.getNormalFont());
        this.salesItemQuantityTotal = new QuantityText(this.posMain, middleArea).getText(false);
        Label labelSalesItemQuantityTotalEnd = new Label(middleArea, 0);
        labelSalesItemQuantityTotalEnd.setText("\u70b9");
        labelSalesItemQuantityTotalEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesItemAmount = new Label(middleArea, 0);
        labelSalesItemAmount.setText("\u7a0e\u629c\u304d\u5408\u8a08");
        labelSalesItemAmount.setFont(this.posMain.getNormalFont());
        this.salesItemAmount = new MoneyText(this.posMain, middleArea).getText(false);
        Label labelSalesItemAmountEnd = new Label(middleArea, 0);
        labelSalesItemAmountEnd.setText("\u5186");
        labelSalesItemAmountEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesItemTax = new Label(middleArea, 0);
        labelSalesItemTax.setText("\u6d88\u8cbb\u7a0e");
        labelSalesItemTax.setFont(this.posMain.getNormalFont());
        this.salesItemTax = new MoneyText(this.posMain, middleArea).getText(false);
        Label labelSalesItemTaxEnd = new Label(middleArea, 0);
        labelSalesItemTaxEnd.setText("\u5186");
        labelSalesItemTaxEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesPercent = new Label(middleArea, 0);
        labelSalesPercent.setText("\u5272\u5f15\u304d");
        labelSalesPercent.setFont(this.posMain.getNormalFont());
        this.salesPercent = new QuantityText(this.posMain, middleArea, 2).getText(true);
        this.salesPercent.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NumberUtils.toInt((String)DialogDiscount.this.salesPercent.getText(), (int)-1) > 0) {
                    DialogDiscount.this.salesDiscount.setText(PosNumberUtils.commaFormat(0L));
                }
                DialogDiscount.this.setSalesItemAmountWithTax();
            }
        });
        Label labelSalesPercentEnd = new Label(middleArea, 0);
        labelSalesPercentEnd.setText("\uff05\u5f15\u304d");
        labelSalesPercentEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesPoint = new Label(middleArea, 0);
        labelSalesPoint.setText("\u30dd\u30a4\u30f3\u30c8\u5229\u7528");
        labelSalesPoint.setFont(this.posMain.getNormalFont());
        this.salesPoint = new QuantityText(this.posMain, middleArea, 6).getText(false);
        Label labelSalesPointEnd = new Label(middleArea, 0);
        labelSalesPointEnd.setText("\u30dd\u30a4\u30f3\u30c8 ");
        labelSalesPointEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesDiscount = new Label(middleArea, 0);
        labelSalesDiscount.setText("\u5024\u5f15\u304d");
        labelSalesDiscount.setFont(this.posMain.getNormalFont());
        this.salesDiscount = new MoneyText(this.posMain, middleArea).getText(true);
        this.salesDiscount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NumberUtils.toInt((String)DialogDiscount.this.salesDiscount.getText(), (int)-1) > 0) {
                    DialogDiscount.this.salesPercent.setText(PosNumberUtils.commaFormat(0L));
                }
                DialogDiscount.this.setSalesItemAmountWithTax();
            }
        });
        Label labelSalesDiscountEnd = new Label(middleArea, 0);
        labelSalesDiscountEnd.setText("\u5186\u5f15\u304d");
        labelSalesDiscountEnd.setFont(this.posMain.getNormalFont());
        Label labelSalesItemAmountWithTax = new Label(middleArea, 0);
        labelSalesItemAmountWithTax.setText("\u8ca9\u58f2\u7a0e\u8fbc\u307f\u5408\u8a08");
        labelSalesItemAmountWithTax.setFont(this.posMain.getNormalFont());
        this.salesItemAmountWithTax = new MoneyText(this.posMain, middleArea).getText(false);
        Label labelSalesItemAmountWithTaxEnd = new Label(middleArea, 0);
        labelSalesItemAmountWithTaxEnd.setText("\u5186");
        labelSalesItemAmountWithTaxEnd.setFont(this.posMain.getNormalFont());
        Label labelFooter = new Label(footerArea, 0);
        labelFooter.setText("[ENTER]\u6c7a\u5b9a\u3000[ESC]\u53d6\u6d88\u3057\u3000[\u2191\u3042\u308b\u3044\u306f\u2190] [\u2193\u3042\u308b\u3044\u306f\u2192]\u30d5\u30a9\u30fc\u30ab\u30b9\u79fb\u52d5");
        labelFooter.setFont(this.posMain.getNormalFont());
        this.buttonOk = new Button(buttonArea, 0);
        this.buttonOk.setText("\u3000\u3000\uff2f\u3000\uff2b\u3000\u3000");
        this.buttonOk.setFont(this.posMain.getLargeFont());
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogDiscount.this.salesPercent.setFocus();
                PosSales posSales = new PosSales(DialogDiscount.this.posMain);
                if (posSales.enterDialogDiscount(DialogDiscount.this.instance) && !shell.isDisposed()) {
                    shell.close();
                }
            }
        });
        Label work1 = new Label(buttonArea, 0);
        work1.setText("    ");
        work1.setFont(this.posMain.getNormalFont());
        this.buttonCancel = new Button(buttonArea, 0);
        this.buttonCancel.setText("\u3000\u3000\u53d6\u6d88\u3057\u3000\u3000");
        this.buttonCancel.setFont(this.posMain.getLargeFont());
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        base.layout();
        this.initText();
        log.debug((Object)"\u8ca9\u58f2\u5024\u5f15\u304d\u30c0\u30a4\u30a2\u30ed\u30b0\u751f\u6210\u7d42\u4e86");
        return base;
    }

    @Override
    public Control[] getAllControl() {
        Control[] objects = null;
        objects = new Control[]{this.salesPercent, this.salesDiscount};
        return objects;
    }

    private void initText() {
        this.salesPercent.setText(PosNumberUtils.commaFormat(0L));
        this.salesPoint.setText(PosNumberUtils.commaFormat(0L));
        this.salesDiscount.setText(PosNumberUtils.commaFormat(0L));
        long quantity = NumberUtils.toLong((String)this.tableItem.getText(10));
        this.salesItemQuantityTotal.setText(PosNumberUtils.commaFormat(quantity));
        long amountWithoutTax = NumberUtils.toLong((String)this.tableItem.getText(11)) * quantity;
        this.salesItemAmount.setText(PosNumberUtils.commaFormat(amountWithoutTax));
        this.salesItemTax.setText(PosNumberUtils.commaFormat(PosNumberUtils.tax(amountWithoutTax, this.itemMst.getPriceTaxKind())));
        this.amountWithTax = PosNumberUtils.amountWithTax(amountWithoutTax, this.itemMst.getPriceTaxKind());
        this.salesItemAmountWithTax.setText(PosNumberUtils.commaFormat(this.amountWithTax));
    }

    public boolean validate() {
        if (this.getSalesItemAmountWithTax() <= 0L) {
            this.posMain.getStatusBar().setText("\u8ca9\u58f2\u7a0e\u8fbc\u307f\u5408\u8a08\u304c\uff10\u5186\u3068\u306a\u308b\u8a2d\u5b9a\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            return false;
        }
        return true;
    }

    public Integer getUsePoint() {
        int point = NumberUtils.toInt((String)this.salesPoint.getText());
        return this.getSaleKind().equals("2") ? Integer.valueOf(point) : Integer.valueOf(0);
    }

    private long getSalesDiscount() {
        return NumberUtils.toLong((String)this.salesDiscount.getText());
    }

    private double getSalesPercent() {
        return NumberUtils.toDouble((String)this.salesPercent.getText()) / 100.0;
    }

    private void setSalesItemAmountWithTax() {
        long l = this.amountWithTax - this.getDiscountAmount();
        if (l > 0L) {
            this.salesItemAmountWithTax.setText(PosNumberUtils.commaFormat(l));
        } else {
            this.salesItemAmountWithTax.setText(PosNumberUtils.commaFormat(0L));
        }
    }

    public long getDiscountAmount() {
        String saleKind = this.getSaleKind();
        if ("1".equals(saleKind)) {
            return this.discount(this.amountWithTax, this.getSalesPercent());
        }
        if ("2".equals(saleKind)) {
            return MstManager.getInstance().findPricePerPoint(this.itemMst.getComp_id().getSuppCd(), this.itemMst.getClassCd(), this.itemMst.getGenreCd()) * (long)this.getUsePoint().intValue();
        }
        if ("3".equals(saleKind)) {
            return this.getSalesDiscount();
        }
        return 0L;
    }

    public String getSaleKind() {
        String sale = null;
        sale = NumberUtils.toInt((String)this.salesPercent.getText(), (int)-1) > 0 ? "1" : (NumberUtils.toInt((String)this.salesPoint.getText(), (int)-1) > 0 ? "2" : (NumberUtils.toInt((String)this.salesDiscount.getText(), (int)-1) > 0 ? "3" : "0"));
        return sale;
    }

    public long getSalesItemAmountWithTax() {
        return PosNumberUtils.commaParse(this.salesItemAmountWithTax.getText());
    }
}

