/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.dbm;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.common.SlipNoManager;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosBeanUtils;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosFileUtils;
import jp.ne.k_tech.kposrcp.kpos.db.dao.JournalDetailDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.JournalHeadDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.SlipDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.JournalSearchTableData;

public class DbmJournalDetail {
    private String empCd;
    private String dependSlipNo;
    private SlipDAO slipDAO = null;
    private JournalHeadDAO journalHeadDAO = null;
    private JournalDetailDAO journalDetailDAO = null;
    private List<Slip> updSlipList = null;
    private JournalHead saveJournal = null;
    private List<JournalDetail> updJournalDetailList = null;
    private List<JournalDetail> saveJournalDetailList = null;

    public DbmJournalDetail(String empCd) {
        this.empCd = empCd;
        this.dependSlipNo = SlipNoManager.getInstance().getNextSlipNo(false);
        this.slipDAO = new SlipDAO();
        this.journalHeadDAO = new JournalHeadDAO();
        this.journalDetailDAO = new JournalDetailDAO();
    }

    public String regist(List<JournalSearchTableData> list) {
        if (list.size() == 0) {
            return "";
        }
        String slipNo = list.get(0).getSlipNo();
        Integer index = 0;
        Slip saveSlip = this.slipDAO.findBySlip(slipNo).get(0);
        saveSlip.setSlipNo(this.dependSlipNo);
        saveSlip.setCreateDate(Calendar.getInstance().getTime());
        saveSlip.setDependSlipNo(slipNo);
        saveSlip.setEmpCd(this.empCd);
        saveSlip.setSendFlag("0");
        this.saveJournal = this.journalHeadDAO.findBySlip(slipNo).get(0);
        this.saveJournal.setSlipNo(this.dependSlipNo);
        this.saveJournal.setPosVersion("0.1.1BS");
        this.saveJournal.setEmpCd(this.empCd);
        this.updSlipList = new ArrayList<Slip>();
        this.updJournalDetailList = new ArrayList<JournalDetail>();
        this.saveJournalDetailList = new ArrayList<JournalDetail>();
        int i = 0;
        while (i < list.size()) {
            index = index - 1;
            this.setCancelData(list.get(i).getSlipNo(), list.get(i).getSeq(), index);
            ++i;
        }
        this.slipDAO.updateSaveSlipJournalCancel(this.updSlipList, this.updJournalDetailList, saveSlip, this.saveJournal, this.saveJournalDetailList);
        PosFileUtils.createTriggerFile();
        return this.dependSlipNo;
    }

    private void setCancelData(String slipNo, Integer seq, Integer index) {
        Slip slip = this.slipDAO.findBySlip(slipNo).get(0);
        JournalDetail journalDetail = this.journalDetailDAO.findBySlip(slipNo, seq).get(0);
        slip.setDependSlipNo(this.dependSlipNo);
        slip.setSendFlag("0");
        this.updSlipList.add(slip);
        this.updJournalDetailList.add(journalDetail);
        JournalDetail journalDetailCancel = PosBeanUtils.cloneObject(journalDetail);
        journalDetailCancel.getComp_id().setSlipNo(this.dependSlipNo);
        journalDetailCancel.getComp_id().setSeq(index);
        if (journalDetailCancel.getItemQuantity() != null) {
            journalDetailCancel.setItemQuantity(-1 * journalDetailCancel.getItemQuantity());
        }
        this.saveJournalDetailList.add(journalDetailCancel);
    }

    public List<JournalDetail> getSaveJournalDetailList() {
        return this.saveJournalDetailList;
    }

    public JournalHead getSaveJournal() {
        return this.saveJournal;
    }
}

