/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.dbm;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.PosCommon;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMstPK;
import org.apache.commons.lang.math.NumberUtils;

public class DbmBarcode {
    public static final String SBC_PREFIX = "210000";
    public static final String SBC_MOVE_PREFIX = "23";
    public static final int SBC_UNKNOWN = 0;
    public static final int SBC_ITEM_ILLUSTRATED_BOOK_A = 1001018;
    public static final int SBC_ITEM_ILLUSTRATED_BOOK_B = 1001025;
    public static final int SBC_ITEM_MAGAZINE_A = 1002015;
    public static final int SBC_ITEM_MAGAZINE_B = 1002022;
    public static final int SBC_GENRE_BOOK = 0x2DD282;
    public static final int SBC_GENRE_MAGAZINE = 3003034;
    public static final int SBC_CATEGORY_BOOK = 4000209;
    public static final int SBC_CATEGORY_MAGAZINE = 4000223;
    private static Map<String, Integer> staffBarcodeMap = null;

    public void initialize() {
        staffBarcodeMap = new HashMap<String, Integer>();
        staffBarcodeMap.put("2100003003010", new Integer(0x2DD282));
        staffBarcodeMap.put("2100003003034", new Integer(3003034));
        staffBarcodeMap.put("2100004000209", new Integer(4000209));
        staffBarcodeMap.put("2100004000223", new Integer(4000223));
        staffBarcodeMap.put("2100001001018", new Integer(1001018));
        staffBarcodeMap.put("2100001001025", new Integer(1001025));
        staffBarcodeMap.put("2100001002015", new Integer(1002015));
        staffBarcodeMap.put("2100001002022", new Integer(1002022));
    }

    public void terminate() {
        staffBarcodeMap.clear();
    }

    public String findGenre(int index) {
        String result = null;
        switch (index) {
            case 0x2DD282: {
                result = "0101";
                break;
            }
            case 3003034: {
                result = "0102";
            }
        }
        return result;
    }

    public String findGenre(String barcode) {
        return this.findGenre(this.getIndex(barcode));
    }

    public String findCategory(int index) {
        String result = null;
        switch (index) {
            case 4000209: {
                result = "0002";
                break;
            }
            case 4000223: {
                result = "0003";
            }
        }
        return result;
    }

    public String findCategory(String barcode) {
        return this.findCategory(this.getIndex(barcode));
    }

    public boolean isStaffBarcode(String barcode) {
        if (barcode.length() != 13) {
            return false;
        }
        if (!barcode.startsWith(SBC_PREFIX)) {
            return false;
        }
        return staffBarcodeMap.keySet().contains(barcode);
    }

    public int getIndex(String barcode) {
        int result = 0;
        Integer index = staffBarcodeMap.get(barcode);
        if (index != null) {
            result = index;
        }
        return result;
    }

    public boolean isClass(String barcode) {
        if (this.isStaffBarcode(barcode)) {
            switch (this.getIndex(barcode)) {
                case 4000209: 
                case 4000223: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isGenre(String barcode) {
        if (this.isStaffBarcode(barcode)) {
            switch (this.getIndex(barcode)) {
                case 0x2DD282: 
                case 3003034: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isItem(String barcode) {
        if (this.isStaffBarcode(barcode)) {
            switch (this.getIndex(barcode)) {
                case 1001018: 
                case 1001025: 
                case 1002015: 
                case 1002022: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public ItemMst createItemMst(String barcode) {
        ItemMst itemMst = null;
        if (this.isStaffBarcode(barcode)) {
            String storeCd = Activator.getDefault().getPreferenceStore().getString("STORE_CD");
            String suppCd = "0998";
            String itemCd = null;
            Calendar onsaleDate = Calendar.getInstance();
            onsaleDate.clear();
            onsaleDate.set(1, 1900);
            onsaleDate.set(2, 0);
            onsaleDate.set(5, 1);
            ItemMstPK itemMstPK = null;
            switch (this.getIndex(barcode)) {
                case 1001018: {
                    itemCd = Integer.toString(1001018);
                    itemMstPK = new ItemMstPK(itemCd, suppCd, storeCd);
                    return new ItemMst(itemMstPK, itemCd, "\u7d75\u672cA", "\u30a8\u30db\u30f3A", "--", "900001", "9001", "9001", onsaleDate.getTime(), null, 0L, "0", 0L, 0L, "0", barcode, barcode, "1", "0", "1", "0", "S", null, null, null, null, null, null, null, null, null, null);
                }
                case 1001025: {
                    itemCd = Integer.toString(1001025);
                    itemMstPK = new ItemMstPK(itemCd, suppCd, storeCd);
                    return new ItemMst(itemMstPK, itemCd, "\u7d75\u672cB", "\u30a8\u30db\u30f3B", "--", "900001", "9001", "9001", onsaleDate.getTime(), null, 0L, "0", 0L, 0L, "0", barcode, barcode, "1", "0", "1", "0", "Z", null, null, null, null, null, null, null, null, null, null);
                }
                case 1002015: {
                    itemCd = Integer.toString(1002015);
                    itemMstPK = new ItemMstPK(itemCd, suppCd, storeCd);
                    return new ItemMst(itemMstPK, itemCd, "\u96d1\u8a8cA", "\u30b6\u30c3\u30b7A", "--", "900001", "9002", "9001", onsaleDate.getTime(), null, 0L, "0", 0L, 0L, "0", barcode, barcode, "1", "0", "1", "0", "S", null, null, null, null, null, null, null, null, null, null);
                }
                case 1002022: {
                    itemCd = Integer.toString(1002022);
                    itemMstPK = new ItemMstPK(itemCd, suppCd, storeCd);
                    return new ItemMst(itemMstPK, itemCd, "\u96d1\u8a8cB", "\u30b6\u30c3\u30b7B", "--", "900001", "9002", "9001", onsaleDate.getTime(), null, 0L, "0", 0L, 0L, "0", barcode, barcode, "1", "0", "1", "0", "Z", null, null, null, null, null, null, null, null, null, null);
                }
            }
        }
        return itemMst;
    }

    public boolean isMoveBarcode(String barcode) {
        if (barcode.length() != 13) {
            return false;
        }
        return barcode.startsWith(SBC_MOVE_PREFIX);
    }

    public boolean validateMoveBarcode(String barcode) {
        if (!this.isMoveBarcode(barcode)) {
            return false;
        }
        String info = barcode.substring(SBC_MOVE_PREFIX.length());
        String fromStoreCd = info.substring(0, 3);
        String toStoreCd = info.substring(3, 6);
        int count = NumberUtils.toInt((String)info.substring(6, 10), (int)-1);
        try {
            MstManager.getInstance().findStoreMstByCD(fromStoreCd);
        }
        catch (AbsentMstException absentMstException) {
            return false;
        }
        try {
            MstManager.getInstance().findStoreMstByCD(toStoreCd);
        }
        catch (AbsentMstException absentMstException) {
            return false;
        }
        return count > 0;
    }

    public String createMoveBarcode(String fromStore, String toStore, int num) {
        String barcode = SBC_MOVE_PREFIX + fromStore + toStore + String.format("%04d", num);
        return String.valueOf(barcode) + PosCommon.getCheckdigit(barcode);
    }

    public String getNextPosLinkBarcode() {
        return "2500300000" + String.format("%02d", Activator.getDefault().getPreferenceStore().getInt("REGISTER_NO"));
    }

    public class MoveBarcode
    implements Serializable {
        private static final long serialVersionUID = -871497166364246267L;
        private String fromStoreCd;
        private String toStoreCd;
        private int count;

        public MoveBarcode(String fromStoreCd, String toStoreCd, int count) {
            this.fromStoreCd = fromStoreCd;
            this.toStoreCd = toStoreCd;
            this.count = count;
        }

        public MoveBarcode(String fromStoreCd, String toStoreCd, String count) {
            this(fromStoreCd, toStoreCd, NumberUtils.toInt((String)count));
        }

        public String getFromStoreCd() {
            return this.fromStoreCd;
        }

        public void setFromStoreCd(String fromStoreCd) {
            this.fromStoreCd = fromStoreCd;
        }

        public String getToStoreCd() {
            return this.toStoreCd;
        }

        public void setToStoreCd(String toStoreCd) {
            this.toStoreCd = toStoreCd;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

