/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.db.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.common.SlipNoManager;
import jp.ne.k_tech.kposrcp.kpos.db.dao.BaseDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.IndicateDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.JournalDetailDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.JournalHeadDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.OrderDetailDAO;
import jp.ne.k_tech.kposrcp.kpos.db.dao.OrderHeadDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Indicate;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.OrderDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.OrderHead;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.Slip;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.GroupWebSaleKindData;
import jp.ne.k_tech.kposrcp.kpos.list.valueobject.IndicateTableData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SlipDAO
extends BaseDAO {
    public void saveSlipIndicate(Slip slip, List<Indicate> indicateList) {
        Session session = this.getSession();
        Transaction transaction = null;
        try {
            try {
                transaction = session.beginTransaction();
                this.save(session, slip);
                if (indicateList != null) {
                    IndicateDAO indicateDAO = new IndicateDAO();
                    Iterator<Indicate> iter = indicateList.iterator();
                    while (iter.hasNext()) {
                        indicateDAO.save(session, iter.next());
                    }
                }
                transaction.commit();
            }
            catch (HibernateException e) {
                this.rollback(transaction);
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveSlipJournal(Slip slip, JournalHead journalHead) {
        this.saveSlipJournal(slip, journalHead, null);
    }

    public void saveSlipJournal(Slip slip, JournalHead journalHead, List<JournalDetail> journalDetailList) {
        Session session = this.getSession();
        Transaction transaction = null;
        try {
            try {
                transaction = session.beginTransaction();
                this.save(session, slip);
                JournalHeadDAO journalHeadDAO = new JournalHeadDAO();
                journalHeadDAO.save(session, journalHead);
                if (journalDetailList != null) {
                    JournalDetailDAO journalDetailDAO = new JournalDetailDAO();
                    for (JournalDetail journalDetail : journalDetailList) {
                        journalDetailDAO.save(session, journalDetail);
                        if ("S0".equals(slip.getKindMst().getKindCd()) || "L0".equals(slip.getKindMst().getKindCd()) || "U0".equals(slip.getKindMst().getKindCd()) || "60".equals(slip.getKindMst().getKindCd())) continue;
                        "N0".equals(slip.getKindMst().getKindCd());
                    }
                }
                transaction.commit();
            }
            catch (HibernateException e) {
                this.rollback(transaction);
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveSlipOrder(Slip slip, OrderHead orderHead, List<OrderDetail> orderDetailList) {
        Session session = this.getSession();
        Transaction transaction = null;
        try {
            try {
                transaction = session.beginTransaction();
                this.save(session, slip);
                OrderHeadDAO orderHeadDAO = new OrderHeadDAO();
                orderHeadDAO.save(session, orderHead);
                if (orderDetailList != null) {
                    OrderDetailDAO orderDetailDAO = new OrderDetailDAO();
                    Iterator<OrderDetail> iter = orderDetailList.iterator();
                    while (iter.hasNext()) {
                        orderDetailDAO.save(session, iter.next());
                    }
                }
                transaction.commit();
            }
            catch (HibernateException e) {
                this.rollback(transaction);
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public Serializable save(Session session, Slip slip) {
        return session.save((Object)slip);
    }

    public void updateSaveSlipJournalCancel(List<Slip> updSlipList, List<JournalDetail> updJournalDetailList, Slip saveSlip, JournalHead saveJournal, List<JournalDetail> saveJournalDetailList) {
        Session session = this.getSession();
        Transaction transaction = null;
        try {
            try {
                transaction = session.beginTransaction();
                int i = 0;
                while (i < updSlipList.size()) {
                    if (this.updateSlip(session, updSlipList.get(i)) == 0) {
                        throw new HibernateException("\u8d64\u4f1d\u306e\u4f1d\u7968\u66f4\u65b0\u306f\uff10\u4ef6\u3067\u3057\u305f");
                    }
                    ++i;
                }
                JournalDetailDAO journalDetailDAO = new JournalDetailDAO();
                int i2 = 0;
                while (i2 < updJournalDetailList.size()) {
                    if (journalDetailDAO.updatejournalDetail(session, updJournalDetailList.get(i2)) == 0) {
                        throw new HibernateException("\u8d64\u4f1d\u306e\u30b8\u30e3\u30fc\u30ca\u30eb\u8a73\u7d30\u66f4\u65b0\u306f\uff10\u4ef6\u3067\u3057\u305f");
                    }
                    ++i2;
                }
                this.save(session, saveSlip);
                JournalHeadDAO journalHeadDAO = new JournalHeadDAO();
                journalHeadDAO.save(session, saveJournal);
                Iterator<JournalDetail> iter = saveJournalDetailList.iterator();
                while (iter.hasNext()) {
                    journalDetailDAO.save(session, iter.next());
                }
                transaction.commit();
            }
            catch (HibernateException e) {
                this.rollback(transaction);
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    private int updateSlip(Session session, Slip slip) {
        StringBuffer hql = new StringBuffer();
        hql.append("UPDATE");
        hql.append(" Slip slip");
        hql.append(" SET");
        hql.append(" slip.dependSlipNo = :dependSlipNo");
        hql.append(", slip.sendFlag = :sendFlag");
        hql.append(" WHERE");
        hql.append(" slip.slipNo = :slipNo");
        Query query = session.createQuery(hql.toString());
        query.setString("slipNo", slip.getSlipNo());
        query.setString("dependSlipNo", slip.getDependSlipNo());
        query.setString("sendFlag", slip.getSendFlag());
        return query.executeUpdate();
    }

    public List<Slip> findBySlip(String slipNo) {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" slip");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(" WHERE");
        hql.append(" slip.slipNo = :slipNo");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("slipNo", slipNo);
            result = query.list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public int getMaxSlipNoSeq(String prefix) {
        int result = 0;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" MAX(slip.slipNo)");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(" WHERE");
        hql.append(" slip.slipNo LIKE :prefix");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            result = NumberUtils.toInt((String)StringUtils.substringAfterLast((String)StringUtils.defaultString((String)((String)query.uniqueResult())).trim(), (String)prefix), (int)0);
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    private long sumAmountHead(String kindCd) {
        long result = 0L;
        Session session = this.getSession();
        String prefix = SlipNoManager.getInstance().getPrefix();
        StringBuffer hqlPlus = new StringBuffer();
        hqlPlus.append("SELECT");
        if (kindCd.equals("Y0")) {
            hqlPlus.append(" SUM(journalHead.customerQuantity)");
        } else if (kindCd.equals("O0")) {
            hqlPlus.append(" SUM(journalHead.outMoney)");
        } else {
            hqlPlus.append(" SUM(journalHead.totalAmount)");
        }
        hqlPlus.append(" FROM");
        hqlPlus.append(" Slip slip");
        hqlPlus.append(", JournalHead journalHead");
        hqlPlus.append(" WHERE");
        hqlPlus.append(" slip.slipNo LIKE :prefix");
        hqlPlus.append(" AND slip.kindMst.kindCd = :kindCd");
        hqlPlus.append(" AND slip.slipNo = journalHead.slipNo");
        try {
            Query query = session.createQuery(hqlPlus.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            query.setString("kindCd", kindCd);
            Object tmp = query.uniqueResult();
            result = kindCd.equals("Y0") ? (tmp == null ? 0L : (Long)tmp) : (tmp == null ? 0L : (Long)tmp);
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    private long sumAmountDetail(String kindCd, boolean cancelFlag) {
        long result = 0L;
        Session session = this.getSession();
        String prefix = SlipNoManager.getInstance().getPrefix();
        StringBuffer hqlPlus = new StringBuffer();
        hqlPlus.append("SELECT");
        hqlPlus.append(" SUM(journalDetail.amount)");
        hqlPlus.append(" FROM");
        hqlPlus.append(" Slip slip");
        hqlPlus.append(", JournalHead journalHead");
        hqlPlus.append(", JournalDetail journalDetail");
        hqlPlus.append(" WHERE");
        hqlPlus.append(" slip.slipNo LIKE :prefix");
        hqlPlus.append(" AND slip.kindMst.kindCd = :kindCd");
        hqlPlus.append(" AND slip.slipNo = journalHead.slipNo");
        hqlPlus.append(" AND slip.slipNo = journalDetail.comp_id.slipNo");
        if (cancelFlag) {
            hqlPlus.append(" AND journalDetail.itemQuantity < 0");
        } else {
            hqlPlus.append(" AND journalDetail.itemQuantity > 0");
        }
        try {
            Query query = session.createQuery(hqlPlus.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            query.setString("kindCd", kindCd);
            Object tmp = query.uniqueResult();
            result = tmp == null ? 0L : (Long)tmp;
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    private long sumAmountSale(String creditKind, boolean cancelFlag) {
        long result = 0L;
        Session session = this.getSession();
        String prefix = SlipNoManager.getInstance().getPrefix();
        StringBuffer hqlPlus = new StringBuffer();
        hqlPlus.append("SELECT");
        hqlPlus.append(" SUM(journalDetail.amount)");
        hqlPlus.append(" FROM");
        hqlPlus.append(" Slip slip");
        hqlPlus.append(", JournalHead journalHead");
        hqlPlus.append(", JournalDetail journalDetail");
        hqlPlus.append(" WHERE");
        hqlPlus.append(" slip.slipNo LIKE :prefix");
        hqlPlus.append(" AND slip.kindMst.kindCd = :kindCd");
        hqlPlus.append(" AND slip.slipNo = journalHead.slipNo");
        hqlPlus.append(" AND journalHead.creditKind = :creditKind");
        hqlPlus.append(" AND journalHead.webSaleKind = :webSaleKind");
        hqlPlus.append(" AND journalHead.slipNo = journalDetail.comp_id.slipNo");
        if (cancelFlag) {
            hqlPlus.append(" AND journalDetail.itemQuantity < 0");
        } else {
            hqlPlus.append(" AND journalDetail.itemQuantity > 0");
        }
        try {
            Query query = session.createQuery(hqlPlus.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            query.setString("kindCd", "U0");
            query.setString("creditKind", creditKind);
            query.setString("webSaleKind", "0");
            Object tmp = query.uniqueResult();
            result = tmp == null ? 0L : (Long)tmp;
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    private long sumDiscountAmountSale(String creditKind, boolean cancelFlag) {
        long result = 0L;
        Session session = this.getSession();
        String prefix = SlipNoManager.getInstance().getPrefix();
        StringBuffer hqlPlus = new StringBuffer();
        hqlPlus.append("SELECT");
        hqlPlus.append(" SUM(journalDetail.discountAmount)");
        hqlPlus.append(" FROM");
        hqlPlus.append(" Slip slip");
        hqlPlus.append(", JournalHead journalHead");
        hqlPlus.append(", JournalDetail journalDetail");
        hqlPlus.append(" WHERE");
        hqlPlus.append(" slip.slipNo LIKE :prefix");
        hqlPlus.append(" AND slip.kindMst.kindCd = :kindCd");
        hqlPlus.append(" AND slip.slipNo = journalHead.slipNo");
        hqlPlus.append(" AND journalHead.creditKind = :creditKind");
        hqlPlus.append(" AND journalHead.webSaleKind = :webSaleKind");
        hqlPlus.append(" AND journalHead.slipNo = journalDetail.comp_id.slipNo");
        if (cancelFlag) {
            hqlPlus.append(" AND journalDetail.itemQuantity < 0");
        } else {
            hqlPlus.append(" AND journalDetail.itemQuantity > 0");
        }
        try {
            Query query = session.createQuery(hqlPlus.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            query.setString("kindCd", "U0");
            query.setString("creditKind", creditKind);
            query.setString("webSaleKind", "0");
            Object tmp = query.uniqueResult();
            result = tmp == null ? 0L : (Long)tmp;
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public List<GroupWebSaleKindData> getGroupWebSaleKindData(boolean cancelFlag) {
        ArrayList<GroupWebSaleKindData> groupWebSaleKindData = new ArrayList<GroupWebSaleKindData>();
        Session session = this.getSession();
        String prefix = SlipNoManager.getInstance().getPrefix();
        StringBuffer hqlPlus = new StringBuffer();
        hqlPlus.append("SELECT");
        hqlPlus.append(" new " + GroupWebSaleKindData.class.getName() + "(");
        hqlPlus.append(" journalHead.webSaleKind");
        hqlPlus.append(", SUM(journalDetail.amount)");
        hqlPlus.append(", SUM(journalDetail.discountAmount)");
        hqlPlus.append(")");
        hqlPlus.append(" FROM");
        hqlPlus.append(" Slip slip");
        hqlPlus.append(", JournalHead journalHead");
        hqlPlus.append(", JournalDetail journalDetail");
        hqlPlus.append(" WHERE");
        hqlPlus.append(" slip.slipNo LIKE :prefix");
        hqlPlus.append(" AND slip.kindMst.kindCd = :kindCd");
        hqlPlus.append(" AND slip.slipNo = journalHead.slipNo");
        hqlPlus.append(" AND journalHead.slipNo = journalDetail.comp_id.slipNo");
        if (cancelFlag) {
            hqlPlus.append(" AND journalDetail.itemQuantity < 0");
        } else {
            hqlPlus.append(" AND journalDetail.itemQuantity > 0");
        }
        hqlPlus.append(" GROUP BY");
        hqlPlus.append(" journalHead.webSaleKind");
        try {
            Query query = session.createQuery(hqlPlus.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            query.setString("kindCd", "U0");
            groupWebSaleKindData.addAll(query.list());
        }
        finally {
            this.closeSession(session);
        }
        return groupWebSaleKindData;
    }

    public long sumTotalAmount() {
        return this.sumAmountDetail("U0", false);
    }

    public long sumRecycleTotalAmount() {
        return this.sumAmountDetail("B0", false);
    }

    public long sumRecycleTotalCancel() {
        return this.sumAmountDetail("B0", true);
    }

    public long sumCashTotalAmount() {
        return this.sumAmountSale("0", false);
    }

    public long sumCashTotalCancel() {
        return this.sumAmountSale("0", true);
    }

    public long sumCashTotalDiscountAmount() {
        return this.sumDiscountAmountSale("0", false);
    }

    public long sumCashTotalDiscountCancel() {
        return this.sumDiscountAmountSale("0", true);
    }

    public long sumCreditTotalAmount() {
        return this.sumAmountSale("1", false);
    }

    public long sumCreditTotalCancel() {
        return this.sumAmountSale("1", true);
    }

    public long sumCreditTotalDiscountAmount() {
        return this.sumDiscountAmountSale("1", false);
    }

    public long sumCreditTotalDiscountCancel() {
        return this.sumDiscountAmountSale("1", true);
    }

    public long sumOutMoney() {
        return this.sumAmountHead("O0");
    }

    public long sumChange() {
        return this.sumAmountHead("R0");
    }

    public long sumCustomer() {
        return this.sumAmountHead("Y0");
    }

    private long countSlipNoHead(String kindCd) {
        long result = 0L;
        Session session = this.getSession();
        String prefix = SlipNoManager.getInstance().getPrefix();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" COUNT(slip.slipNo)");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", JournalHead journalHead");
        hql.append(" WHERE");
        hql.append(" slip.slipNo LIKE :prefix");
        hql.append(" AND slip.kindMst.kindCd = :kindCd");
        hql.append(" AND slip.slipNo = journalHead.slipNo");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            query.setString("kindCd", kindCd);
            Object tmp = query.uniqueResult();
            result = tmp == null ? 0L : (Long)tmp;
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    private long countSlipNoDetail(String kindCd) {
        long result = 0L;
        Session session = this.getSession();
        String prefix = SlipNoManager.getInstance().getPrefix();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" COUNT(DISTINCT slip.slipNo)");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", JournalHead journalHead");
        hql.append(", JournalDetail journalDetail");
        hql.append(" WHERE");
        hql.append(" slip.slipNo LIKE :prefix");
        hql.append(" AND slip.kindMst.kindCd = :kindCd");
        hql.append(" AND slip.slipNo = journalHead.slipNo");
        hql.append(" AND slip.slipNo = journalDetail.comp_id.slipNo");
        hql.append(" AND journalDetail.comp_id.seq > 0");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            query.setString("kindCd", kindCd);
            Object tmp = query.uniqueResult();
            result = tmp == null ? 0L : (Long)tmp;
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public long countPurchaser() {
        return this.countSlipNoDetail("U0");
    }

    public long countAcceptance() {
        return this.countSlipNoDetail("B0");
    }

    public long countChange() {
        return this.countSlipNoHead("E0");
    }

    public long countOutMoney() {
        return this.countSlipNoHead("O0");
    }

    public boolean isFirstTime() {
        long result = 0L;
        Session session = this.getSession();
        String prefix = SlipNoManager.getInstance().getPrefix();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" COUNT(slip.slipNo)");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(" WHERE");
        hql.append(" slip.slipNo LIKE :prefix");
        hql.append(" AND slip.kindMst.kindCd = :kindCd");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("prefix", String.valueOf(prefix) + "%");
            query.setString("kindCd", "R0");
            Object tmp = query.uniqueResult();
            result = tmp == null ? 0L : (Long)tmp;
        }
        finally {
            this.closeSession(session);
        }
        return result == 0L;
    }

    public List<IndicateTableData> getIndicateTableDataList() {
        ArrayList<IndicateTableData> indicateTabelData = new ArrayList<IndicateTableData>();
        indicateTabelData.addAll(this.getIndicateTableDataList4Move());
        indicateTabelData.addAll(this.getIndicateTableDataList4Back());
        return indicateTabelData;
    }

    public List<IndicateTableData> getIndicateTableDataList4Move() {
        ArrayList<IndicateTableData> indicateTabelData = new ArrayList<IndicateTableData>();
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" new " + IndicateTableData.class.getName() + "(slip.kindMst.kindCd, indicate.indicateDate, indicate.limitDate, SUM(indicate.indicateQuantity-COALESCE(indicate.afterQuantity,0)), indicate.toStoreCd, " + 0 + ")");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", Indicate indicate");
        hql.append(" WHERE");
        hql.append(" slip.kindMst.kindCd = :kindCd");
        hql.append(" AND indicate.comp_id.seq > 0");
        hql.append(" AND slip.slipNo = indicate.comp_id.slipNo");
        hql.append(" AND (indicate.afterQuantity IS NULL OR indicate.afterQuantity < indicate.indicateQuantity)");
        hql.append(" AND indicate.journalSlipNo IS NULL");
        hql.append(" AND indicate.journalSeq IS NULL");
        hql.append(" GROUP BY");
        hql.append(" slip.kindMst.kindCd");
        hql.append(", indicate.indicateDate");
        hql.append(", indicate.limitDate");
        hql.append(", indicate.toStoreCd");
        hql.append(" HAVING");
        hql.append(" SUM(indicate.indicateQuantity-COALESCE(indicate.afterQuantity,0)) > 0");
        hql.append(" ORDER BY");
        hql.append(" slip.kindMst.kindCd");
        hql.append(", indicate.limitDate");
        hql.append(", indicate.indicateDate");
        hql.append(", indicate.toStoreCd");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("kindCd", "C2");
            indicateTabelData.addAll(query.list());
        }
        finally {
            this.closeSession(session);
        }
        return indicateTabelData;
    }

    public List<IndicateTableData> getIndicateTableDataList4Back() {
        ArrayList<IndicateTableData> indicateTabelData = new ArrayList<IndicateTableData>();
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" new " + IndicateTableData.class.getName() + "(slip.kindMst.kindCd, indicate.indicateDate, indicate.limitDate, SUM(indicate.indicateQuantity-COALESCE(indicate.afterQuantity,0)), indicate.suppCd, " + 1 + ")");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", Indicate indicate");
        hql.append(" WHERE");
        hql.append(" slip.kindMst.kindCd = :kindCd");
        hql.append(" AND indicate.comp_id.seq > 0");
        hql.append(" AND slip.slipNo = indicate.comp_id.slipNo");
        hql.append(" AND (indicate.afterQuantity IS NULL OR indicate.afterQuantity < indicate.indicateQuantity)");
        hql.append(" AND indicate.journalSlipNo IS NULL");
        hql.append(" AND indicate.journalSeq IS NULL");
        hql.append(" AND indicate.transDate IS NULL");
        hql.append(" AND indicate.approveDate IS NULL");
        hql.append(" GROUP BY");
        hql.append(" slip.kindMst.kindCd");
        hql.append(", indicate.indicateDate");
        hql.append(", indicate.limitDate");
        hql.append(", indicate.suppCd");
        hql.append(" HAVING");
        hql.append(" SUM(indicate.indicateQuantity-COALESCE(indicate.afterQuantity,0)) > 0");
        hql.append(" ORDER BY");
        hql.append(" slip.kindMst.kindCd");
        hql.append(", indicate.limitDate");
        hql.append(", indicate.indicateDate");
        hql.append(", indicate.suppCd");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("kindCd", "A3");
            indicateTabelData.addAll(query.list());
        }
        finally {
            this.closeSession(session);
        }
        return indicateTabelData;
    }
}

