/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.db.dao;

import java.io.Serializable;
import java.util.Date;
import jp.ne.k_tech.kposrcp.kpos.db.dao.BaseDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.JournalDetail;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.OrderDetail;
import org.hibernate.Query;
import org.hibernate.Session;

public class OrderDetailDAO
extends BaseDAO {
    public Serializable save(Session session, OrderDetail orderDetail) {
        return session.save((Object)orderDetail);
    }

    public Serializable incrementAfterQuantity(Session session, JournalDetail journalDetail) {
        StringBuffer hql = new StringBuffer();
        hql.append("UPDATE");
        hql.append(" OrderDetail orderDetail");
        hql.append(" SET");
        hql.append(" orderDetail.afterQuantity = (COALESCE(orderDetail.afterQuantity,0) + :itemQuantity)");
        hql.append(" WHERE");
        hql.append(" orderDetail.itemCd = :itemCd");
        hql.append(" AND orderDetail.suppCd = :suppCd");
        hql.append(" AND orderDetail.comp_id.seq > 0");
        hql.append(" AND orderDetail.journalSlipNo IS NULL");
        hql.append(" AND orderDetail.journalSeq IS NULL");
        Query query = session.createQuery(hql.toString());
        query.setString("itemCd", journalDetail.getItemCd());
        query.setString("suppCd", journalDetail.getSuppCd());
        query.setInteger("itemQuantity", journalDetail.getItemQuantity().intValue());
        return Integer.valueOf(query.executeUpdate());
    }

    public boolean onOrder(ItemMst itemMst) {
        long result = 0L;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" COUNT(DISTINCT slip.slipNo)");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", OrderDetail orderDetail");
        hql.append(" WHERE");
        hql.append(" orderDetail.itemCd = :itemCd");
        hql.append(" AND orderDetail.suppCd = :suppCd");
        hql.append(" AND orderDetail.journalSlipNo IS NULL");
        hql.append(" AND orderDetail.journalSeq IS NULL");
        hql.append(" AND slip.kindMst.kindCd = :kindCd");
        hql.append(" AND slip.slipNo = orderDetail.comp_id.slipNo");
        hql.append(" AND orderDetail.comp_id.seq > 0");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("itemCd", itemMst.getComp_id().getItemCd());
            query.setString("suppCd", itemMst.getComp_id().getSuppCd());
            query.setString("kindCd", "A2");
            Object tmp = query.uniqueResult();
            result = tmp == null ? 0L : (Long)tmp;
        }
        finally {
            this.closeSession(session);
        }
        return result > 0L;
    }

    public Date getLatestOrderDate(ItemMst itemMst) {
        Date result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" MAX(orderDetail.orderDate)");
        hql.append(" FROM");
        hql.append(" Slip slip");
        hql.append(", OrderDetail orderDetail");
        hql.append(" WHERE");
        hql.append(" orderDetail.itemCd = :itemCd");
        hql.append(" AND orderDetail.suppCd = :suppCd");
        hql.append(" AND orderDetail.journalSlipNo IS NULL");
        hql.append(" AND orderDetail.journalSeq IS NULL");
        hql.append(" AND slip.kindMst.kindCd = :kindCd");
        hql.append(" AND slip.slipNo = orderDetail.comp_id.slipNo");
        hql.append(" AND orderDetail.comp_id.seq > 0");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("itemCd", itemMst.getComp_id().getItemCd());
            query.setString("suppCd", itemMst.getComp_id().getSuppCd());
            query.setString("kindCd", "A2");
            result = (Date)query.uniqueResult();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }
}

