/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.db.dao;

import java.io.Serializable;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.db.dao.BaseDAO;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.EmpMst;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class EmpMstDAO
extends BaseDAO {
    public EmpMst load(String empCD) {
        Session session = this.getSession();
        EmpMst empMst = null;
        try {
            empMst = (EmpMst)session.load(EmpMst.class, (Serializable)((Object)empCD));
        }
        finally {
            this.closeSession(session);
        }
        return empMst;
    }

    public List<EmpMst> loadAll() {
        List result = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" empMst");
        hql.append(" FROM");
        hql.append(" EmpMst empMst");
        hql.append(" WHERE empMst.posEmpFlag = :posEmpFlag");
        hql.append(" ORDER BY empMst.empCd");
        try {
            result = session.createQuery(hql.toString()).setString("posEmpFlag", "1").list();
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    public EmpMst findByBarcode(String empBarcode) {
        List list = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" empMst");
        hql.append(" FROM");
        hql.append(" EmpMst empMst");
        hql.append(" WHERE empMst.empBarcode = :empBarcode");
        hql.append(" AND empMst.posEmpFlag = :posEmpFlag");
        hql.append(" AND empMst.func3 >= :func3");
        hql.append(" ORDER BY empMst.empCd");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("empBarcode", empBarcode);
            query.setString("posEmpFlag", "1");
            query.setString("func3", "1");
            list = query.list();
        }
        finally {
            this.closeSession(session);
        }
        if (list.size() > 0) {
            return (EmpMst)list.get(0);
        }
        return null;
    }

    public EmpMst findManagerByBarcode(String empBarcode) {
        List list = null;
        Session session = this.getSession();
        StringBuffer hql = new StringBuffer();
        hql.append("SELECT");
        hql.append(" empMst");
        hql.append(" FROM");
        hql.append(" EmpMst empMst");
        hql.append(" WHERE empMst.empBarcode = :empBarcode");
        hql.append(" AND empMst.posEmpFlag = :posEmpFlag");
        hql.append(" AND empMst.func3 >= :func3");
        hql.append(" ORDER BY empMst.empCd");
        try {
            Query query = session.createQuery(hql.toString());
            query.setString("empBarcode", empBarcode);
            query.setString("posEmpFlag", "1");
            query.setString("func3", "2");
            list = query.list();
        }
        finally {
            this.closeSession(session);
        }
        if (list.size() > 0) {
            return (EmpMst)list.get(0);
        }
        return null;
    }

    public Serializable save(EmpMst empMst) {
        Session session = this.getSession();
        Transaction transaction = null;
        Serializable result = null;
        try {
            try {
                transaction = session.beginTransaction();
                result = session.save((Object)empMst);
                transaction.commit();
            }
            catch (HibernateException e) {
                this.rollback(transaction);
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }
}

