/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.common.utils;

import java.io.UnsupportedEncodingException;
import jp.ne.k_tech.kposrcp.kpos.common.PosConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class PosStringUtils {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final char CHAR_SPACE = ' ';
    public static String charSetName = "JISAutoDetect";

    public static String convert(String data) {
        String result = null;
        try {
            result = new String(data.getBytes("8859_1"), charSetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = data;
        }
        return result;
    }

    public static String defaultEncoding(String data) {
        String result = null;
        try {
            result = new String(data.getBytes(charSetName), "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = data;
        }
        return result;
    }

    public static String fill(String data, char code, int width, int align) {
        String result = data;
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < width - data.length()) {
            buff.append(code);
            ++i;
        }
        result = align == 1 ? String.valueOf(data) + buff.toString() : String.valueOf(buff.toString()) + data;
        return result;
    }

    public static String fill(String data, int width) {
        int length = 0;
        try {
            length = data.getBytes("MS932").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < width - length) {
            buff.append(' ');
            ++i;
        }
        return buff.append(data).toString();
    }

    public static String fill(String data_r, String data_l, int width) {
        int length_r = 0;
        int length_l = 0;
        try {
            length_r = data_r.getBytes("MS932").length;
            length_l = data_l.getBytes("MS932").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        StringBuffer buff = new StringBuffer();
        buff.append(data_r);
        int i = 0;
        while (i < width - (length_r + length_l)) {
            buff.append(' ');
            ++i;
        }
        return buff.append(data_l).toString();
    }

    public static String replace(String message, String before, String after) {
        return StringUtils.replace((String)message, (String)before, (String)after);
    }

    public static boolean isEmpty(String target) {
        return StringUtils.isEmpty((String)target);
    }

    public static boolean isNotEmpty(String target) {
        return !PosStringUtils.isEmpty(target);
    }

    public static boolean isDigits(String target) {
        if (PosStringUtils.isEmpty(target)) {
            return true;
        }
        return NumberUtils.isDigits((String)target);
    }

    public static boolean isInteger(String target) {
        if (PosStringUtils.isEmpty(target)) {
            return true;
        }
        long l = 0L;
        try {
            l = Long.parseLong(target);
        }
        catch (Exception exception) {
            return false;
        }
        return String.valueOf(l).equals(target);
    }

    public static boolean isAlpha(String target) {
        if (PosStringUtils.isEmpty(target)) {
            return true;
        }
        return target.matches("^[a-zA-Z]+$");
    }

    public static boolean isAlphanumeric(String target) {
        if (PosStringUtils.isEmpty(target)) {
            return true;
        }
        return target.matches("^[a-zA-Z0-9]+$");
    }

    public static boolean isAlphanumericSpaceSymbol(String target) {
        if (PosStringUtils.isEmpty(target)) {
            return true;
        }
        return target.matches("^[ -~]+$");
    }

    public static boolean isForbidden(String target) {
        if (PosStringUtils.isEmpty(target)) {
            return false;
        }
        int i = 0;
        while (i < PosConstants.CHAR_FORBIDDEN.length) {
            if (target.indexOf(PosConstants.CHAR_FORBIDDEN[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toString4Bean(Object object) {
        return "call toString4Bean(). this method is not available now.";
    }

    public static byte[] getBytes(String str, String charset) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)charset)) {
            return str.getBytes();
        }
        try {
            return str.getBytes(charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str.getBytes();
        }
    }

    public static byte[] getBytes(String str) {
        return PosStringUtils.getBytes(str, "Shift_JIS");
    }

    public static String cut(String str, int byteLength) {
        String result = null;
        if (str == null) {
            result = "";
            return result;
        }
        if (PosStringUtils.getBytes(str).length <= byteLength) {
            result = str;
        } else {
            result = str.length() <= byteLength ? str : str.substring(0, byteLength);
            while (PosStringUtils.getBytes(result).length > byteLength) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }
}

