/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosStringUtils;
import org.apache.commons.io.IOUtils;

public class PosFileUtils {
    public static final int STRING_BUFFER_MAX = 1024;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readTextFile(String filepath) {
        StringBuffer text = new StringBuffer(1024);
        File file = new File(filepath);
        if (!file.exists()) {
            return "";
        }
        FileInputStream fileInputStream = null;
        try {
            int c;
            fileInputStream = new FileInputStream(file);
            while ((c = fileInputStream.read()) != -1) {
                text.append((char)c);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            text = new StringBuffer();
            if (fileInputStream == null) return PosStringUtils.convert(text.toString());
            try {
                fileInputStream.close();
                return PosStringUtils.convert(text.toString());
            }
            catch (IOException iOException) {}
            return PosStringUtils.convert(text.toString());
        }
        catch (IOException iOException) {
            try {
                text = new StringBuffer();
                if (fileInputStream == null) return PosStringUtils.convert(text.toString());
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                fileInputStream.close();
                return PosStringUtils.convert(text.toString());
            }
            catch (IOException iOException3) {}
            return PosStringUtils.convert(text.toString());
        }
        if (fileInputStream == null) return PosStringUtils.convert(text.toString());
        try {
            fileInputStream.close();
            return PosStringUtils.convert(text.toString());
        }
        catch (IOException iOException) {}
        return PosStringUtils.convert(text.toString());
    }

    /*
     * Loose catch block
     */
    public static List<String> readTextFile2List(String path) {
        ArrayList<String> list;
        block37: {
            FileInputStream fis;
            block40: {
                BufferedReader reader = null;
                fis = null;
                list = new ArrayList<String>();
                File file = new File(path);
                if (!file.exists()) {
                    return list;
                }
                try {
                    String line;
                    fis = new FileInputStream(file);
                    reader = new BufferedReader(new InputStreamReader((InputStream)fis, "MS932"));
                    while ((line = reader.readLine()) != null) {
                        list.add(line);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block37;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    block38: {
                        if (reader == null) break block38;
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block37;
                }
                catch (IOException iOException) {
                    block39: {
                        if (reader == null) break block39;
                        {
                            catch (Throwable throwable) {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                if (fis != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (IOException iOException3) {}
                                }
                                throw throwable;
                            }
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException iOException4) {}
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException5) {}
                    }
                    break block37;
                }
                if (reader == null) break block40;
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    public static synchronized void removeFiles(String path) {
        PosFileUtils.removeFiles(new File(path), false);
    }

    public static synchronized void removeFiles(File file, boolean removeDir) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                PosFileUtils.removeFiles(files[i], true);
                ++i;
            }
            if (removeDir) {
                file.delete();
            }
        }
    }

    public static synchronized void createFile(String path, String body) {
        PrintWriter pw = null;
        try {
            try {
                pw = new PrintWriter(new FileWriter(path));
                pw.print(body);
            }
            catch (IOException iOException) {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static boolean exists(String path) {
        File pathname = new File(path);
        return pathname.exists();
    }

    public static synchronized void createTriggerFile() {
        File pathname = new File(Activator.getDefault().getPreferenceStore().getString("DBLINK_TRIGGER"));
        if (pathname.exists()) {
            return;
        }
        PosFileUtils.createFile(pathname.getPath(), "");
    }

    public static String getFileName(String filePath) {
        String fileName = filePath;
        int idx = filePath.lastIndexOf("\\");
        if (idx > 0) {
            fileName = fileName.substring(idx + 1);
        }
        return fileName;
    }

    public static void appendLineToFile(String filePath, List<String> lineList) throws IOException {
        FileWriter fileWriter = null;
        BufferedWriter writer = null;
        try {
            fileWriter = new FileWriter(new File(filePath), true);
            writer = new BufferedWriter(fileWriter);
            for (String line : lineList) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((Writer)fileWriter);
    }
}

