/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos;

import java.util.List;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosAbstract;
import jp.ne.k_tech.kposrcp.kpos.PosItemList;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.MstManager;
import jp.ne.k_tech.kposrcp.kpos.common.exception.AbsentMstException;
import jp.ne.k_tech.kposrcp.kpos.common.utils.PosNumberUtils;
import jp.ne.k_tech.kposrcp.kpos.db.valueobject.ItemMst;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogEmpChange;
import jp.ne.k_tech.kposrcp.kpos.gui.component.ExGridData;
import jp.ne.k_tech.kposrcp.kpos.gui.component.KeyEventEmulateButton;
import jp.ne.k_tech.kposrcp.kpos.gui.component.MoneyText;
import jp.ne.k_tech.kposrcp.kpos.gui.component.QuantityText;
import jp.ne.k_tech.kposrcp.kpos.list.EditableColumns;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class PosTabFolder {
    private static Log log = LogFactory.getLog(PosTabFolder.class);
    private static final int TAB_LENGTH = 24;
    private PosMain posMain = null;
    private PosAbstract[] posAbstract = new PosAbstract[24];
    private CTabFolder tabFolder = null;
    public static final int INDEX_SALES = 0;
    public static final int[] TAB_INDEXES = new int[1];
    public static final Color[] BGCOLOR_TAB = new Color[]{JFaceResources.getColorRegistry().get("tan"), JFaceResources.getColorRegistry().get("lawngreen"), JFaceResources.getColorRegistry().get("gold"), JFaceResources.getColorRegistry().get("tomato"), JFaceResources.getColorRegistry().get("darkseagreen"), JFaceResources.getColorRegistry().get("orchid"), JFaceResources.getColorRegistry().get("tan")};
    private Text[] itemsQuantityTotal = new Text[24];
    private Text[] itemsAmount = new Text[24];
    private Text[] itemsTax = new Text[24];
    private Text[] itemsAmountWithTax = new Text[24];
    private Text[] itemsCostAmount = new Text[24];
    private Text[] itemsCostTax = new Text[24];
    private Text[] itemsCostAmountWithTax = new Text[24];
    private Text[][] itemsTableFooter = new Text[][]{this.itemsAmount, this.itemsTax, this.itemsAmountWithTax, this.itemsCostAmount, this.itemsCostTax, this.itemsCostAmountWithTax};
    private Text salesMoney = null;
    private Text salesChange = null;
    private Text moveinReceiptItemsQuantity = null;
    private Text moveinReceiptFromStore = null;

    public PosTabFolder(PosMain posMain) {
        this.posMain = posMain;
    }

    public PosAbstract[] getPosAbstract() {
        return this.posAbstract;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void createTabFolder() {
        Composite area = new Composite((Composite)this.posMain.getVerticalForm(), 0);
        area.setLayout((Layout)new GridLayout(1, true));
        area.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.tabFolder = new CTabFolder(area, 2048);
        this.tabFolder.setTabHeight(34);
        this.tabFolder.setSelectionBackground(new Color[]{Display.getCurrent().getSystemColor(31), Display.getCurrent().getSystemColor(32)}, new int[]{90}, true);
        this.tabFolder.setSelectionForeground(Display.getCurrent().getSystemColor(1));
        this.tabFolder.setLayout((Layout)new GridLayout(1, true));
        this.tabFolder.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                log.debug((Object)("mouseDown():" + e.getSource().toString()));
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean auth = false;
                PosTabFolder.this.posMain.setLoginFlag(true);
                DialogEmpChange dialogEmpChange = new DialogEmpChange(auth);
                dialogEmpChange.create(PosTabFolder.this.posMain, Display.getCurrent(), 0);
                PosTabFolder.this.posMain.getKeyEventHandler().setDialog(dialogEmpChange);
            }
        });
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        CTabItem item2 = new CTabItem(this.tabFolder, 0, 0);
        item2.setText("F2:\u8ca9\u58f2");
        item2.setFont(this.posMain.getNormalFont());
        Image image2 = imageRegistry.get("iconf2");
        item2.setImage(image2);
        Composite area2 = new Composite((Composite)this.tabFolder, 0);
        area2.setBackground(BGCOLOR_TAB[0]);
        area2.setLayout((Layout)new GridLayout(1, true));
        area2.setLayoutData((Object)new ExGridData().getGridData(true, true, true, true));
        this.posAbstract[0] = new PosItemList();
        EditableColumns editableSales = new EditableColumns();
        editableSales.add("\u8ca9\u58f2\u4fa1\u683c");
        editableSales.add("\u6570\u91cf");
        this.posAbstract[0].create(this.posMain, area2, editableSales, 0);
        Composite area2Bottom = new Composite(area2, 0);
        area2Bottom.setLayout((Layout)new GridLayout(13, false));
        area2Bottom.setBackground(BGCOLOR_TAB[0]);
        Label labelSalesItemQuantityTotal = new Label(area2Bottom, 0);
        labelSalesItemQuantityTotal.setText("\u5546\u54c1\u70b9\u6570");
        labelSalesItemQuantityTotal.setBackground(BGCOLOR_TAB[0]);
        this.itemsQuantityTotal[0] = new QuantityText(this.posMain, area2Bottom).getText(false);
        Label labelSalesItemAmount = new Label(area2Bottom, 0);
        labelSalesItemAmount.setText("\u3000\uff08\u7a0e\u629c\u304d\u5408\u8a08");
        labelSalesItemAmount.setBackground(BGCOLOR_TAB[0]);
        GridData gridData = new GridData();
        gridData.widthHint = 30;
        this.itemsQuantityTotal[0].setLayoutData((Object)gridData);
        this.itemsAmount[0] = new MoneyText(this.posMain, area2Bottom).getText(false);
        Label labelSalesItemTax = new Label(area2Bottom, 0);
        labelSalesItemTax.setText("\u5186\uff0b\u7a0e");
        labelSalesItemTax.setBackground(BGCOLOR_TAB[0]);
        gridData = new GridData();
        gridData.widthHint = 80;
        this.itemsAmount[0].setLayoutData((Object)gridData);
        this.itemsTax[0] = new MoneyText(this.posMain, area2Bottom).getText(false);
        Label labelSalesItemAmountWithTax = new Label(area2Bottom, 0);
        labelSalesItemAmountWithTax.setText("\u5186\uff09\u3000\u7a0e\u8fbc\u307f\u5408\u8a08");
        labelSalesItemAmountWithTax.setBackground(BGCOLOR_TAB[0]);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.itemsTax[0].setLayoutData((Object)gridData);
        this.itemsAmountWithTax[0] = new MoneyText(this.posMain, area2Bottom).getText(false);
        this.itemsAmountWithTax[0].setBackground(JFaceResources.getColorRegistry().get("poskohiki"));
        this.itemsAmountWithTax[0].setForeground(JFaceResources.getColorRegistry().get("white"));
        this.itemsAmountWithTax[0].setFont(JFaceResources.getFontRegistry().getBold("posexlargen"));
        this.itemsAmountWithTax[0].setText("--,---,---");
        gridData = new GridData();
        gridData.widthHint = 130;
        this.itemsAmountWithTax[0].setLayoutData((Object)gridData);
        Label labelSalesMoney = new Label(area2Bottom, 0);
        labelSalesMoney.setText("\u5186\u3000\u9810\u308a\u91d1");
        labelSalesMoney.setBackground(BGCOLOR_TAB[0]);
        this.salesMoney = new MoneyText(this.posMain, area2Bottom).getText(false);
        Label labelSalesChange = new Label(area2Bottom, 0);
        labelSalesChange.setText("\u5186\u3000\u304a\u91e3\u308a");
        labelSalesChange.setBackground(BGCOLOR_TAB[0]);
        gridData = new GridData();
        gridData.widthHint = 80;
        this.salesMoney.setLayoutData((Object)gridData);
        this.salesChange = new MoneyText(this.posMain, area2Bottom).getText(false);
        Label labelSalesChangeEnd = new Label(area2Bottom, 0);
        labelSalesChangeEnd.setText("\u5186\u3000");
        labelSalesChangeEnd.setBackground(BGCOLOR_TAB[0]);
        gridData = new GridData();
        gridData.widthHint = 80;
        this.salesChange.setLayoutData((Object)gridData);
        Composite area2Button = new Composite(area2, 0);
        area2Button.setLayout((Layout)new GridLayout(4, false));
        area2Button.setBackground(BGCOLOR_TAB[0]);
        new KeyEventEmulateButton(area2Button, "[ . ]\u8ca9\u58f2", '.');
        new KeyEventEmulateButton(area2Button, "[/]\u5546\u54c1\u5024\u5f15", '/');
        new KeyEventEmulateButton(area2Button, "[Del]\u884c\u524a\u9664", 127);
        new KeyEventEmulateButton(area2Button, "[Pause]\u5168\u30af\u30ea\u30a2", 0x1000055);
        item2.setControl((Control)area2);
        area.layout();
        area.pack();
    }

    public long calcQuantityTotal() {
        int tabindex = this.getTabFolder().getSelectionIndex();
        Text target = this.itemsQuantityTotal[tabindex];
        if (target == null) {
            return 0L;
        }
        long total = 0L;
        Table table = this.posAbstract[tabindex].getItemList().getTableItemList();
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            total += NumberUtils.toLong((String)table.getItem(i).getText(10));
            ++i;
        }
        target.setText(PosNumberUtils.commaFormat(total));
        return total;
    }

    public long calcAmount() {
        int tabindex = this.getTabFolder().getSelectionIndex();
        Text target = this.itemsAmount[tabindex];
        if (target == null) {
            return 0L;
        }
        long total = 0L;
        Table table = this.posAbstract[tabindex].getItemList().getTableItemList();
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            total += NumberUtils.toLong((String)table.getItem(i).getText(10)) * NumberUtils.toLong((String)table.getItem(i).getText(11));
            ++i;
        }
        target.setText(PosNumberUtils.commaFormat(total));
        return total;
    }

    public long calcTax() {
        int tabindex = this.getTabFolder().getSelectionIndex();
        Text target = this.itemsTax[tabindex];
        if (target == null) {
            return 0L;
        }
        long total = 0L;
        Table table = this.posAbstract[tabindex].getItemList().getTableItemList();
        List<ItemMst> bodyList = this.posAbstract[tabindex].getItemList().getBodyList();
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            total += NumberUtils.toLong((String)table.getItem(i).getText(10)) * PosNumberUtils.tax(NumberUtils.toLong((String)table.getItem(i).getText(11)), bodyList.get(i).getPriceTaxKind());
            ++i;
        }
        target.setText(PosNumberUtils.commaFormat(total));
        return total;
    }

    public long calcAmountWithTax() {
        int tabindex = this.getTabFolder().getSelectionIndex();
        Text target = this.itemsAmountWithTax[tabindex];
        if (target == null) {
            return 0L;
        }
        long total = 0L;
        long discount = 0L;
        Table table = this.posAbstract[tabindex].getItemList().getTableItemList();
        List<ItemMst> bodyList = this.posAbstract[tabindex].getItemList().getBodyList();
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            total += NumberUtils.toLong((String)table.getItem(i).getText(10)) * PosNumberUtils.amountWithTax(NumberUtils.toLong((String)table.getItem(i).getText(11)), bodyList.get(i).getPriceTaxKind());
            discount += NumberUtils.toLong((String)table.getItem(i).getText(12));
            ++i;
        }
        target.setText(PosNumberUtils.commaFormat(total + discount));
        return total + discount;
    }

    public long calcCostAmount() {
        int tabindex = this.getTabFolder().getSelectionIndex();
        Text target = this.itemsCostAmount[tabindex];
        if (target == null) {
            return 0L;
        }
        int costCol = 12;
        long total = 0L;
        Table table = this.posAbstract[tabindex].getItemList().getTableItemList();
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            total += NumberUtils.toLong((String)table.getItem(i).getText(10)) * NumberUtils.toLong((String)table.getItem(i).getText(costCol));
            ++i;
        }
        target.setText(PosNumberUtils.commaFormat(total));
        return total;
    }

    public long calcCostTax() {
        int tabindex = this.getTabFolder().getSelectionIndex();
        Text target = this.itemsCostTax[tabindex];
        if (target == null) {
            return 0L;
        }
        int costCol = 12;
        long total = 0L;
        Table table = this.posAbstract[tabindex].getItemList().getTableItemList();
        List<ItemMst> bodyList = this.posAbstract[tabindex].getItemList().getBodyList();
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            total += NumberUtils.toLong((String)table.getItem(i).getText(10)) * PosNumberUtils.tax(NumberUtils.toLong((String)table.getItem(i).getText(costCol)), bodyList.get(i).getCostTaxKind());
            ++i;
        }
        target.setText(PosNumberUtils.commaFormat(total));
        return total;
    }

    public long calcCostAmountWithTax() {
        int tabindex = this.getTabFolder().getSelectionIndex();
        Text target = this.itemsCostAmountWithTax[tabindex];
        if (target == null) {
            return 0L;
        }
        int costCol = 12;
        long total = 0L;
        Table table = this.posAbstract[tabindex].getItemList().getTableItemList();
        List<ItemMst> bodyList = this.posAbstract[tabindex].getItemList().getBodyList();
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            total += NumberUtils.toLong((String)table.getItem(i).getText(10)) * PosNumberUtils.amountWithTax(NumberUtils.toLong((String)table.getItem(i).getText(costCol)), bodyList.get(i).getCostTaxKind());
            ++i;
        }
        target.setText(PosNumberUtils.commaFormat(total));
        return total;
    }

    public long calcRecycleItemAmount() {
        long total = 0L;
        int tabindex = this.getTabFolder().getSelectionIndex();
        Table table = this.posAbstract[tabindex].getItemList().getTableItemList();
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            total += NumberUtils.toLong((String)table.getItem(i).getText(11));
            ++i;
        }
        return total;
    }

    public void updateTableFooter() {
        this.calcQuantityTotal();
        this.calcAmount();
        this.calcTax();
        this.calcAmountWithTax();
        this.calcCostAmount();
        this.calcCostTax();
        this.calcCostAmountWithTax();
    }

    public void initTableFooter() {
        String co = PosNumberUtils.commaFormat(0L);
        int i = 0;
        while (i < this.itemsQuantityTotal.length) {
            Text target = this.itemsQuantityTotal[i];
            if (target != null) {
                target.setText(co);
            }
            ++i;
        }
        i = 0;
        while (i < this.itemsTableFooter.length) {
            int j = 0;
            while (j < TAB_INDEXES.length) {
                Text target = this.itemsTableFooter[i][j];
                if (target != null) {
                    target.setText(co);
                }
                ++j;
            }
            ++i;
        }
        this.salesMoney.setText(co);
        this.salesChange.setText(co);
    }

    public void setSalesMoney(long val) {
        this.salesMoney.setText(PosNumberUtils.commaFormat(val));
    }

    public void setSalesChange(long val) {
        this.salesChange.setText(PosNumberUtils.commaFormat(val));
    }

    public void setAmountWithTax(long val) {
        int tabindex = this.getTabFolder().getSelectionIndex();
        Text target = this.itemsAmountWithTax[tabindex];
        target.setText(PosNumberUtils.commaFormat(val));
    }

    public void setMoveinReceiptItemsQuantity(String val) {
        this.moveinReceiptItemsQuantity.setText(StringUtils.defaultString((String)val));
    }

    public void setMoveinReceiptFromStore(String fromStoreCd) {
        String fromStoreName = null;
        if (StringUtils.isNotEmpty((String)fromStoreCd)) {
            try {
                fromStoreName = MstManager.getInstance().findStoreNameByCD(fromStoreCd);
            }
            catch (AbsentMstException absentMstException) {
                fromStoreName = fromStoreCd;
            }
        }
        this.moveinReceiptFromStore.setText(StringUtils.defaultString(fromStoreName));
    }

    public Text[] getItemsAmount() {
        return this.itemsAmount;
    }

    public void setItemsAmount(Text[] itemsAmount) {
        this.itemsAmount = itemsAmount;
    }

    public Text[] getItemsAmountWithTax() {
        return this.itemsAmountWithTax;
    }

    public void setItemsAmountWithTax(Text[] itemsAmountWithTax) {
        this.itemsAmountWithTax = itemsAmountWithTax;
    }

    public Text[] getItemsCostAmount() {
        return this.itemsCostAmount;
    }

    public void setItemsCostAmount(Text[] itemsCostAmount) {
        this.itemsCostAmount = itemsCostAmount;
    }

    public Text[] getItemsCostAmountWithTax() {
        return this.itemsCostAmountWithTax;
    }

    public void setItemsCostAmountWithTax(Text[] itemsCostAmountWithTax) {
        this.itemsCostAmountWithTax = itemsCostAmountWithTax;
    }

    public Text[] getItemsCostTax() {
        return this.itemsCostTax;
    }

    public void setItemsCostTax(Text[] itemsCostTax) {
        this.itemsCostTax = itemsCostTax;
    }

    public Text[] getItemsQuantityTotal() {
        return this.itemsQuantityTotal;
    }

    public void setItemsQuantityTotal(Text[] itemsQuantityTotal) {
        this.itemsQuantityTotal = itemsQuantityTotal;
    }

    public Text[][] getItemsTableFooter() {
        return this.itemsTableFooter;
    }

    public void setItemsTableFooter(Text[][] itemsTableFooter) {
        this.itemsTableFooter = itemsTableFooter;
    }

    public Text[] getItemsTax() {
        return this.itemsTax;
    }

    public void setItemsTax(Text[] itemsTax) {
        this.itemsTax = itemsTax;
    }

    public Text getSalesChange() {
        return this.salesChange;
    }

    public void setSalesChange(Text salesChange) {
        this.salesChange = salesChange;
    }

    public Text getSalesMoney() {
        return this.salesMoney;
    }

    public void setSalesMoney(Text salesMoney) {
        this.salesMoney = salesMoney;
    }
}

