/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.kpos;

import jp.ne.k_tech.kposrcp.device.opos.OposController;
import jp.ne.k_tech.kposrcp.device.opos.OposCustomerDisplay;
import jp.ne.k_tech.kposrcp.kpos.Activator;
import jp.ne.k_tech.kposrcp.kpos.PosMain;
import jp.ne.k_tech.kposrcp.kpos.common.PosCommon;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogAbstract;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogCashier;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogCheck;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogCustomerCount;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogDiscount;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogEmpChange;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogExpense;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogItemSearch;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogJournalSearch;
import jp.ne.k_tech.kposrcp.kpos.dialogs.DialogReceiptPrintConfirm;
import jp.ne.k_tech.kposrcp.kpos.list.ItemList;
import jp.ne.k_tech.kposrcp.kpos.logic.BarcodeScanner;
import jp.ne.k_tech.kposrcp.kpos.logic.PosChange;
import jp.ne.k_tech.kposrcp.kpos.logic.PosDrawer;
import jp.ne.k_tech.kposrcp.kpos.print.display.DisplaySales;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PosKeyEventHandler
implements KeyListener {
    private static Log log = LogFactory.getLog(PosKeyEventHandler.class);
    private PosMain posMain = null;
    private DialogAbstract dialog = null;
    private StringBuffer buff = new StringBuffer();
    private int barcodeTerminateCode;

    public PosKeyEventHandler(PosMain posMain) {
        this.posMain = posMain;
        this.barcodeTerminateCode = Activator.getDefault().getPreferenceStore().getInt("BARCODE_TERMINAL_CODE");
    }

    public DialogAbstract getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogAbstract dialog) {
        this.dialog = dialog;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 65536) {
            e.doit = false;
        } else if (e.keyCode == 0x1000013) {
            e.doit = false;
        } else if (e.keyCode == 262144) {
            this.posMain.getFunctionBar().switchFunction(true);
        } else if (e.keyCode == 0x100000F && (e.stateMask & 0x10000) != 0) {
            e.doit = false;
        }
        if ((e.stateMask & 0x40000) != 0) {
            switch (e.keyCode) {
                case 0x100000A: {
                    if (!this.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(12, false);
                    break;
                }
                case 0x100000B: {
                    if (!this.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(13, false);
                    break;
                }
                case 0x100000C: {
                    if (!this.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(14, false);
                    break;
                }
                case 0x100000D: {
                    if (!this.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(15, false);
                    break;
                }
                case 0x100000E: {
                    this.posMain.getFunctionBar().setActive(16, false);
                    break;
                }
                case 0x100000F: {
                    if (!this.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(17, false);
                    break;
                }
                case 0x1000010: {
                    this.posMain.getFunctionBar().setActive(18, false);
                    break;
                }
                case 0x1000011: {
                    this.posMain.getFunctionBar().setActive(19, false);
                    break;
                }
                case 0x1000012: {
                    this.posMain.getFunctionBar().setActive(20, false);
                    break;
                }
                case 0x1000013: {
                    this.posMain.getFunctionBar().setActive(21, false);
                    break;
                }
                case 0x1000014: {
                    this.posMain.getFunctionBar().setActive(22, false);
                    break;
                }
                case 0x1000015: {
                    this.posMain.getFunctionBar().setActive(23, false);
                }
            }
        } else {
            switch (e.keyCode) {
                case 0x100000A: {
                    this.posMain.getFunctionBar().setActive(0, false);
                    break;
                }
                case 0x100000B: {
                    this.posMain.getFunctionBar().setActive(1, false);
                    break;
                }
                case 0x100000C: {
                    this.posMain.getFunctionBar().setActive(2, false);
                    break;
                }
                case 0x100000D: {
                    if (!this.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(3, false);
                    break;
                }
                case 0x100000E: {
                    if (!this.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(4, false);
                    break;
                }
                case 0x100000F: {
                    this.posMain.getFunctionBar().setActive(5, false);
                    break;
                }
                case 0x1000010: {
                    this.posMain.getFunctionBar().setActive(6, false);
                    break;
                }
                case 0x1000011: {
                    this.posMain.getFunctionBar().setActive(7, false);
                    break;
                }
                case 0x1000012: {
                    this.posMain.getFunctionBar().setActive(8, false);
                    break;
                }
                case 0x1000013: {
                    this.posMain.getFunctionBar().setActive(9, false);
                    break;
                }
                case 0x1000014: {
                    this.posMain.getFunctionBar().setActive(10, false);
                    break;
                }
                case 0x1000015: {
                    this.posMain.getFunctionBar().setActive(11, false);
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        char character = e.character;
        if (Character.isLetterOrDigit(character)) {
            if ((character == 'L' || character == 'l') && (e.stateMask & 0x10000) != 0) {
                log.debug((Object)("::::: keyReleased [" + character + "] :::::"));
            }
            if (Character.isDigit(character)) {
                this.buff.append(character);
                if (!this.buff.toString().toUpperCase().startsWith("A")) {
                    this.posMain.getStatusBar().setText(this.buff.toString());
                }
            } else if (character == 'a' || character == 'A') {
                if (this.buff.length() == 0) {
                    this.buff.append(character);
                } else if (this.buff.length() == 9 && this.buff.toString().toUpperCase().startsWith("A")) {
                    this.buff.append(character);
                }
            } else if ((character == 'n' || character == 'N') && this.buff.length() == 0) {
                this.buff.append(character);
                this.posMain.getStatusBar().setText(this.buff.toString());
            } else if ((character == 'x' || character == 'X') && this.buff.length() == 10 && this.buff.toString().toUpperCase().startsWith("N")) {
                this.buff.append(character);
                this.posMain.getStatusBar().setText(this.buff.toString());
            }
        } else if (character == '-' && this.buff.toString().toUpperCase().startsWith("N")) {
            log.debug((Object)"hyphen in ISBN is ignored.");
        } else if (character == ',' && this.buff.length() == 13) {
            this.buff.append(character);
            this.posMain.getStatusBar().setText(this.buff.toString());
        } else {
            switch (character) {
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': {
                    if (this.buff.length() == 0) {
                        this.event(String.valueOf(character));
                        break;
                    }
                    this.buff.delete(0, this.buff.length());
                    this.event(String.valueOf(character));
                }
            }
        }
        String key = null;
        if (e.keyCode == this.barcodeTerminateCode) {
            key = "VK_SPACE";
            this.event(key);
            this.buff.delete(0, this.buff.length());
        }
        switch (e.keyCode) {
            case 27: {
                key = "VK_ESCAPE";
                this.event(key);
                this.buff.delete(0, this.buff.length());
                this.posMain.getStatusBar().setText(this.buff.toString());
                break;
            }
            case 8: {
                key = "VK_BACK_SPACE";
                this.event(key);
                this.buff.delete(Math.max(0, this.buff.length() - 1), this.buff.length());
                this.posMain.getStatusBar().setText(this.buff.toString());
                break;
            }
            case 127: {
                key = "VK_DELETE";
                this.event(key);
                this.buff.delete(0, this.buff.length());
                this.posMain.getStatusBar().setText(this.buff.toString());
                break;
            }
            case 13: {
                key = "VK_CR";
                this.event(key);
                this.buff.delete(0, this.buff.length());
                break;
            }
            case 0x1000050: {
                key = "VK_CR";
                this.event(key);
                this.buff.delete(0, this.buff.length());
                break;
            }
            case 0x1000055: {
                key = "VK_PAUSE";
                this.event(key);
                this.buff.delete(0, this.buff.length());
                this.posMain.getStatusBar().setText(this.buff.toString());
                break;
            }
            case 0x1000001: {
                key = "VK_ARROW_UP";
                this.event(key);
                this.buff.delete(0, this.buff.length());
                break;
            }
            case 0x1000002: {
                key = "VK_ARROW_DOWN";
                this.event(key);
                this.buff.delete(0, this.buff.length());
                break;
            }
            case 262144: {
                this.posMain.getFunctionBar().switchFunction(false);
            }
        }
        int functionIndex = -1;
        if ((e.stateMask & 0x40000) != 0) {
            switch (e.keyCode) {
                case 0x100000A: {
                    if (!PosCommon.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(12, true);
                    functionIndex = 12;
                    break;
                }
                case 0x100000B: {
                    if (!PosCommon.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(13, true);
                    functionIndex = 13;
                    break;
                }
                case 0x100000C: {
                    if (!PosCommon.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(14, true);
                    functionIndex = 14;
                    break;
                }
                case 0x100000D: {
                    if (!PosCommon.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(15, true);
                    functionIndex = 15;
                    break;
                }
                case 0x100000E: {
                    this.posMain.getFunctionBar().setActive(16, true);
                    functionIndex = 16;
                    break;
                }
                case 0x100000F: {
                    if (!PosCommon.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(17, true);
                    functionIndex = 17;
                    break;
                }
                case 0x1000010: {
                    this.posMain.getFunctionBar().setActive(18, true);
                    functionIndex = 18;
                    break;
                }
                case 0x1000011: {
                    this.posMain.getFunctionBar().setActive(19, true);
                    functionIndex = 19;
                    break;
                }
                case 0x1000012: {
                    this.posMain.getFunctionBar().setActive(20, true);
                    functionIndex = 20;
                    break;
                }
                case 0x1000013: {
                    this.posMain.getFunctionBar().setActive(21, true);
                    functionIndex = 21;
                    break;
                }
                case 0x1000014: {
                    this.posMain.getFunctionBar().setActive(22, true);
                    functionIndex = 22;
                    break;
                }
                case 0x1000015: {
                    this.posMain.getFunctionBar().setActive(23, true);
                    functionIndex = 23;
                }
            }
        } else {
            switch (e.keyCode) {
                case 0x100000A: {
                    functionIndex = 0;
                    this.posMain.getFunctionBar().setActive(0, true);
                    if (!PosCommon.authorize()) break;
                    this.posMain.getFunctionBar().setActive(12, true);
                    break;
                }
                case 0x100000B: {
                    functionIndex = 1;
                    this.posMain.getFunctionBar().setActive(1, true);
                    if (!PosCommon.authorize()) break;
                    this.posMain.getFunctionBar().setActive(13, true);
                    break;
                }
                case 0x100000C: {
                    functionIndex = 2;
                    this.posMain.getFunctionBar().setActive(2, true);
                    if (!PosCommon.authorize()) break;
                    this.posMain.getFunctionBar().setActive(14, true);
                    break;
                }
                case 0x100000D: {
                    if (!PosCommon.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(3, true);
                    this.posMain.getFunctionBar().setActive(15, true);
                    functionIndex = 3;
                    break;
                }
                case 0x100000E: {
                    this.posMain.getFunctionBar().setActive(16, true);
                    if (!PosCommon.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(4, true);
                    functionIndex = 4;
                    break;
                }
                case 0x100000F: {
                    this.posMain.getFunctionBar().setActive(5, true);
                    if (!PosCommon.authorize()) {
                        return;
                    }
                    this.posMain.getFunctionBar().setActive(17, true);
                    functionIndex = 5;
                    break;
                }
                case 0x1000010: {
                    this.posMain.getFunctionBar().setActive(6, true);
                    this.posMain.getFunctionBar().setActive(18, true);
                    functionIndex = 6;
                    break;
                }
                case 0x1000011: {
                    this.posMain.getFunctionBar().setActive(7, true);
                    this.posMain.getFunctionBar().setActive(19, true);
                    functionIndex = 7;
                    break;
                }
                case 0x1000012: {
                    this.posMain.getFunctionBar().setActive(8, true);
                    this.posMain.getFunctionBar().setActive(20, true);
                    functionIndex = 8;
                    break;
                }
                case 0x1000013: {
                    this.posMain.getFunctionBar().setActive(9, true);
                    this.posMain.getFunctionBar().setActive(21, true);
                    functionIndex = 9;
                    break;
                }
                case 0x1000014: {
                    this.posMain.getFunctionBar().setActive(10, true);
                    this.posMain.getFunctionBar().setActive(22, true);
                    functionIndex = 10;
                    break;
                }
                case 0x1000015: {
                    this.posMain.getFunctionBar().setActive(11, true);
                    this.posMain.getFunctionBar().setActive(23, true);
                    functionIndex = 11;
                }
            }
        }
        if (functionIndex >= 0) {
            String function = this.posMain.getFunctionBar().getActionCommand(functionIndex);
            this.event(function);
        }
    }

    public synchronized void event(String data) {
        if (data.length() == 0) {
            return;
        }
        log.debug((Object)("\u6587\u5b57\u5217\uff1a" + data));
        int tabIndex = -1;
        if (data.startsWith("F")) {
            DialogAbstract dialog;
            if (data.startsWith("F1:")) {
                dialog = new DialogEmpChange(false);
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.setDialog(dialog);
            } else if (data.startsWith("F3:")) {
                tabIndex = 0;
            } else if (data.startsWith("F7:")) {
                dialog = new DialogEmpChange(false);
                this.setDialog(dialog);
                int result = dialog.open(this.posMain, Display.getCurrent(), 0);
                log.debug((Object)("result:" + (result == 64 ? "SWT.YES" : "SWT.NO")));
                if (64 == result) {
                    dialog = new DialogCheck();
                    this.setDialog(dialog);
                    dialog.create(this.posMain, Display.getCurrent(), 0);
                }
            } else if (data.startsWith("F8:")) {
                dialog = new DialogCustomerCount();
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.setDialog(dialog);
            } else if (data.startsWith("F9:")) {
                PosChange posChange = new PosChange(this.posMain);
                posChange.execute();
            } else if (data.startsWith("F10:")) {
                dialog = new DialogJournalSearch();
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.setDialog(dialog);
            } else if (data.startsWith("F11:")) {
                dialog = new DialogItemSearch();
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.setDialog(dialog);
            } else if (data.startsWith("F12:")) {
                this.posMain.getStatusBar().setText("");
                PlatformUI.getWorkbench().close();
            } else if (data.startsWith("F19:")) {
                dialog = new DialogJournalSearch();
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.setDialog(dialog);
            } else if (data.startsWith("F20:")) {
                dialog = new DialogExpense();
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.setDialog(dialog);
            } else if (data.startsWith("F22:")) {
                dialog = new DialogReceiptPrintConfirm();
                dialog.create(this.posMain, Display.getCurrent(), 0);
                this.setDialog(dialog);
            } else if (!data.startsWith("F23:")) {
                data.startsWith("F24:");
            }
        }
        if (tabIndex >= 0) {
            this.posMain.getPosTabFolder().getTabFolder().setSelection(tabIndex);
            DialogEmpChange dialogEmpChange = new DialogEmpChange(false);
            dialogEmpChange.create(this.posMain, Display.getCurrent(), 0);
            this.posMain.getKeyEventHandler().setDialog(dialogEmpChange);
        }
        tabIndex = this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex();
        ItemList itemList = this.posMain.getPosTabFolder().getPosAbstract()[tabIndex].getItemList();
        if (data.startsWith("VK")) {
            if ("VK_ESCAPE".equals(data)) {
                itemList.getBarcodeScanner().reset();
            } else if (!"VK_BACK_SPACE".equals(data)) {
                if ("VK_DELETE".equals(data)) {
                    itemList.removeRow();
                    itemList.getBarcodeScanner().reset();
                } else if ("VK_SPACE".equals(data)) {
                    this.scan(this.buff.toString());
                } else if ("VK_CR".equals(data)) {
                    this.scan(this.buff.toString());
                } else if ("VK_PAUSE".equals(data)) {
                    itemList.removeAll();
                    itemList.getBarcodeScanner().reset();
                    OposCustomerDisplay customerDisplay = OposController.getInstance().getCustomerDisplay();
                    customerDisplay.clear();
                } else if (!"VK_ARROW_UP".equals(data)) {
                    "VK_ARROW_DOWN".equals(data);
                }
            }
        }
        if (data.length() == 1) {
            switch (data.charAt(0)) {
                case '+': {
                    if (itemList.getFinished()) {
                        this.posMain.getStatusBar().setText("\u64cd\u4f5c\u3092\u7d99\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u3066\u3044\u307e\u3059\u3002");
                        return;
                    }
                    if (itemList.getTableItemList().getSelectionCount() != 1) {
                        this.posMain.getStatusBar().setText("\u64cd\u4f5c\u3092\u7d99\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u5546\u54c1\u304c\u6b63\u3057\u304f\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        return;
                    }
                    this.posMain.getPosTabFolder().getPosAbstract()[tabIndex].getItemList().increment();
                    break;
                }
                case '-': {
                    if (itemList.getFinished()) {
                        this.posMain.getStatusBar().setText("\u64cd\u4f5c\u3092\u7d99\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u3066\u3044\u307e\u3059\u3002");
                        return;
                    }
                    if (itemList.getTableItemList().getSelectionCount() != 1) {
                        this.posMain.getStatusBar().setText("\u64cd\u4f5c\u3092\u7d99\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u5546\u54c1\u304c\u6b63\u3057\u304f\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        return;
                    }
                    this.posMain.getPosTabFolder().getPosAbstract()[tabIndex].getItemList().decrement();
                    break;
                }
                case '*': {
                    return;
                }
                case '/': {
                    if (itemList.getFinished()) {
                        this.posMain.getStatusBar().setText("\u64cd\u4f5c\u3092\u7d99\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u3066\u3044\u307e\u3059\u3002");
                        return;
                    }
                    if (itemList.getTableItemList().getItemCount() < 1) {
                        this.posMain.getStatusBar().setText("\u64cd\u4f5c\u3092\u7d99\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u5546\u54c1\u4e00\u89a7\u306b\u8a08\u4e0a\u3055\u308c\u3066\u3044\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                        return;
                    }
                    if (tabIndex != 0) break;
                    log.debug((Object)"\u8ca9\u58f2\u5024\u5f15\u958b\u59cb");
                    DialogDiscount dialog = new DialogDiscount();
                    dialog.create(this.posMain, Display.getCurrent(), 0);
                    this.setDialog(dialog);
                    break;
                }
                case '.': {
                    if (itemList.getFinished()) {
                        log.debug((Object)"\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u3066\u3044\u307e\u3059\u3002");
                        this.posMain.getStatusBar().setText("\u64cd\u4f5c\u3092\u7d99\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u3066\u3044\u307e\u3059\u3002");
                        return;
                    }
                    if (itemList.getTableItemList().getItemCount() < 1) {
                        this.posMain.getStatusBar().setText("\u64cd\u4f5c\u3092\u7d99\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002\u5546\u54c1\u4e00\u89a7\u306b\u8a08\u4e0a\u3055\u308c\u3066\u3044\u308b\u5546\u54c1\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                        return;
                    }
                    OposCustomerDisplay customerDisplay = OposController.getInstance().getCustomerDisplay();
                    customerDisplay.clear();
                    if (tabIndex != 0) break;
                    log.debug((Object)"\u8ca9\u58f2\u51e6\u7406\u958b\u59cb");
                    DisplaySales displaySales = new DisplaySales();
                    displaySales.setPosMain(this.posMain);
                    displaySales.displayTotalPrint();
                    DialogCashier dialog = new DialogCashier();
                    dialog.create(this.posMain, Display.getCurrent(), 2);
                    this.setDialog(dialog);
                }
            }
        }
    }

    public synchronized void scan(String barcode) {
        if (StringUtils.isEmpty((String)barcode)) {
            return;
        }
        if (OposController.getInstance().getCashDrawer().isOpen()) {
            PosDrawer posDrawer = new PosDrawer(this.posMain);
            posDrawer.warning();
            return;
        }
        BarcodeScanner barcodeScanner = this.posMain.getPosTabFolder().getPosAbstract()[this.posMain.getPosTabFolder().getTabFolder().getSelectionIndex()].getItemList().getBarcodeScanner();
        barcodeScanner.scan(barcode);
    }

    private boolean authorize() {
        if (PosCommon.authorize()) {
            return true;
        }
        this.posMain.getStatusBar().setText(String.format("\u6307\u5b9a\u3057\u305f\u64cd\u4f5c\u306f\u30ec\u30b8\u756a\u53f7\uff3b%d\uff3d\u3067\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002", 0));
        return false;
    }
}

