/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.device.opos;

import jp.ne.k_tech.kposrcp.device.Activator;
import jp.ne.k_tech.kposrcp.device.opos.OposCashDrawer;
import jp.ne.k_tech.kposrcp.device.opos.OposCustomerDisplay;
import jp.ne.k_tech.kposrcp.device.opos.OposReceiptPrinter;
import jp.ne.k_tech.kposrcp.device.opos.exception.OposException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OposController {
    private static Log log = LogFactory.getLog(OposController.class);
    public static final int RESULT_NORMAL = 0;
    public static final int RESULT_ALERT = 1;
    public static final int RESULT_ERROR = 2;
    private static OposController instance;
    private OposCashDrawer cashDrawer = null;
    private OposCustomerDisplay customerDisplay = null;
    private OposReceiptPrinter receiptPrinter = null;

    static {
        System.loadLibrary("OposBridge");
    }

    public static native String OposCall(String var0, boolean var1);

    private OposController() {
    }

    public static synchronized OposController getInstance() {
        if (instance == null) {
            instance = new OposController();
        }
        return instance;
    }

    public static void execute(String[] requestValues, boolean isWait) {
        String requestValue = "";
        int i = 0;
        while (i < requestValues.length) {
            requestValue = String.valueOf(requestValue) + requestValues[i] + " ";
            ++i;
        }
        log.debug((Object)("OPOS\u8981\u6c42 request:" + requestValue));
        String result = OposController.OposCall(requestValue, isWait);
        log.debug((Object)("OPOS\u7d50\u679c result:" + result));
    }

    public void initialize(boolean useOpos) {
        log.debug((Object)"OposCommander\u521d\u671f\u5316");
        boolean isEmulate = !useOpos ? true : Activator.getDefault().getPreferenceStore().getBoolean("OPOS_ISEMULATE");
        if (this.cashDrawer == null) {
            this.cashDrawer = new OposCashDrawer(isEmulate);
        }
        this.cashDrawer.initialize();
        if (this.customerDisplay == null) {
            this.customerDisplay = new OposCustomerDisplay(isEmulate);
        }
        this.customerDisplay.initialize();
        if (this.receiptPrinter == null) {
            this.receiptPrinter = new OposReceiptPrinter(isEmulate);
        }
        this.receiptPrinter.initialize();
    }

    public void terminate() {
        this.cashDrawer.terminate();
        this.customerDisplay.terminate();
        this.receiptPrinter.terminate();
        log.debug((Object)"OposCommander\u7d42\u4e86");
    }

    public OposCashDrawer getCashDrawer() {
        return this.cashDrawer;
    }

    public OposCustomerDisplay getCustomerDisplay() {
        return this.customerDisplay;
    }

    public OposReceiptPrinter getReceiptPrinter() {
        return this.receiptPrinter;
    }

    public void healthCheck() throws OposException {
        int result = 0;
        StringBuffer message = new StringBuffer();
        this.cashDrawer.sense();
        if (this.cashDrawer.getCondition() != 10) {
            message.append(this.cashDrawer.getMessage());
            result = 2;
        }
        this.customerDisplay.sense();
        if (this.customerDisplay.getCondition() != 10) {
            message.append(this.customerDisplay.getMessage());
            result = 2;
        }
        this.receiptPrinter.sense();
        if (this.receiptPrinter.getCondition() != 10) {
            message.append(this.receiptPrinter.getMessage());
            result = 2;
        }
        if (result != 0) {
            String br = System.getProperty("line.separator");
            message.append("\u5468\u8fba\u6a5f\u5668\u306e\u7570\u5e38\u3092\u691c\u77e5\u3057\u307e\u3057\u305f\u3002");
            message.append(br);
            message.append("\u5468\u8fba\u6a5f\u5668\u3092\u6b63\u3057\u304f\u8a2d\u5b9a\u3057\u3001\u518d\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            throw new OposException(message.toString());
        }
    }
}

