/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.IDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class Translations {
    private static final Logger log = Logger.getLogger(Translations.class);
    private static final IDictionary dictionary = TranslationDictionary.getInstance();
    private static final Map<String, String> backupMap = new HashMap<String, String>();

    private Translations() {
    }

    public static String translate(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        return dictionary.lookup(enValue, jointPoint);
    }

    public static String[] translate(String[] enValues, JointPoint jointPoint) {
        if (enValues == null) {
            return null;
        }
        int i = 0;
        while (i < enValues.length) {
            enValues[i] = Translations.translate(enValues[i], jointPoint);
            ++i;
        }
        return enValues;
    }

    public static Object translate(Object enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        if (enValue instanceof String) {
            return Translations.translate((String)enValue, jointPoint);
        }
        if (enValue instanceof String[]) {
            return Translations.translate((String[])enValue, jointPoint);
        }
        if (enValue instanceof Object[]) {
            return Translations.translate((Object[])enValue, jointPoint);
        }
        return enValue;
    }

    public static Object[] translate(Object[] enValue, JointPoint jointPoint) {
        if (enValue instanceof String[]) {
            return Translations.translate((String[])enValue, jointPoint);
        }
        return enValue;
    }

    public static String translateMenu(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        String[] splitsAccelerator = enValue.split("\t");
        String enMenuText = splitsAccelerator[0];
        if (splitsAccelerator.length == 1) {
            return dictionary.lookup(enMenuText, jointPoint);
        }
        return String.valueOf(dictionary.lookup(enMenuText, jointPoint)) + "\t" + splitsAccelerator[1];
    }

    public static String translateIgnoreMnemonic(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        return dictionary.lookupIgnoreMnemonic(enValue, jointPoint);
    }

    public static String translateBackup(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        String jaValue = dictionary.lookup(enValue, jointPoint);
        backupMap.put(jaValue, enValue);
        return jaValue;
    }

    public static String translateBackupIgnoreMnemonic(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        String jaValue = dictionary.lookupIgnoreMnemonic(enValue, jointPoint);
        backupMap.put(jaValue, enValue);
        return jaValue;
    }

    public static String[] translateBackupIgnoreMnemonic(String[] enValues, JointPoint jointPoint) {
        if (enValues == null) {
            return null;
        }
        int i = 0;
        while (i < enValues.length) {
            enValues[i] = Translations.translateBackupIgnoreMnemonic(enValues[i], jointPoint);
            ++i;
        }
        return enValues;
    }

    public static String restore(String jaValue, JointPoint jointPoint) {
        if (jaValue == null) {
            return null;
        }
        String enValue = backupMap.get(jaValue);
        if (enValue == null) {
            return jaValue;
        }
        return enValue;
    }

    public static String translateSentence(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        if (enValue.contains(" ")) {
            return dictionary.lookup(enValue, jointPoint);
        }
        return enValue;
    }

    public static String translateWithoutJaMnemonic(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        enValue = enValue.replaceFirst("\\(\\&[\\w\\.@]\\)", "");
        return dictionary.lookupIgnoreMnemonic(enValue, jointPoint);
    }

    public static void debug(Object value, JointPoint jointPoint) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug ");
        if (jointPoint != null) {
            sb.append("(");
            sb.append(jointPoint.getClassName());
            sb.append("#");
            sb.append(jointPoint.getMethodName());
            sb.append(") ");
        }
        if (value != null) {
            sb.append(value.getClass().getName());
        }
        sb.append("[");
        sb.append(value);
        sb.append("] -> [");
        sb.append(Translations.translate(value, jointPoint));
        sb.append("]");
        log.info(sb.toString());
    }

    public static void debug(String[] value, JointPoint jointPoint) {
        StringBuilder sb = new StringBuilder();
        sb.append("Translations#debug ");
        if (jointPoint != null) {
            sb.append("(");
            sb.append(jointPoint.getClassName());
            sb.append("#");
            sb.append(jointPoint.getMethodName());
            sb.append(") ");
        }
        if (value != null) {
            sb.append(value.getClass().getName());
        }
        sb.append(Arrays.asList(value));
        sb.append(" -> ");
        sb.append(Arrays.asList(Translations.translate(value, jointPoint)));
        log.info(sb.toString());
    }

    public static void printStackTrace(Object value, JointPoint jointPoint) {
        log.info("Translator#debug " + (value == null ? "" : value.getClass().getName()) + "[" + value + "] -> [" + Translations.translate(value, jointPoint) + "]", new Exception());
    }
}

