/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.controls.creators;

import jp.ne.k_tech.kposrcp.controls.creators.BaseCreator;
import jp.ne.k_tech.kposrcp.listeners.NumberModifyListener;
import jp.ne.k_tech.kposrcp.listeners.NumberVerifyListener;
import jp.ne.k_tech.kposrcp.listeners.SelectedFocusListener;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TextCreator
extends BaseCreator {
    private static final FocusListener focusListener = new SelectedFocusListener();
    private static final VerifyListener verifyListener = new NumberVerifyListener();
    private static final ModifyListener modifyListener = new NumberModifyListener();
    private Composite parent;
    private int style;
    private String bgcolorKey;
    private String fontKey;
    private int fontStyle;

    public TextCreator(Composite parent, int style) {
        this.parent = parent;
        this.style = style;
    }

    public TextCreator(Composite parent, int style, String bgcolorKey) {
        this.parent = parent;
        this.style = style;
        this.bgcolorKey = bgcolorKey;
    }

    public TextCreator(Composite parent, int style, String bgcolorKey, String fontKey, int fontStyle) {
        this.parent = parent;
        this.style = style;
        this.bgcolorKey = bgcolorKey;
        this.fontKey = fontKey;
        this.fontStyle = fontStyle;
    }

    public Text create(int limit) {
        Text text = new Text(this.parent, this.style);
        if (StringUtils.isNotEmpty((String)this.bgcolorKey)) {
            text.setBackground(JFaceResources.getColorRegistry().get(this.bgcolorKey));
        }
        if (StringUtils.isNotEmpty((String)this.fontKey)) {
            text.setFont(this.getFont(this.fontKey, this.fontStyle));
        }
        text.setTextLimit(limit);
        return text;
    }

    public Text create4Num(int limit) {
        Text text = this.create(limit);
        text.addFocusListener(focusListener);
        text.addVerifyListener(verifyListener);
        text.addModifyListener(modifyListener);
        return text;
    }
}

