/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.controls;

import jp.ne.k_tech.kposrcp.Activator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IStatusLineManager;

public class StatusLineLabels {
    private static Log log = LogFactory.getLog(StatusLineLabels.class);
    private IStatusLineManager statusLine;
    private static StatusLineLabels instance;

    public static synchronized void init(IStatusLineManager statusLine) {
        if (instance == null) {
            instance = new StatusLineLabels(statusLine);
        }
    }

    public static StatusLineLabels getInstance() {
        return instance;
    }

    private StatusLineLabels(IStatusLineManager statusLine) {
        this.statusLine = statusLine;
    }

    public IStatusLineManager getStatusLine() {
        return this.statusLine;
    }

    public void setStatusError(String message) {
        if (this.statusLine != null) {
            log.debug((Object)("status message [error] : " + message));
            this.statusLine.setErrorMessage(Activator.getDefault().getImageRegistry().get("iconstatuserr"), message);
        }
    }

    public void setStatusWarn(String message) {
        if (this.statusLine != null) {
            log.debug((Object)("status message [warn] : " + message));
            this.statusLine.setMessage(Activator.getDefault().getImageRegistry().get("iconstatuswarn"), message);
        }
    }

    public void setStatusInfo(String message) {
        if (this.statusLine != null) {
            log.debug((Object)("status message [info] : " + message));
            this.statusLine.setMessage(Activator.getDefault().getImageRegistry().get("iconstatusinfo"), message);
        }
    }

    public void clearStatusError() {
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(null);
        }
    }

    public void clearStatus() {
        this.statusLine.setMessage(null);
    }
}

