/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp.commons.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;

public class NumberUtils {
    private static final NumberFormat NUMBER_FORMAT_COMMMA = new DecimalFormat("#,###");
    private static final NumberFormat CURRENCY_FORMAT = new DecimalFormat("\\#,###");
    private static final NumberFormat NUMBER_FORMAT_000 = new DecimalFormat("000");
    private static final NumberFormat NUMBER_FORMAT_0000 = new DecimalFormat("0000");
    private static final NumberFormat NUMBER_FORMAT_00000000 = new DecimalFormat("00000000");

    public static String currencyFormat(long number) {
        return CURRENCY_FORMAT.format(number);
    }

    public static String commaFormat(long number) {
        return NUMBER_FORMAT_COMMMA.format(number);
    }

    public static String commaFormat(BigDecimal number) {
        if (number == null) {
            return "";
        }
        return NUMBER_FORMAT_COMMMA.format(number);
    }

    public static String commaFormat(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        return NUMBER_FORMAT_COMMMA.format(org.apache.commons.lang.math.NumberUtils.toLong((String)number));
    }

    public static String format_000(int number) {
        String result = NUMBER_FORMAT_000.format(number);
        if (result.length() > 3) {
            result = result.substring(result.length() - 3, result.length());
        }
        return result;
    }

    public static String format_0000(int number) {
        return NUMBER_FORMAT_0000.format(number);
    }

    public static String format_00000000(long number) {
        String result = NUMBER_FORMAT_00000000.format(number);
        if (result.length() > 8) {
            result = result.substring(result.length() - 8, result.length());
        }
        return result;
    }

    public static long currencyParse(String value) {
        return NumberUtils.commaParse(StringUtils.defaultIfEmpty((String)value, (String)"0").replace("\\", ""));
    }

    public static long commaParse(String value) {
        try {
            return NUMBER_FORMAT_COMMMA.parse(StringUtils.defaultIfEmpty((String)value, (String)"0")).longValue();
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }
}

