/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.k_tech.kposrcp;

import jp.ne.k_tech.kposrcp.Activator;
import jp.ne.k_tech.kposrcp.ApplicationWorkbenchWindowAdvisor;
import jp.ne.k_tech.kposrcp.Constants;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static Log log = LogFactory.getLog(ApplicationWorkbenchAdvisor.class);
    private static final String PERSPECTIVE_ID = "jp.ne.k_tech.kposrcp.perspective";
    private IWorkbenchWindowConfigurer configurer;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        this.configurer = configurer;
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PERSPECTIVE_ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        log.debug((Object)"initialize() was called.");
        super.initialize(configurer);
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        fontRegistry.put("mspgo9n", new Font((Device)Display.getCurrent(), "MS P\u30b4\u30b7\u30c3\u30af", 9, 0).getFontData());
        fontRegistry.put("mspgo12n", new Font((Device)Display.getCurrent(), "MS P\u30b4\u30b7\u30c3\u30af", 12, 0).getFontData());
        fontRegistry.put("mspgo20n", new Font((Device)Display.getCurrent(), "MS P\u30b4\u30b7\u30c3\u30af", 20, 0).getFontData());
        fontRegistry.put("mspgo32n", new Font((Device)Display.getCurrent(), "MS P\u30b4\u30b7\u30c3\u30af", 32, 0).getFontData());
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        int i = 0;
        while (i < Constants.COLORS.length) {
            colorRegistry.put(Constants.COLORS[i][0], new RGB(NumberUtils.toInt((String)Constants.COLORS[i][1]), NumberUtils.toInt((String)Constants.COLORS[i][2]), NumberUtils.toInt((String)Constants.COLORS[i][3])));
            ++i;
        }
    }

    public boolean preShutdown() {
        log.debug((Object)"preShutdown()");
        if (this.getWorkbench().getWorkbenchWindowCount() > 1) {
            return super.preShutdown();
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW");
        if (promptOnExit) {
            String productName = null;
            IProduct product = Platform.getProduct();
            if (product != null) {
                productName = product.getName();
            }
            String message = StringUtils.isEmpty(productName) ? "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u304b ?" : NLS.bind((String)"\u300e{0}\u300f\u3092\u7d42\u4e86\u3057\u307e\u3059\u304b ?", (Object)productName);
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.configurer.getWindow().getShell(), (String)"\u7d42\u4e86\u306e\u78ba\u8a8d", (String)message, (String)"\u5e38\u306b\u30d7\u30ed\u30f3\u30d7\u30c8\u306a\u3057\u3067\u7d42\u4e86(&A)", (boolean)false, null, null);
            if (dialog.getReturnCode() != 0) {
                return false;
            }
            if (dialog.getToggleState()) {
                store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", false);
                Activator.getDefault().savePluginPreferences();
            }
        }
        return super.preShutdown();
    }

    private IWorkbench getWorkbench() {
        return this.getWorkbenchConfigurer().getWorkbench();
    }
}

