/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.DynamicProxyManager;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.util.Trace;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DeployProxySelector
extends ProxySelector {
    public static void reset() {
        DynamicProxyManager.reset();
        ProxySelector.setDefault(new DeployProxySelector());
    }

    public List select(URI uRI) {
        Object object;
        if (uRI == null) {
            throw new IllegalArgumentException();
        }
        Object object2 = uRI.getHost();
        int n = uRI.getPort();
        if (object2 == null && (object = uRI.getAuthority()) != null) {
            int n2 = ((String)object).indexOf(64);
            if (n2 >= 0) {
                object = ((String)object).substring(n2 + 1);
            }
            if ((n2 = ((String)object).lastIndexOf(58)) >= 0) {
                try {
                    n = Integer.parseInt(((String)object).substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                object = ((String)object).substring(0, n2);
            }
            object2 = object;
        }
        object = new ArrayList();
        Proxy proxy = Proxy.NO_PROXY;
        try {
            String string = uRI.getScheme();
            boolean bl = string.equalsIgnoreCase("socket") || string.equalsIgnoreCase("serversocket");
            URL uRL = null;
            uRL = bl ? (n == -1 ? new URL("http://" + (String)object2 + "/") : new URL("http://" + (String)object2 + ":" + n + "/")) : uRI.toURL();
            List list = DynamicProxyManager.getProxyInfo(uRL);
            ListIterator listIterator = list.listIterator();
            ProxyInfo proxyInfo = null;
            while (listIterator.hasNext()) {
                proxyInfo = (ProxyInfo)listIterator.next();
                if (proxyInfo.isProxyUsed()) {
                    Proxy proxy2 = this.getProxy(proxyInfo, bl);
                    ((ArrayList)object).add(proxy2);
                    continue;
                }
                ((ArrayList)object).add(Proxy.NO_PROXY);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Trace.msgNetPrintln("net.proxy.connect", new Object[]{uRI, ((ArrayList)object).get(0)});
        return object;
    }

    private Proxy getProxy(final ProxyInfo proxyInfo, final boolean bl) {
        Proxy proxy = null;
        try {
            proxy = (Proxy)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (bl) {
                        if (proxyInfo.isSocksUsed()) {
                            return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyInfo.getSocksProxy(), proxyInfo.getSocksPort()));
                        }
                        return Proxy.NO_PROXY;
                    }
                    if (proxyInfo.getProxy() == null && proxyInfo.isSocksUsed()) {
                        return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyInfo.getSocksProxy(), proxyInfo.getSocksPort()));
                    }
                    return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyInfo.getProxy(), proxyInfo.getPort()));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return proxy;
    }

    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        if (uRI == null || socketAddress == null || iOException == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        Trace.msgNetPrintln("net.proxy.connectionFailure", new Object[]{uRI.toString() + ", " + socketAddress.toString() + iOException.toString()});
        try {
            DynamicProxyManager.removeProxyFromCache(uRI.toURL(), socketAddress.toString());
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
    }
}

