#!/bin/sh -efu
# $Id: portcvsweb.sh,v 1.3 2006/10/07 10:59:58 securedog Exp $

usage() {
	echo "usage: ${0##*/} pkgname"
	echo "       ${0##*/} origin"
	echo "       ${0##*/} /usr/{src,ports,pkgsrc}/path"
	exit ${1:-0}
}

set_variables() {
	: ${BROWSER="w3m:lynx:links:firefox:mozilla:netscape"}
	: ${OPSYS="FreeBSD"}

	PORTSDIR="/usr/ports"
	PKGSRCDIR="/usr/pkgsrc"
	SRCDIR="/usr/src"

	FreeBSD_URI_BASE="http://www.FreeBSD.org/cgi/cvsweb.cgi/"
	NetBSD_URI_BASE="http://cvsweb.netbsd.org/bsdweb.cgi/"
	OpenBSD_URI_BASE="http://www.openbsd.org/cgi-bin/cvsweb/"

	eval CVSWEB_URI=\${${OPSYS}_URI_BASE}
	SRCDIR_URI=${CVSWEB_URI%/}/src/
	PORTSDIR_URI=${CVSWEB_URI%/}/ports/
	PKGSRCDIR_URI=${NetBSD_URI_BASE%/}/pkgsrc/
}

set_www_user_agent(){
	local IFS prog

	IFS=':'
	for prog in ${BROWSER}; do
		if prog=$(which "${prog}"); then
			WWW_USER_AGENT=${prog}
			return 0
		fi
	done

	warn "No browser is available - please define BROWSER."
	exit 1
}

set_target() {
	local path realpath i dir

	path=${1-}
	realpath=

	if [ -z "${path}" ]; then
		case ${PWD}/ in
		${SRCDIR}/*|${PORTSDIR}/*|${PKGSRCDIR}/*)
			realpath=${PWD} ;;
		*)	realpath=/ ;;
		esac
	elif [ -e "${path}" ]; then
		realpath=$(realpath "${path}")
	else
		set -- $(ports_glob "${path}")

		if [ -n "${1-}" ]; then
			if [ "${_SYSTEM}" = pkgsrc ]; then
				realpath=${PKGSRCDIR}/$1
			else
				realpath=${PORTSDIR}/$1
			fi
		else
			warn "Port directory not found: ${path}"
			exit 1
		fi
	fi

	[ -d "${realpath}" ] && realpath="${realpath}/"

	for i in SRCDIR PORTSDIR PKGSRCDIR; do
		eval dir=\$$i
		case ${realpath} in
		${dir}/*)
			eval TARGET=\${${i}_URI}\${realpath#${dir}/}
			return 0 ;;
		esac
	done

	case ${realpath} in
	//)	TARGET=${CVSWEB_URI} ;;
	*)	warn "File not found: ${path}"
		exit 1 ;;
	esac
}

main() {
	[ "${1-}" = "-h" ] && usage

	init_variables
	set_variables
	set_www_user_agent
	set_target ${1+"$1"}

	exec ${WWW_USER_AGENT} ${TARGET}
}

. /usr/local/bin/portutil
main ${1+"$@"}
