#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Temporary directory and signal trapping -
# Copyright (C) 2013-2016 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Variables =============
TMPDIR=/tmp	# Temporary directory

# ============= Default additional operation in a trap process =============
temp_terminate_process () { :; }

# ============= Warn when the temporary database is obsolete =============
temp_warn_obsolete_temp_db ()
{
	[ "x${DATABASE_IS_OBSOLETE}" = xyes ] || return 0
	message_echo "WARNING: The Ports tree was updated after construction of the temporary database for ${APPNAME}."
	message_echo "You should consider executing "
	message_echo "        ${APPNAME} reset"
	message_echo "to reset the temporary database unless you have special purposes."
}

# ============= Creation of temporary work directories =============
temp_trap_init ()
{
	trap 'errno=$?; temp_warn_obsolete_temp_db >&2; temp_warn_obsolete_temp_db () { :; }; temp_terminate_process >&2; temp_terminate_process () { :; }; rm -rf "${TMPDIR}" 2> /dev/null; [ -n "${DBDIR}" -a x`cat "${DBDIR}/.lock" 2> /dev/null` = x$$ ] && rm -f "${DBDIR}/.lock"; [ $errno -gt 0 -a $errno -ne 130 ] && message_echo "(Error exit by $errno)" >&2; exit $errno' 0 1 2 3 9 15 17 18
	{ until TMPDIR=`mktemp -dq /tmp/"${APPNAME}".XXXXXXXX` ; do : ; done ; }
	chgrp "`id -gn`" "${TMPDIR}"
}

# ============= Set the signal trap to be friendly for invoking a new version =============
temp_trap_for_invoking_new_version ()
{
	[ x`cat "${DBDIR}/.lock" 2> /dev/null` = x$$ ] && rm -f "${DBDIR}/.lock"
	trap 'errno=$?; rm -rf "${TMPDIR}" 2> /dev/null; [ $errno -gt 0 -a $errno -ne 130 ] && echo "(Error exit by $errno)" >&2; exit $errno' 0 1 2 3 9 15 17 18
}

# ============= Set the message telling the current stage =============
temp_set_msg_current_stage ()
{
	echo "$*" > ${TMPDIR}/TEMP::MSG_CURRENT_STAGE
}

# ============= Get the message telling the current stage =============
temp_get_msg_current_stage ()
{
	cat "${TMPDIR}/TEMP::MSG_CURRENT_STAGE" 2> /dev/null || :
}
