#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - Parsing of configuration files -
# Copyright (C) 2013-2016 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Set up environment variables =============
conf_setup_ports_envs ()
{
	local tmp_work
	tmp_work=${TMPDIR}/conf_setup_ports_envs:work
	rm -rf "$tmp_work"
	mkdir "$tmp_work"
	PORTSDIR=${PORTSDIR:-`[ -e /etc/make.conf ] && make -C "$tmp_work" -f /etc/make.conf -V PORTSDIR 2> /dev/null`} || :
	PORTSDIR=${PORTSDIR:-/usr/ports}
	pkgsys_chk_ports_tree_implementation
	PORTS_MOVED_DB=${PORTSDIR}/MOVED
	PORTS_INDEX_DB=${PORTSDIR}/INDEX-`uname -r | cut -d . -f 1`
	if [ ! -e "${PORTS_INDEX_DB}" ]
	then
		message_echo "INFO: The ports index for the current OS version is not found, so fetching it now."
		if ! make -C "${PORTSDIR}" fetchindex || [ ! -e "${PORTS_INDEX_DB}" ]
		then
			message_echo "WARNING: Failed to fetch the ports index, so trying to build it locally." >&2
			make -C "${PORTSDIR}" index
		fi
	fi
}

# ============= Set up environment variables =============
conf_setup_packages_envs ()
{
	local var
	for var in LOCALBASE PORT_DBDIR LINUXBASE DISTDIR PACKAGES PKGREPOSITORYSUBDIR PKGREPOSITORY
	do
		val=`pkgsys_sysvar $var`
		eval $var=\$val
	done
	PKGREPOSITORY=${PKG_PATH:-${PKGREPOSITORY}}
	PACKAGECHECKSUMROOTS=${PACKAGECHECKSUMROOTS:-'ftp://ftp.FreeBSD.org/|'\
'ftp://ftp1.FreeBSD.org/|ftp://ftp2.FreeBSD.org/|ftp://ftp3.FreeBSD.org/|'\
'ftp://ftp4.FreeBSD.org/|ftp://ftp5.FreeBSD.org/|ftp://ftp6.FreeBSD.org/|'\
'ftp://ftp7.FreeBSD.org/|ftp://ftp8.FreeBSD.org/|ftp://ftp9.FreeBSD.org/|'\
'ftp://ftp10.FreeBSD.org/|ftp://ftp11.FreeBSD.org/|ftp://ftp12.FreeBSD.org/|'\
'ftp://ftp13.FreeBSD.org/|ftp://ftp14.FreeBSD.org/'}
	PACKAGECHECKSUMDIR=${PACKAGEDIR:-'pub/FreeBSD/ports/%s/packages-%s/All/'}
	PACKAGEROOTS=${PACKAGEROOTS:-${PACKAGECHECKSUMROOTS}}
	PACKAGEDIR=${PACKAGEDIR:-${PACKAGECHECKSUMDIR}}
}

# ============= Parse configuration variables given for each port glob =============
conf_parse_vars_for_each_port_glob ()
{
	local section
	section=$1
	misc_get_all_vardefs | grep -e "^_CONF_${section}_" | cut -d = -f 1 | while read var
	do
		eval glob_pattern=\${$var}
		pkgsys_eval_ports_glob "$glob_pattern"
	done > ${DBDIR}/conf/${section}:PORTS.parsed
}

# ============= Parse configuration variables given for each port glob with a bound value =============
conf_parse_vars_for_each_port_glob_with_bound_val ()
{
	local section tag_target tag_val
	section=$1
	tag_target=$2
	tag_val=$3
	misc_get_all_vardefs | grep -e "^_CONF_${section}_${tag_target}_" | cut -d = -f 1 | while read var
	do
		eval glob_pattern=\${$var}
		eval val=\$\{`echo "$var" | sed "s/^_CONF_${section}_${tag_target}_/_CONF_${section}_${tag_val}_/"`\}
		pkgsys_eval_ports_glob "$glob_pattern" | while read origin
		do
			path=${DBDIR}/conf/each_port/$origin
			[ -d "$path" ] || mkdir -p "$path"
			echo "$val" > $path/${section}.conf
		done
	done
}

# ============= Parse pkgtools.conf(5) =============
conf_parse_pkgtools_conf ()
{
	local PORTUPGRADE tmp_script_crop portupgrade_pkg
	tmp_script_crop=${TMPDIR}/conf_parse_pkgtools_conf:crop
	PORTUPGRADE=`which portupgrade | head -n 1 || :`
	if [ ! -f "$PORTUPGRADE" ]
	then
		message_echo "WARNING: portupgrade is not found, pkgtools.conf is ignored" >&2
		return
	fi
	portupgrade_pkg=`pkg_info_qO ports-mgmt/portupgrade`
	[ -n "$portupgrade_pkg" ] || portupgrade_pkg=`pkg_info_qO ports-mgmt/portupgrade-devel`
	[ `expr "$portupgrade_pkg" : '^portupgrade-devel-'` -eq 0 ] \
		|| message_echo "WARNING: Combination with portupgrade-devel-* has not tested." >&2
	sed -n '/^def init_global$/,/^end$/p' "$PORTUPGRADE" > $tmp_script_crop
	[ `wc -l < $tmp_script_crop` -gt 0 ] || \
		{ message_echo "ERROR: The current installed version of portupgrade is unsupported." >&2; }
	ruby > ${DBDIR}/conf/pkgtools.parsed << eof
MYNAME = 'portupgrade'
require 'pkgtools'
`cat "$tmp_script_crop"`
init_global
init_pkgtools_global
load_config
alt_moved = config_value(:ALT_MOVED)
hold_pkgs = config_value(:HOLD_PKGS)
ignore_moved = config_value(:IGNORE_MOVED)
alt_pkgdep = config_value(:ALT_PKGDEP)
make_args = config_value(:MAKE_ARGS)
make_env = config_value(:MAKE_ENV)
beforebuild = config_value(:BEFOREBUILD)
beforedeinstall = config_value(:BEFOREDEINSTALL)
afterinstall = config_value(:AFTERINSTALL)

keys = ['LOCALBASE', 'LINUXBASE', 'PORT_DBDIR', 'PORTSDIR', 'DISTDIR', 'PACKAGES', 'PKG_PATH', 'PKGREPOSITORY']
keys.each{|key|
        if ENV.has_key?(key) then
                printf("ENV_%s=%s\n", key, ENV[key])
        end
}

i = 0
alt_moved.each do |val|
        printf("ALT_MOVED_pkgtoolsconf_%d_='%s'\n", i, val)
        i = i + 1
end

i = 0
hold_pkgs.each do |val|
        printf("HOLD_pkgtoolsconf_%d_='%s'\n", i, val)
        i = i + 1
end
ignore_moved.each do |val|
        printf("HOLD_pkgtoolsconf_%d_='%s'\n", i, val)
        i = i + 1
end

i = 0
alt_pkgdep.each do |pat, alt|
        printf("REPLACE_FROM_pkgtoolsconf_%d_='%s'\n", i, pat)
        printf("REPLACE_TO_pkgtoolsconf_%d_='%s'\n", i, alt)
        i = i + 1
end

i = 0
make_args.each do |target, definition|
        printf("MARG_TARGET_pkgtoolsconf_%d_='%s'\n", i, target)
        printf("MARG_DEF_pkgtoolsconf_%d_='%s'\n", i, definition)
        i = i + 1
end

i = 0
make_env.each do |target, definition|
        printf("MENV_TARGET_pkgtoolsconf_%d_='%s'\n", i, target)
        printf("MENV_DEF_pkgtoolsconf_%d_='%s'\n", i, definition)
        i = i + 1
end

i = 0
beforebuild.each do |target, command|
        printf("BEFOREBUILD_TARGET_pkgtoolsconf_%d_='%s'\n", i, target)
        printf("BEFOREBUILD_COMMAND_pkgtoolsconf_%d_='%s'\n", i, command)
        i = i + 1
end

i = 0
beforedeinstall.each do |target, command|
        printf("BEFOREDEINSTALL_TARGET_pkgtoolsconf_%d_='%s'\n", i, target)
        printf("BEFOREDEINSTALL_COMMAND_pkgtoolsconf_%d_='%s'\n", i, command)
        i = i + 1
end

i = 0
afterinstall.each do |target, command|
        printf("AFTERINSTALL_TARGET_pkgtoolsconf_%d_='%s'\n", i, target)
        printf("AFTERINSTALL_COMMAND_pkgtoolsconf_%d_='%s'\n", i, command)
        i = i + 1
end
eof
}

# ============= Get complete configuration variable definitions by importing pkgtools.conf(5) if available =============
conf_get_complete_var_defs ()
{
	case `options_get_effective_opt_load_pkgtoolsconf` in
	default)
		conf_parse_pkgtools_conf
		cat "${DBDIR}/conf/pkgtools.parsed" "${CONFFILE}" 2> /dev/null || :
		;;
	override)
		conf_parse_pkgtools_conf
		cat "${CONFFILE}" "${DBDIR}/conf/pkgtools.parsed" 2> /dev/null || :
		;;
	no)
		cat "${CONFFILE}" 2> /dev/null || :
		;;
	esac
}

# ============= Manipulate available variable definitions =============
conf_manipulate_available_var_defs ()
{
	(set -e
		tmpfile_unsetvars=${TMPDIR}/conf_manipulate_available_var_defs::unsetvars.sh
		_CONFVARS='ENV ALT_MOVED HOLD TABOO NOPKG REPLACE_FROM REPLACE_TO MARG_TARGET MARG_DEF MENV_TARGET MENV_DEF BEFOREBUILD BEFOREDEINSTALL AFTERINSTALL'
		for item in ${_CONFVARS}
		do
			misc_get_all_vardefs | grep -e "^${item}_" | cut -d = -f 1 | sed 's/^/unset /'
		done > $tmpfile_unsetvars
		. "$tmpfile_unsetvars"
		. "${DBDIR}/conf/complete_setup.sh"
		for item in ${_CONFVARS}
		do
			misc_get_all_vardefs | grep -e "^${item}_" | sed 's/^/_CONF_/'
		done | sort -u > ${DBDIR}/conf/manipulated_defs.sh
	) || { message_echo "ERROR: Failed to manipulate available variable definitions from the configuration file." >&2; exit 1; }
}

# ============= Build an effective MOVED database =============
conf_build_effective_MOVED ()
{
	grep -v -e '^[[:space:]]*#' -e '^[[:space:]]*$' "${PORTS_MOVED_DB}" > ${DBDIR}/conf/MOVED.parsed
	misc_get_all_vardefs | grep -e '^_CONF_ALT_MOVED_' | cut -d = -f 1 | while read var
	do
		eval movedsb_path=\${$var}
		cat "$movedsb_path"
	done | grep -v -e '^[[:space:]]*#' -e '^[[:space:]]*$' > ${DBDIR}/conf/MOVED_ALT.parsed || :
	cat "${DBDIR}/conf/MOVED_ALT.parsed" >> ${DBDIR}/conf/MOVED.parsed
}

# ============= Set up effective environment values =============
conf_setup_effective_env ()
{
	(
		for key in LOCALBASE LINUXBASE PORT_DBDIR PORTSDIR DISTDIR PACKAGES PKG_PATH PKGREPOSITORY PACKAGECHECKSUMROOTS PACKAGECHECKSUMDIR PACKAGEROOTS PACKAGEDIR
		do
			eval $key=\$\{_CONF_ENV_$key:-\$\{$key\}\}
		done
		misc_get_all_vardefs | grep -e '^LOCALBASE=' -e '^LINUXBASE=' -e '^PORT_DBDIR=' -e '^PORTSDIR=' -e '^DISTDIR=' -e 'PACKAGES=' -e '^PKG_PATH=' -e '^PKGREPOSITORY=' -e '^PACKAGECHECKSUMROOTS='  -e '^PACKAGECHECKSUMDIR=' -e '^PACKAGEROOTS=' -e '^PACKAGEDIR='
	)
	echo '[ -n "$PKG_PATH" ] && PKGREPOSITORY=$PKG_PATH'
	echo 'conf_setup_ports_envs'
	[ "${DBDIR}/conf/MOVED.parsed" -nt "${PORTS_MOVED_DB}" ] || return 0
	echo PORTS_MOVED_DB=${DBDIR}/conf/MOVED.parsed
}

# ============= Build replacement patterns from REPLACE variables =============
conf_build_replacement_patterns_from_REPLACE ()
{
	local tmp_evaluated_origins
	tmp_matching_origins=${TMPDIR}/conf_build_replacement_patterns_from_REPLACE:origins
	cp /dev/null "${DBDIR}/conf/REPLACE.grep_from_pattern"
	cp /dev/null "${DBDIR}/conf/REPLACE.sed_pattern"
	cp /dev/null "${DBDIR}/conf/REPLACE.csv"
	misc_get_all_vardefs | grep -e '^_CONF_REPLACE_FROM_' | cut -d = -f 1 | while read var
	do
		eval glob_pattern=\$\{$var\}
		eval to=\$\{`echo "$var" | sed 's/^_CONF_REPLACE_FROM_/_CONF_REPLACE_TO_/'`\}
		pkgsys_eval_ports_glob_even_if_nonexistent "$glob_pattern" > $tmp_matching_origins || :
		if [ `wc -l < $tmp_matching_origins` -eq 0 ]
		then
			message_echo "WARNING: Original package to be replaced [$glob_pattern] is obsolete." >&2
			message_echo "If still required, use a pattern for port origins instead." >&2
			continue
		fi
		str_escape_regexp_filter < $tmp_matching_origins \
			| sed 's|^|^|; s|$|$|' >> ${DBDIR}/conf/REPLACE.grep_from_pattern
		if [ -z "$to" -o "$to" = delete ]
		then
			to=
		else
			[ -d "${PORTSDIR}/$to" ] || message_echo "WARNING: replacement port [$to] is obsolete." >&2
		fi
		str_escape_regexp_filter < $tmp_matching_origins \
			| sed -E "s|^|s:^|; s/$/$:`str_escape_replaceval \"$to\"`:/" \
			>> ${DBDIR}/conf/REPLACE.sed_pattern
		while read from
		do
			printf '%s\t%s\n' "$from" "$to"
		done < $tmp_matching_origins >> ${DBDIR}/conf/REPLACE.csv
	done
}

