;Japanese Support Patch for POPFile
;Written by Junya Ishihara(jishiha@users.sourceforge.net)

!define MUI_PRODUCT "POPFile {ꉻpb`" ;Define your own software name here
!define MUI_VERSION "0.21.2.1" ;Define your own software version here

!include "MUI.nsh"

;--------------------------------
;Configuration

  ;General
  OutFile "popfile_jpn.exe"

  ;Folder selection page
  InstallDir $PROGRAMFILES\POPFile

  ;Remember install folder
  ;InstallDirRegKey HKLM SOFTWARE\POPFile "InstallLocation"

;--------------------------------
;Modern UI Configuration

  !define MUI_LICENSEPAGE
  !define MUI_COMPONENTSPAGE
  !define MUI_DIRECTORYPAGE
  
  !define MUI_ABORTWARNING
  
  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "Japanese"
  
;--------------------------------
;Language Strings

  ;Description
  LangString DESC_SecCopyUI ${LANG_JAPANESE} "POPFile {ꉻpb` CXg[܂B"

;--------------------------------
;Data
  
  LicenseData "license"

;--------------------------------
;Installer Sections

Section "popfile_jpn.exe" SecCopyUI
  ; Check if POPFile has already installed or not
  IfFileExists "$INSTDIR" POPFileInstalled 0
    MessageBox MB_OK "$INSTDIR ɂ POPFile CXg[Ă܂BfāA܂ POPFile CXg[ĉB"
    Quit
  POPFileInstalled:

  ; Check POPFile version
  IfFileExists "$INSTDIR\v0.21.2.change" PatchInstall 0
    MessageBox MB_YESNO "$INSTDIR ɂ POPFile 0.21.2 CXg[ĂȂ\܂Bv0.21.2.change t@C܂Błpb`̃CXg[𑱂܂H" IDYES PatchInstall
  Quit

  PatchInstall:
  SetOutPath "$INSTDIR"
  WriteUninstaller "popfile_jpn-uninst.exe"

  ; Backup files that are to be updated
  Rename $INSTDIR\Classifier\Bayes.pm $INSTDIR\Classifier\Bayes.pm_original
  Rename $INSTDIR\Classifier\MailParse.pm $INSTDIR\Classifier\MailParse.pm_original
  Rename $INSTDIR\UI\HTML.pm $INSTDIR\UI\HTML.pm_original
  Rename $INSTDIR\Proxy\POP3.pm $INSTDIR\Proxy\POP3.pm_original
  Rename $INSTDIR\Proxy\Proxy.pm $INSTDIR\Proxy\Proxy.pm_original

  ; Copy(Overwrite) directories
  File /r POPFile\Classifier
  File /r POPFile\UI
  File /r POPFile\Proxy

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\popfile_jpn "Install_Dir" "$INSTDIR"

  ; Write the registry information related to uninstall
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn" "DisplayName" '"POPFile {ꉻpb`"'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn" "UninstallString" '"$INSTDIR\popfile_jpn-uninst.exe"'

SectionEnd

;Display the Finish header
;Insert this macro after the sections if you are not using a finish page
!insertmacro MUI_SECTIONS_FINISHHEADER

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END
 
;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ; remove registry keys
  DeleteRegKey HKLM SOFTWARE\popfile_jpn
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\popfile_jpn"

  ; Delete files
  Delete "$INSTDIR\Classifier\Bayes.pm"
  Delete "$INSTDIR\Classifier\MailParse.pm"
  Delete "$INSTDIR\UI\HTML.pm"
  Delete "$INSTDIR\Proxy\POP3.pm"
  Delete "$INSTDIR\Proxy\Proxy.pm"

  ; Resume backup files
  Rename $INSTDIR\Classifier\Bayes.pm_original $INSTDIR\Classifier\Bayes.pm
  Rename $INSTDIR\Classifier\MailParse.pm_original $INSTDIR\Classifier\MailParse.pm
  Rename $INSTDIR\UI\HTML.pm_original $INSTDIR\UI\HTML.pm
  Rename $INSTDIR\Proxy\POP3.pm_original $INSTDIR\Proxy\POP3.pm
  Rename $INSTDIR\Proxy\Proxy.pm_original $INSTDIR\Proxy\Proxy.pm

  ;Display the Finish header
  !insertmacro MUI_UNFINISHHEADER

SectionEnd