/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.mmj;

import de.humatic.mmj.CoreMidiDevice;
import de.humatic.mmj.MidiSystem;

public class MidiOutput {
    private int INDEX;
    private long ID;
    private String NAME;

    MidiOutput(long p, int index) {
        this.INDEX = index;
        this.ID = p;
        this.NAME = p > 0L ? MidiSystem.getOutputs()[this.INDEX] : MidiSystem.getVirtualSourceName();
    }

    public void close() {
        try {
            MidiSystem.outputClosed(this.INDEX);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendMidi(byte[] data) {
        if (data.length > 1) {
            this.nativeSendMidi(this.ID, data, 0L);
        } else {
            this.nativeSendMidi(this.ID, new byte[]{data[0], -2}, 0L);
        }
    }

    public void sendMidi(byte[] data, long time) {
        long l = time = time < 0L ? 0L : time;
        if (data.length > 1) {
            this.nativeSendMidi(this.ID, data, time);
        } else {
            this.nativeSendMidi(this.ID, new byte[]{data[0], -2}, time);
        }
    }

    public String getName() {
        return this.NAME;
    }

    public CoreMidiDevice getDeviceInfo() {
        String info = MidiSystem.nativeGetDeviceInfo(1, this.INDEX);
        if (info.equalsIgnoreCase("virtual")) {
            return null;
        }
        CoreMidiDevice[] devices = MidiSystem.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!info.split(";")[0].split("=")[1].equalsIgnoreCase(devices[i].getName())) continue;
            return devices[i];
        }
        return null;
    }

    public String toString() {
        return this.getName() + ", index: " + this.INDEX;
    }

    private native void nativeSendMidi(long var1, byte[] var3, long var4);
}

