/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.mmj;

public class CoreMidiDevice {
    private String name = "unknown";
    private String model = "unknown";
    private String manufacturer = "unknown";
    private String ID = "unknown";
    private int devIndex;
    private int numEntities;
    private CoreMidiDeviceEntity[] entities;

    CoreMidiDevice(String infoString) {
        String[] info = infoString.split(";");
        try {
            this.name = info[1].split("=")[1];
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.manufacturer = info[2].split("=")[1];
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.model = info[3].split("=")[1];
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ID = info[4].split("=")[1];
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.numEntities = new Integer(info[5].split("=")[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.devIndex = new Integer(info[0].split("=")[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entities = new CoreMidiDeviceEntity[this.numEntities];
    }

    void addEntity(int index, String entityName, int ii, String inpName, int oi, String outpName) {
        try {
            this.entities[index] = new CoreMidiDeviceEntity(this, entityName, ii, inpName, oi, outpName);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Device, index: " + this.devIndex + "\n");
        sb.append("Name: " + this.name + "\n");
        sb.append("Manufacturer: " + this.manufacturer + "\n");
        for (int i = 0; i < this.numEntities; ++i) {
            sb.append("Entity, name: " + this.entities[i].getName() + ", inputIndex: " + this.entities[i].getInputIndex() + ", outputIndex: " + this.entities[i].getOutputIndex() + "\n");
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getModel() {
        return this.model;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getID() {
        return this.ID;
    }

    public int getNumberOfEntities() {
        return this.numEntities;
    }

    public CoreMidiDeviceEntity getEntity(int index) {
        return this.entities[index];
    }

    public String getEntityName(int entityIndex) {
        return this.entities[entityIndex].getName();
    }

    public int getInputIndex(int entityIndex) {
        return this.entities[entityIndex].getInputIndex();
    }

    public int getOutputIndex(int entityIndex) {
        return this.entities[entityIndex].getOutputIndex();
    }

    public class CoreMidiDeviceEntity {
        private CoreMidiDevice cmd;
        private String name;
        private String inputName;
        private String outputName;
        private int myInIndex;
        private int myOutIndex;

        CoreMidiDeviceEntity(CoreMidiDevice dev, String entName, int ii, String iN, int oi, String oN) {
            this.cmd = dev;
            this.name = entName;
            this.myInIndex = ii;
            this.inputName = iN;
            this.myOutIndex = oi;
            this.outputName = oN;
        }

        public CoreMidiDevice getDevice() {
            return this.cmd;
        }

        public String getName() {
            return this.name;
        }

        public int getInputIndex() {
            return this.myInIndex;
        }

        public String getInputName() {
            return this.inputName;
        }

        public int getOutputIndex() {
            return this.myOutIndex;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CoreMidiDeviceEntity name: " + this.name + ", on: " + this.cmd.getName());
            sb.append("\ninput: " + this.inputName + ", idx: " + this.myInIndex + ", output: " + this.outputName + ", idx: " + this.myOutIndex);
            return sb.toString();
        }
    }
}

