/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.mmj.spi;

import de.humatic.mmj.CoreMidiDevice;
import de.humatic.mmj.MidiSystem;
import de.humatic.mmj.spi.CoreMidiDeviceImpl;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public class CoreMidiProvider
extends MidiDeviceProvider {
    private static MidiDevice.Info[] infos;
    private static MidiDevice[] devices;
    private static int deviceCount;
    private int numIns;
    private boolean debug = false;

    public MidiDevice.Info[] getDeviceInfo() {
        CoreMidiDevice[] cmd = MidiSystem.getDevices();
        String[] inputsOnline = MidiSystem.getInputs();
        String[] outputsOnline = MidiSystem.getOutputs();
        this.numIns = 0;
        int numInfos = 0;
        boolean infoIndex = false;
        for (int i = 0; i < cmd.length; ++i) {
            for (int j = 0; j < cmd[i].getNumberOfEntities(); ++j) {
                int inIdx = cmd[i].getEntity(j).getInputIndex();
                int outIdx = cmd[i].getEntity(j).getOutputIndex();
                if (cmd[i].getEntity(j).getInputIndex() != -1 && this.isOnline(inputsOnline, cmd[i].getEntity(j))) {
                    ++this.numIns;
                    ++numInfos;
                }
                if (cmd[i].getEntity(j).getOutputIndex() == -1 || !this.isOnline(outputsOnline, cmd[i].getEntity(j))) continue;
                ++numInfos;
            }
        }
        infos = new MidiDevice.Info[numInfos];
        devices = new MidiDevice[numInfos];
        int inputIndex = 0;
        int outputIndex = this.numIns;
        for (int i = 0; i < cmd.length; ++i) {
            if (this.debug) {
                System.out.println("CMD: " + cmd[i]);
            }
            for (int j = 0; j < cmd[i].getNumberOfEntities(); ++j) {
                if (this.debug) {
                    System.out.println("entity: " + cmd[i].getEntity(j));
                }
                if (cmd[i].getEntity(j).getInputIndex() != -1 && this.isOnline(inputsOnline, cmd[i].getEntity(j))) {
                    CoreMidiProvider.infos[inputIndex] = new JSMDevInfo(cmd[i], cmd[i].getEntity(j), cmd[i].getInputIndex(j), -1);
                    CoreMidiProvider.devices[inputIndex] = new CoreMidiDeviceImpl(infos[inputIndex]);
                    if (this.debug) {
                        System.out.println("added input: " + infos[inputIndex]);
                    }
                    ++inputIndex;
                }
                if (cmd[i].getEntity(j).getOutputIndex() == -1 || !this.isOnline(outputsOnline, cmd[i].getEntity(j))) continue;
                CoreMidiProvider.infos[outputIndex] = new JSMDevInfo(cmd[i], cmd[i].getEntity(j), -1, cmd[i].getOutputIndex(j));
                CoreMidiProvider.devices[outputIndex] = new CoreMidiDeviceImpl(infos[outputIndex]);
                if (this.debug) {
                    System.out.println("added output: " + infos[outputIndex]);
                }
                ++outputIndex;
            }
        }
        return infos;
    }

    private boolean isOnline(String[] cmp, CoreMidiDevice.CoreMidiDeviceEntity ce) {
        for (int i = 0; i < cmp.length; ++i) {
            if (cmp[i].indexOf(ce.getDevice().getName()) == -1 || cmp[i].indexOf(ce.getName()) == -1 && cmp[i].indexOf(ce.getInputName()) == -1 && cmp[i].indexOf(ce.getOutputName()) == -1) continue;
            return true;
        }
        return false;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        for (int i = 0; i < infos.length; ++i) {
            if (!(info instanceof JSMDevInfo) || ((JSMDevInfo)info).inputIndex != ((JSMDevInfo)CoreMidiProvider.infos[i]).inputIndex || ((JSMDevInfo)info).outputIndex != ((JSMDevInfo)CoreMidiProvider.infos[i]).outputIndex || !info.getName().equalsIgnoreCase(infos[i].getName())) continue;
            return devices[i];
        }
        return null;
    }

    public boolean isDeviceSupported(MidiDevice.Info info) {
        return info instanceof JSMDevInfo && !info.getName().equalsIgnoreCase("Real Time Sequencer") && !info.getName().equalsIgnoreCase("Java Sound Synthesizer");
    }

    static {
        deviceCount = 0;
    }

    class JSMDevInfo
    extends MidiDevice.Info {
        int inputIndex = -1;
        int outputIndex = -1;

        protected JSMDevInfo(CoreMidiDevice dev, CoreMidiDevice.CoreMidiDeviceEntity entity, int inIndex, int outIndex) {
            super(dev.getName() + " - " + (inIndex >= 0 ? entity.getInputName() : entity.getOutputName()), dev.getManufacturer(), entity.getName(), "1.0");
            this.inputIndex = inIndex;
            this.outputIndex = outIndex;
        }
    }
}

