/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.mmj.spi;

import de.humatic.mmj.MidiInput;
import de.humatic.mmj.MidiListener;
import de.humatic.mmj.MidiOutput;
import de.humatic.mmj.MidiSystem;
import de.humatic.mmj.spi.CoreMidiProvider;
import java.util.List;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;

public class CoreMidiDeviceImpl
implements MidiDevice {
    private MidiDevice.Info info;
    private boolean open;
    private long start = 0L;
    private long caStart;
    private Vector receivers;
    private Vector transmitters;

    public CoreMidiDeviceImpl(MidiDevice.Info mdi) {
        this.info = mdi;
    }

    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    public void open() {
        this.start = System.currentTimeMillis() * 1000L;
        this.caStart = MidiSystem.getHostTime();
        this.open = true;
    }

    public void close() {
        try {
            for (int i = 0; i < this.transmitters.size(); ++i) {
                ((CoreMidiTransmitter)this.transmitters.get(i)).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.transmitters != null) {
            this.transmitters.removeAllElements();
        }
        this.open = false;
    }

    public int getMaxReceivers() {
        return ((CoreMidiProvider.JSMDevInfo)this.info).outputIndex >= 0 ? -1 : 0;
    }

    public int getMaxTransmitters() {
        return ((CoreMidiProvider.JSMDevInfo)this.info).inputIndex >= 0 ? -1 : 0;
    }

    public long getMicrosecondPosition() {
        if (!this.isOpen()) {
            return 0L;
        }
        return 1000L * System.currentTimeMillis() - this.start;
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        if (this.getMaxReceivers() == 0) {
            throw new MidiUnavailableException(this.info.getName() + " - no Receiver available");
        }
        if (this.receivers == null) {
            this.receivers = new Vector();
        }
        CoreMidiReceiver cmr = new CoreMidiReceiver(this.info);
        this.receivers.add(cmr);
        return cmr;
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        if (this.getMaxTransmitters() == 0) {
            throw new MidiUnavailableException(this.info.getName() + " - no Transmitter available");
        }
        if (this.transmitters == null) {
            this.transmitters = new Vector();
        }
        CoreMidiTransmitter cmt = new CoreMidiTransmitter(this.info);
        this.transmitters.add(cmt);
        return cmt;
    }

    public boolean isOpen() {
        return this.open;
    }

    public List getReceivers() {
        return this.receivers;
    }

    public List getTransmitters() {
        return this.transmitters;
    }

    private class CoreMidiTransmitter
    implements Transmitter,
    MidiListener {
        private Receiver receiver = null;
        private MidiInput midiIn;

        private CoreMidiTransmitter(MidiDevice.Info mdi) {
            this.midiIn = MidiSystem.openMidiInput(((CoreMidiProvider.JSMDevInfo)((CoreMidiDeviceImpl)CoreMidiDeviceImpl.this).info).inputIndex);
            this.midiIn.addMidiListener(this);
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void close() {
            this.midiIn.close();
            CoreMidiDeviceImpl.this.transmitters.removeElement(this);
        }

        public void midiInput(byte[] data) {
            MidiMessage msg = null;
            if (data[0] == -16) {
                msg = new SysexMessage();
                byte[] md = new byte[data.length - 1];
                System.arraycopy(data, 1, md, 0, md.length);
                try {
                    ((SysexMessage)msg).setMessage(240, md, md.length);
                }
                catch (InvalidMidiDataException imde) {
                    return;
                }
            } else if ((data[0] & 0xFF) < 128 || data[0] == 247) {
                if (data.length > 256) {
                    return;
                }
                msg = new SysexMessage();
                byte[] md = new byte[data.length];
                System.arraycopy(data, 0, md, 0, md.length);
                try {
                    ((SysexMessage)msg).setMessage(247, md, md.length);
                }
                catch (InvalidMidiDataException imde) {
                    return;
                }
            } else {
                if (data.length <= 3) {
                    msg = new ShortMessage();
                }
                switch (data.length) {
                    case 1: {
                        try {
                            ((ShortMessage)msg).setMessage(data[0] & 0xFF);
                        }
                        catch (InvalidMidiDataException imde) {}
                        break;
                    }
                    case 2: {
                        try {
                            ((ShortMessage)msg).setMessage(data[0] & 0xFF, data[1] & 0xFF, 0);
                        }
                        catch (InvalidMidiDataException imde) {}
                        break;
                    }
                    case 3: {
                        try {
                            ((ShortMessage)msg).setMessage(data[0] & 0xFF, data[1] & 0xFF, data[2] & 0xFF);
                            break;
                        }
                        catch (InvalidMidiDataException invalidMidiDataException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (msg == null) {
                return;
            }
            this.receiver.send(msg, CoreMidiDeviceImpl.this.getMicrosecondPosition());
        }
    }

    private class CoreMidiReceiver
    implements Receiver {
        private MidiOutput midiOut;

        private CoreMidiReceiver(MidiDevice.Info mdi) {
            this.midiOut = MidiSystem.openMidiOutput(((CoreMidiProvider.JSMDevInfo)((CoreMidiDeviceImpl)CoreMidiDeviceImpl.this).info).outputIndex);
        }

        public void send(MidiMessage midiMessage, long param) {
            this.midiOut.sendMidi(midiMessage.getMessage(), param <= 0L ? 0L : CoreMidiDeviceImpl.this.caStart + param);
        }

        public void close() {
        }
    }
}

