/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.mmj;

import de.humatic.mmj.CoreMidiDevice;
import de.humatic.mmj.MidiInput;
import de.humatic.mmj.MidiOutput;
import de.humatic.mmj.MidiSystemListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.prefs.Preferences;

public class MidiSystem {
    private static boolean inited = false;
    static boolean debug = false;
    static boolean libLoaded;
    static boolean running;
    private static String[] inPorts;
    private static String[] outPorts;
    private static MidiInput[] openedIns;
    private static MidiOutput[] openedOuts;
    private static String libPath;
    private static String vDest;
    private static String vSource;
    private static String JAR_VERSION;
    private static int numSources;
    private static int numDestinations;
    private static int orgNumSources;
    private static int orgNumDestinations;
    private static Vector SystemListeners;
    private static Boolean sendActiveSensing;

    private MidiSystem() {
    }

    static void log(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    public static void setLibraryPath(String path) throws IOException {
        if (path.indexOf("libmmj.jnilib") < 0) {
            path = path + File.separator + "libmmj.jnilib";
        }
        File f = new File(path);
        libPath = f.getAbsolutePath();
    }

    private static void loadLibrary() {
        if (libLoaded) {
            return;
        }
        if (libPath == null) {
            System.loadLibrary("mmj");
        } else {
            System.load(libPath);
        }
        libLoaded = true;
    }

    public static void initMidiSystem(String virtualSource, String virtualDestination) {
        if (inited) {
            return;
        }
        MidiSystem.log("loading library");
        MidiSystem.loadLibrary();
        MidiSystem.log("init callback");
        MidiSystem.initCallback();
        Vector<String> ins = new Vector<String>();
        Vector<String> outs = new Vector<String>();
        MidiSystem.log("nativeInitMidiSystem");
        MidiSystem.nativeInitMidiSystem(ins, outs, virtualSource == null ? "none" : virtualSource, virtualDestination == null ? "none" : virtualDestination, false);
        vSource = virtualSource;
        vDest = virtualDestination;
        orgNumSources = ins.size();
        orgNumDestinations = outs.size();
        if (vSource != null) {
            if (vDest == null) {
                ins.remove(ins.size() - 1);
            } else {
                ins.setElementAt(vDest, ins.size() - 1);
            }
        } else if (vDest != null) {
            ins.add(vDest);
        }
        if (vDest != null) {
            if (vSource == null) {
                outs.remove(outs.size() - 1);
            } else {
                outs.setElementAt(vSource, outs.size() - 1);
            }
        } else if (vSource != null) {
            outs.add(vSource);
        }
        numSources = ins.size();
        numDestinations = outs.size();
        inPorts = new String[ins.size()];
        outPorts = new String[outs.size()];
        ins.toArray(inPorts);
        outs.toArray(outPorts);
        openedIns = new MidiInput[inPorts.length];
        openedOuts = new MidiOutput[outPorts.length];
        inited = true;
        MidiSystem.log("installing hook");
        MidiSystem.installHook();
        ins.removeAllElements();
        outs.removeAllElements();
        MidiSystem.log("mmj: system running");
    }

    static void rescanMidiSystem() {
        Vector<String> ins = new Vector<String>();
        Vector<String> outs = new Vector<String>();
        MidiSystem.nativeInitMidiSystem(ins, outs, null, null, true);
        orgNumSources = ins.size();
        orgNumDestinations = outs.size();
        if (vSource != null) {
            if (vDest == null) {
                ins.remove(ins.size() - 1);
            } else {
                ins.setElementAt(vDest, ins.size() - 1);
            }
        } else if (vDest != null) {
            ins.add(vDest);
        }
        if (vDest != null) {
            if (vSource == null) {
                outs.remove(outs.size() - 1);
            } else {
                outs.setElementAt(vSource, outs.size() - 1);
            }
        } else if (vSource != null) {
            outs.add(vSource);
        }
        numSources = ins.size();
        numDestinations = outs.size();
        inPorts = new String[ins.size() + (vDest != null && vSource == null ? 1 : 0)];
        outPorts = new String[outs.size() + (vDest == null && vSource != null ? 1 : 0)];
        ins.toArray(inPorts);
        outs.toArray(outPorts);
        if (vDest != null) {
            MidiSystem.inPorts[MidiSystem.inPorts.length - 1] = vDest;
        }
        if (vSource != null) {
            MidiSystem.outPorts[MidiSystem.outPorts.length - 1] = vSource;
        }
        try {
            int j;
            int j2;
            boolean found;
            if (openedIns.length != inPorts.length) {
                for (int i = 0; i < openedIns.length; ++i) {
                    if (openedIns[i] == null) continue;
                    MidiInput in = openedIns[i];
                    try {
                        System.out.println(in.NAME);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    found = false;
                    for (j2 = 0; j2 < inPorts.length; ++j2) {
                        try {
                            if (!in.NAME.equalsIgnoreCase(inPorts[j2])) continue;
                            found = true;
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (found) continue;
                    in.close();
                    MidiSystem.openedIns[i] = null;
                }
                MidiInput[] tempIns = new MidiInput[openedIns.length];
                System.arraycopy(openedIns, 0, tempIns, 0, openedIns.length);
                openedIns = new MidiInput[inPorts.length];
                for (int i = 0; i < tempIns.length; ++i) {
                    if (tempIns[i] == null) continue;
                    for (j = 0; j < inPorts.length; ++j) {
                        if (!tempIns[i].NAME.equalsIgnoreCase(inPorts[j])) continue;
                        MidiSystem.openedIns[j] = tempIns[i];
                    }
                }
            }
            if (openedOuts.length != outPorts.length) {
                for (int i = 0; i < openedOuts.length; ++i) {
                    if (openedOuts[i] == null) continue;
                    MidiOutput out = openedOuts[i];
                    found = false;
                    for (j2 = 0; j2 < outPorts.length; ++j2) {
                        try {
                            if (!out.getName().equalsIgnoreCase(outPorts[j2])) continue;
                            found = true;
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (found) continue;
                    MidiSystem.openedOuts[i] = null;
                }
                MidiOutput[] tempOuts = new MidiOutput[openedOuts.length];
                System.arraycopy(openedOuts, 0, tempOuts, 0, openedOuts.length);
                openedOuts = new MidiOutput[outPorts.length];
                for (int i = 0; i < tempOuts.length; ++i) {
                    if (tempOuts[i] == null) continue;
                    for (j = 0; j < outPorts.length; ++j) {
                        if (!tempOuts[i].getName().equalsIgnoreCase(outPorts[j])) continue;
                        MidiSystem.openedOuts[j] = tempOuts[i];
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ins.removeAllElements();
        outs.removeAllElements();
    }

    public static CoreMidiDevice[] getDevices() {
        MidiSystem.loadLibrary();
        Vector devices = new Vector();
        MidiSystem.nativeGetDevices(devices);
        CoreMidiDevice[] devs = new CoreMidiDevice[devices.size()];
        devices.toArray(devs);
        devices.removeAllElements();
        return devs;
    }

    public static void closeMidiSystem() {
        inited = false;
        vSource = null;
        vDest = null;
        MidiSystem.nativeCloseMidiSystem();
    }

    public static int getNumberOfInputs() {
        return MidiSystem.getInputs().length;
    }

    public static String[] getInputs() {
        if (!inited) {
            MidiSystem.initMidiSystem(null, null);
        }
        return inPorts;
    }

    public static int getNumberOfOutputs() {
        return MidiSystem.getOutputs().length;
    }

    public static String[] getOutputs() {
        if (!inited) {
            MidiSystem.initMidiSystem(null, null);
        }
        return outPorts;
    }

    public static void dump(byte[] data) {
        System.out.println("");
        for (int i = 0; i < data.length; ++i) {
            System.out.print(Long.toHexString(data[i] & 0xFF));
            System.out.print(" ");
            if ((i + 1) % 16 != 0) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    static String getVirtualDestinationName() {
        return vDest;
    }

    static String getVirtualSourceName() {
        return vSource;
    }

    public static MidiInput openMidiInput(int index) {
        if (!inited) {
            MidiSystem.initMidiSystem(null, null);
        }
        if (openedIns[index] != null) {
            return openedIns[index];
        }
        long p = MidiSystem.initInputPort(index);
        MidiSystem.openedIns[index] = new MidiInput(p, index);
        return openedIns[index];
    }

    static void inputClosed(int index) {
        if (openedIns[index] == null) {
            return;
        }
        MidiSystem.openedIns[index] = null;
    }

    static MidiInput getPort(long index) {
        for (int i = 0; i < openedIns.length; ++i) {
            try {
                if ((long)MidiSystem.openedIns[i].INDEX != index) continue;
                return openedIns[i];
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    static void midiReceive(byte[] msg, int index) {
        try {
            MidiSystem.getPort(index).midiInput(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MidiOutput openMidiOutput(int index) {
        MidiOutput mop;
        if (!inited) {
            MidiSystem.initMidiSystem(null, null);
        }
        if (openedOuts[index] != null) {
            return openedOuts[index];
        }
        long p = MidiSystem.initOutputPort(index);
        MidiSystem.openedOuts[index] = mop = new MidiOutput(p, index);
        return mop;
    }

    static void outputClosed(int index) {
        try {
            if (openedOuts[index] == null) {
                return;
            }
            MidiSystem.openedOuts[index] = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setMidiThru(int srcIndex, int destBitMask) {
        if (!inited) {
            MidiSystem.initMidiSystem(null, null);
        }
        MidiSystem.nativeSetThru(srcIndex, destBitMask);
    }

    public static String getLibraryVersion() {
        MidiSystem.loadLibrary();
        return MidiSystem.nativeGetLibraryVersion();
    }

    public static String getJarVersion() {
        return JAR_VERSION;
    }

    public static long getHostTime() {
        MidiSystem.loadLibrary();
        return MidiSystem.getCurrentHostTime();
    }

    static native long getCurrentHostTime();

    static native long initInputPort(int var0);

    static native long initOutputPort(int var0);

    static native boolean nativeCloseInput(long var0, int var2);

    static native void nativeCloseMidiSystem();

    static native void initCallback();

    private static native void initMethodIDs();

    private static native void nativeInitMidiSystem(Vector var0, Vector var1, String var2, String var3, boolean var4);

    private static native void nativeGetDevices(Vector var0);

    static native void nativeSetThru(int var0, int var1);

    static native void startRunLoop();

    static native boolean systemChanged(int var0, int var1);

    static native String nativeGetDeviceInfo(int var0, int var1);

    static native String nativeGetLibraryVersion();

    public static void enableActiveSensing(boolean enable) throws Exception {
        Preferences p = Preferences.userRoot().node("de").node("humatic").node("mmj");
        p.put("as", String.valueOf(enable));
    }

    private static boolean getActiveSensing() {
        Preferences p = Preferences.userRoot().node("de").node("humatic").node("mmj");
        return p.getBoolean("as", false);
    }

    private static void installHook() {
        Runtime.getRuntime().addShutdownHook(new CloseHook());
    }

    public static void addSystemListener(MidiSystemListener msl) {
        if (SystemListeners == null) {
            SystemListeners = new Vector();
        }
        SystemListeners.add(msl);
        if (!running) {
            NotifyLoop nl = new NotifyLoop();
            running = true;
            nl.start();
        }
    }

    static {
        JAR_VERSION = "0.94";
        sendActiveSensing = null;
    }

    private static class NotifyLoop
    extends Thread {
        private NotifyLoop() {
        }

        public void run() {
            while (running) {
                if (MidiSystem.systemChanged(orgNumSources, orgNumDestinations)) {
                    MidiSystem.rescanMidiSystem();
                    for (int i = 0; i < SystemListeners.size(); ++i) {
                        ((MidiSystemListener)SystemListeners.get(i)).systemChanged();
                    }
                }
                try {
                    NotifyLoop.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class CloseHook
    extends Thread {
        private CloseHook() {
        }

        public void run() {
            for (int i = 0; i < openedIns.length; ++i) {
                try {
                    openedIns[i].close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

