/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.mmj;

import de.humatic.mmj.CoreMidiDevice;
import de.humatic.mmj.MidiListener;
import de.humatic.mmj.MidiSystem;
import java.util.Vector;

public class MidiInput {
    int INDEX;
    int numSysEx = 0;
    long ID;
    private Vector listeners;
    private boolean assemble;
    private Vector sysExIn = new Vector();
    String NAME;
    public static final Object globalsLock = MidiInput._getLock();
    private static Object _lock;

    MidiInput(long p, int index) {
        this.INDEX = index;
        this.listeners = new Vector();
        this.ID = p;
        this.NAME = p > 0L ? MidiSystem.getInputs()[this.INDEX] : MidiSystem.getVirtualDestinationName();
    }

    static void sysExSim(byte[] msg) {
        int num;
        byte[] sysEx = new byte[]{-16, 127, 127, 6, 68, 6, 1, 32, 0, 11, 12, 0, -9};
        for (int sum = 0; sum < sysEx.length; sum += num) {
            num = (int)(Math.random() * (double)(sysEx.length - sum));
            if (num == 0) {
                num = 1;
            }
            byte[] xmsg = new byte[num];
            System.arraycopy(sysEx, sum, xmsg, 0, num);
            MidiInput.sysExSim(xmsg);
        }
    }

    void midiInput(byte[] msg) {
        int i;
        if (msg.length > 256) {
            return;
        }
        if (MidiSystem.debug) {
            System.out.print(this.NAME + ", got MIDI: ");
            for (i = 0; i < msg.length; ++i) {
                System.out.print(msg[i] + "  ");
            }
            System.out.println("");
        }
        this.assemble = msg[0] == -16 && msg[msg.length - 1] != -9 || (msg[0] & 0xFF) < 128 || msg[0] == -9;
        if (this.assemble) {
            ++this.numSysEx;
            for (i = 0; i < msg.length; ++i) {
                int j;
                byte[] sysExOut;
                if (msg[i] == -9 && i != 0) {
                    sysExOut = new byte[this.sysExIn.size() + 1];
                    for (j = 0; j < this.sysExIn.size(); ++j) {
                        sysExOut[j] = (Byte)this.sysExIn.get(j);
                    }
                    sysExOut[sysExOut.length - 1] = -9;
                    this.sysExIn.removeAllElements();
                    for (j = 0; j < this.listeners.size(); ++j) {
                        ((MidiListener)this.listeners.get(j)).midiInput(sysExOut);
                    }
                    this.assemble = false;
                    this.numSysEx = 0;
                    return;
                }
                if (msg[i] != -9) {
                    this.sysExIn.add(new Byte(msg[i]));
                    continue;
                }
                if (i == 0 && msg.length > 1) continue;
                sysExOut = new byte[this.sysExIn.size() + 1];
                for (j = 0; j < this.sysExIn.size(); ++j) {
                    sysExOut[j] = (Byte)this.sysExIn.get(j);
                }
                sysExOut[sysExOut.length - 1] = -9;
                this.sysExIn.removeAllElements();
                this.assemble = false;
                for (j = 0; j < this.listeners.size(); ++j) {
                    ((MidiListener)this.listeners.get(j)).midiInput(sysExOut);
                }
            }
        } else {
            for (i = 0; i < this.listeners.size(); ++i) {
                ((MidiListener)this.listeners.get(i)).midiInput(msg);
            }
        }
    }

    public boolean addMidiListener(MidiListener ml) {
        if (this.listeners.contains(ml)) {
            return false;
        }
        this.listeners.add(ml);
        return true;
    }

    public boolean removeMidiListener(MidiListener ml) {
        if (!this.listeners.contains(ml)) {
            return false;
        }
        this.listeners.remove(ml);
        return true;
    }

    public void close() {
        this.listeners.removeAllElements();
        this.nativeCloseInput(this.ID, this.INDEX);
        MidiSystem.inputClosed(this.INDEX);
    }

    public String getName() {
        return this.NAME;
    }

    public int getIndex() {
        return this.INDEX;
    }

    public String toString() {
        return this.getName() + ", index: " + this.getIndex();
    }

    public CoreMidiDevice getDeviceInfo() {
        String info = MidiSystem.nativeGetDeviceInfo(0, this.INDEX);
        if (info.equalsIgnoreCase("virtual")) {
            return null;
        }
        CoreMidiDevice[] devices = MidiSystem.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!info.split(";")[0].split("=")[1].equalsIgnoreCase(devices[i].getName())) continue;
            return devices[i];
        }
        return null;
    }

    native boolean nativeCloseInput(long var1, int var3);

    private static Object _getLock() {
        if (_lock == null) {
            _lock = new Object();
        }
        return _lock;
    }
}

