/*
 * Decompiled with CFR 0.152.
 */
package themidibus;

import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;
import processing.core.PApplet;
import themidibus.ControlChange;
import themidibus.MidiListener;
import themidibus.Note;
import themidibus.ObjectMidiListener;
import themidibus.RawMidiListener;
import themidibus.SimpleMidiListener;
import themidibus.StandardMidiListener;

public class MidiBus {
    static MidiDevice.Info[] available_devices;
    String bus_name;
    Vector<InputDeviceContainer> input_devices;
    Vector<OutputDeviceContainer> output_devices;
    Vector<MidiListener> listeners;
    Object parent;
    Method method_note_on;
    Method method_note_off;
    Method method_controller_change;
    Method method_raw_midi;
    Method method_midi_message;
    Method method_note_on_with_bus_name;
    Method method_note_off_with_bus_name;
    Method method_controller_change_with_bus_name;
    Method method_raw_midi_with_bus_name;
    Method method_midi_message_with_bus_name;
    Method method_note_on_wcla;
    Method method_note_off_wcla;
    Method method_controller_change_wcla;
    boolean sendTimestamps;

    public MidiBus() {
        this.init(null, null);
    }

    public MidiBus(Object object) {
        this.init(object, null);
    }

    public MidiBus(Object object, String string) {
        this.init(object, string);
    }

    public MidiBus(Object object, int n, int n2) {
        this.init(object, null);
        this.addInput(n);
        this.addOutput(n2);
    }

    public MidiBus(Object object, int n, int n2, String string) {
        this.init(object, string);
        this.addInput(n);
        this.addOutput(n2);
    }

    public MidiBus(Object object, String string, String string2) {
        this.init(object, null);
        this.addInput(string);
        this.addOutput(string2);
    }

    public MidiBus(Object object, String string, String string2, String string3) {
        this.init(object, string3);
        this.addInput(string);
        this.addOutput(string2);
    }

    public MidiBus(Object object, int n, String string) {
        this.init(object, null);
        this.addInput(n);
        this.addOutput(string);
    }

    public MidiBus(Object object, int n, String string, String string2) {
        this.init(object, string2);
        this.addInput(n);
        this.addOutput(string);
    }

    public MidiBus(Object object, String string, int n) {
        this.init(object, null);
        this.addInput(string);
        this.addOutput(n);
    }

    public MidiBus(Object object, String string, int n, String string2) {
        this.init(object, string2);
        this.addInput(string);
        this.addOutput(n);
    }

    private void init(Object object, String string) {
        this.registerParent(object);
        if (string == null) {
            this.generateBusName();
        } else {
            this.bus_name = string;
        }
        this.input_devices = new Vector();
        this.output_devices = new Vector();
        this.listeners = new Vector();
        this.sendTimestamps = true;
    }

    public String[] attachedInputs() {
        MidiDevice.Info[] infoArray = this.attachedInputsMidiDeviceInfo();
        String[] stringArray = new String[infoArray.length];
        for (int i = 0; i < infoArray.length; ++i) {
            stringArray[i] = infoArray[i].getName();
        }
        return stringArray;
    }

    public String[] attachedOutputs() {
        MidiDevice.Info[] infoArray = this.attachedOutputsMidiDeviceInfo();
        String[] stringArray = new String[infoArray.length];
        for (int i = 0; i < infoArray.length; ++i) {
            stringArray[i] = infoArray[i].getName();
        }
        return stringArray;
    }

    MidiDevice.Info[] attachedInputsMidiDeviceInfo() {
        MidiDevice.Info[] infoArray = new MidiDevice.Info[this.input_devices.size()];
        for (int i = 0; i < this.input_devices.size(); ++i) {
            infoArray[i] = this.input_devices.get((int)i).info;
        }
        return infoArray;
    }

    MidiDevice.Info[] attachedOutputsMidiDeviceInfo() {
        MidiDevice.Info[] infoArray = new MidiDevice.Info[this.output_devices.size()];
        for (int i = 0; i < this.output_devices.size(); ++i) {
            infoArray[i] = this.output_devices.get((int)i).info;
        }
        return infoArray;
    }

    public boolean addInput(int n) {
        if (n == -1) {
            return false;
        }
        MidiDevice.Info[] infoArray = MidiBus.availableInputsMidiDeviceInfo();
        if (n >= infoArray.length || n < 0) {
            System.err.println("\nThe MidiBus Warning: The chosen input device numbered [" + n + "] was not added because it doesn't exist");
            return false;
        }
        return this.addInput(infoArray[n]);
    }

    public synchronized boolean removeInput(int n) {
        try {
            InputDeviceContainer inputDeviceContainer = this.input_devices.get(n);
            this.input_devices.remove(inputDeviceContainer);
            inputDeviceContainer.transmitter.close();
            inputDeviceContainer.receiver.close();
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public boolean addInput(String string) {
        if (string.equals("")) {
            return false;
        }
        MidiDevice.Info[] infoArray = MidiBus.availableInputsMidiDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            if (!infoArray[i].getName().equals(string)) continue;
            return this.addInput(infoArray[i]);
        }
        System.err.println("\nThe MidiBus Warning: No available input MIDI devices named: \"" + string + "\" were found");
        return false;
    }

    public synchronized boolean removeInput(String string) {
        for (InputDeviceContainer inputDeviceContainer : this.input_devices) {
            if (!inputDeviceContainer.info.getName().equals(string)) continue;
            this.input_devices.remove(inputDeviceContainer);
            inputDeviceContainer.transmitter.close();
            inputDeviceContainer.receiver.close();
            return true;
        }
        return false;
    }

    synchronized boolean addInput(MidiDevice.Info info) {
        try {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
            if (midiDevice.getMaxTransmitters() == 0) {
                System.err.println("\nThe MidiBus Warning: The chosen input device \"" + info.getName() + "\" was not added because it is output only");
                return false;
            }
            for (InputDeviceContainer object2 : this.input_devices) {
                if (!info.getName().equals(object2.info.getName())) continue;
                return false;
            }
            if (!midiDevice.isOpen()) {
                midiDevice.open();
            }
            MReceiver mReceiver = new MReceiver();
            Transmitter transmitter = midiDevice.getTransmitter();
            transmitter.setReceiver(mReceiver);
            InputDeviceContainer inputDeviceContainer = new InputDeviceContainer(midiDevice);
            inputDeviceContainer.transmitter = transmitter;
            inputDeviceContainer.receiver = mReceiver;
            this.input_devices.add(inputDeviceContainer);
            return true;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            System.err.println("\nThe MidiBus Warning: The chosen input device \"" + info.getName() + "\" was not added because it is unavailable");
            return false;
        }
    }

    public boolean addOutput(int n) {
        if (n == -1) {
            return false;
        }
        MidiDevice.Info[] infoArray = MidiBus.availableOutputsMidiDeviceInfo();
        if (n >= infoArray.length || n < 0) {
            System.err.println("\nThe MidiBus Warning: The chosen output device numbered [" + n + "] was not added because it doesn't exist");
            return false;
        }
        return this.addOutput(infoArray[n]);
    }

    public synchronized boolean removeOutput(int n) {
        try {
            OutputDeviceContainer outputDeviceContainer = this.output_devices.get(n);
            this.output_devices.remove(outputDeviceContainer);
            outputDeviceContainer.receiver.close();
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public boolean addOutput(String string) {
        if (string.equals("")) {
            return false;
        }
        MidiDevice.Info[] infoArray = MidiBus.availableOutputsMidiDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            if (!infoArray[i].getName().equals(string)) continue;
            return this.addOutput(infoArray[i]);
        }
        System.err.println("\nThe MidiBus Warning: No available input MIDI devices named: \"" + string + "\" were found");
        return false;
    }

    public synchronized boolean removeOutput(String string) {
        for (OutputDeviceContainer outputDeviceContainer : this.output_devices) {
            if (!outputDeviceContainer.info.getName().equals(string)) continue;
            this.output_devices.remove(outputDeviceContainer);
            outputDeviceContainer.receiver.close();
            return true;
        }
        return false;
    }

    synchronized boolean addOutput(MidiDevice.Info info) {
        try {
            MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
            if (midiDevice.getMaxReceivers() == 0) {
                System.err.println("\nThe MidiBus Warning: The chosen output device \"" + info.getName() + "\" was not added because it is input only");
                return false;
            }
            for (OutputDeviceContainer outputDeviceContainer : this.output_devices) {
                if (!info.getName().equals(outputDeviceContainer.info.getName())) continue;
                return false;
            }
            if (!midiDevice.isOpen()) {
                midiDevice.open();
            }
            OutputDeviceContainer outputDeviceContainer = new OutputDeviceContainer(midiDevice);
            outputDeviceContainer.receiver = midiDevice.getReceiver();
            this.output_devices.add(outputDeviceContainer);
            return true;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            System.err.println("\nThe MidiBus Warning: The chosen output device \"" + info.getName() + "\" was not added because it is unavailable");
            return false;
        }
    }

    public synchronized void clearInputs() {
        try {
            for (InputDeviceContainer inputDeviceContainer : this.input_devices) {
                inputDeviceContainer.transmitter.close();
                inputDeviceContainer.receiver.close();
            }
        }
        catch (Exception exception) {
            System.err.println("The MidiBus Warning: Unexpected error during clearInputs()");
        }
        this.input_devices.clear();
    }

    public synchronized void clearOutputs() {
        try {
            for (OutputDeviceContainer outputDeviceContainer : this.output_devices) {
                outputDeviceContainer.receiver.close();
            }
        }
        catch (Exception exception) {
            System.err.println("The MidiBus Warning: Unexpected error during clearOutputs()");
        }
        this.output_devices.clear();
    }

    public void clearAll() {
        this.clearInputs();
        this.clearOutputs();
    }

    void closeAllMidiDevices() {
        if (available_devices == null) {
            MidiBus.findMidiDevices();
        }
        for (int i = 0; i < available_devices.length; ++i) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(available_devices[i]);
                if (!midiDevice.isOpen()) continue;
                midiDevice.close();
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
    }

    public void sendMessage(byte[] byArray) {
        if ((byArray[0] & 0xFF) == 255) {
            MetaMessage metaMessage = new MetaMessage();
            try {
                byte[] byArray2 = new byte[byArray.length - 2];
                System.arraycopy(byArray, 2, byArray2, 0, byArray.length - 2);
                metaMessage.setMessage(byArray[1] & 0xFF, byArray2, byArray.length - 2);
                this.sendMessage(metaMessage);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
            }
        } else if ((byArray[0] & 0xFF) == 240 || (byArray[0] & 0xFF) == 247) {
            SysexMessage sysexMessage = new SysexMessage();
            try {
                sysexMessage.setMessage(byArray, byArray.length);
                this.sendMessage(sysexMessage);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
            }
        } else {
            ShortMessage shortMessage = new ShortMessage();
            try {
                if (byArray.length > 2) {
                    shortMessage.setMessage(byArray[0] & 0xFF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                } else if (byArray.length > 1) {
                    shortMessage.setMessage(byArray[0] & 0xFF, byArray[1] & 0xFF, 0);
                } else {
                    shortMessage.setMessage(byArray[0] & 0xFF);
                }
                this.sendMessage(shortMessage);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
            }
        }
    }

    public void sendMessage(int n) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n);
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.out.println(invalidMidiDataException);
            System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
        }
    }

    public void sendMessage(int n, int n2) {
        this.sendMessage(n, n2, 0);
    }

    public void sendMessage(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3);
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
        }
    }

    public void sendMessage(int n, int n2, int n3, int n4) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3, n4);
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
        }
    }

    public synchronized void sendMessage(MidiMessage midiMessage) {
        for (OutputDeviceContainer outputDeviceContainer : this.output_devices) {
            if (this.sendTimestamps) {
                outputDeviceContainer.receiver.send(midiMessage, System.currentTimeMillis());
                continue;
            }
            outputDeviceContainer.receiver.send(midiMessage, 0L);
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(144, this.constrain(n, 0, 15), this.constrain(n2, 0, 127), this.constrain(n3, 0, 127));
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
        }
    }

    public void sendNoteOn(Note note) {
        this.sendNoteOn(note.channel(), note.pitch(), note.velocity());
    }

    public void sendNoteOff(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(128, this.constrain(n, 0, 15), this.constrain(n2, 0, 127), this.constrain(n3, 0, 127));
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
        }
    }

    public void sendNoteOff(Note note) {
        this.sendNoteOff(note.channel, note.pitch(), note.velocity());
    }

    public void sendControllerChange(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(176, this.constrain(n, 0, 15), this.constrain(n2, 0, 127), this.constrain(n3, 0, 127));
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            System.err.println("\nThe MidiBus Warning: Message not sent, invalid MIDI data");
        }
    }

    public void sendControllerChange(ControlChange controlChange) {
        this.sendControllerChange(controlChange.channel(), controlChange.number(), controlChange.value());
    }

    void notifyListeners(MidiMessage midiMessage, long l) {
        byte[] byArray = midiMessage.getMessage();
        for (MidiListener midiListener : this.listeners) {
            if (midiListener instanceof RawMidiListener) {
                ((RawMidiListener)midiListener).rawMidiMessage(byArray);
            }
            if (midiListener instanceof SimpleMidiListener) {
                if ((byArray[0] & 0xF0) == 144) {
                    ((SimpleMidiListener)midiListener).noteOn(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                } else if ((byArray[0] & 0xF0) == 128) {
                    ((SimpleMidiListener)midiListener).noteOff(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                } else if ((byArray[0] & 0xF0) == 176) {
                    ((SimpleMidiListener)midiListener).controllerChange(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                }
            }
            if (midiListener instanceof StandardMidiListener) {
                ((StandardMidiListener)midiListener).midiMessage(midiMessage, l);
            }
            if (!(midiListener instanceof ObjectMidiListener)) continue;
            if ((byArray[0] & 0xF0) == 144) {
                ((ObjectMidiListener)midiListener).noteOn(new Note(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF));
                continue;
            }
            if ((byArray[0] & 0xF0) == 128) {
                ((ObjectMidiListener)midiListener).noteOff(new Note(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF));
                continue;
            }
            if ((byArray[0] & 0xF0) != 176) continue;
            ((ObjectMidiListener)midiListener).controllerChange(new ControlChange(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF));
        }
    }

    void notifyParent(MidiMessage midiMessage, long l) {
        if (this.parent == null) {
            return;
        }
        byte[] byArray = midiMessage.getMessage();
        if ((byArray[0] & 0xF0) == 144) {
            if (this.method_note_on != null) {
                try {
                    this.method_note_on.invoke(this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling noteOn(int channel, int pitch, int velocity) because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_note_on = null;
                }
            }
            if (this.method_note_on_with_bus_name != null) {
                try {
                    this.method_note_on_with_bus_name.invoke(this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, l, this.bus_name);
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling noteOn(int channel, int pitch, int velocity, String bus_name) with bus_name because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_note_on_with_bus_name = null;
                }
            }
            if (this.method_note_on_wcla != null) {
                try {
                    this.method_note_on_wcla.invoke(this.parent, new Note(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, l, this.bus_name));
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling noteOn(Note note) because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_note_on_wcla = null;
                }
            }
        } else if ((byArray[0] & 0xF0) == 128) {
            if (this.method_note_off != null) {
                try {
                    this.method_note_off.invoke(this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling noteOff(int channel, int pitch, int velocity) because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_note_off = null;
                }
            }
            if (this.method_note_off_with_bus_name != null) {
                try {
                    this.method_note_off_with_bus_name.invoke(this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, l, this.bus_name);
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling noteOff(int channel, int pitch, int velocity, String bus_name) with bus_name because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_note_off_with_bus_name = null;
                }
            }
            if (this.method_note_off_wcla != null) {
                try {
                    this.method_note_off_wcla.invoke(this.parent, new Note(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, l, this.bus_name));
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling noteOff(Note note) because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_note_off_wcla = null;
                }
            }
        } else if ((byArray[0] & 0xF0) == 176) {
            if (this.method_controller_change != null) {
                try {
                    this.method_controller_change.invoke(this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF);
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling controllerChange(int channel, int number, int value) because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_controller_change = null;
                }
            }
            if (this.method_controller_change_with_bus_name != null) {
                try {
                    this.method_controller_change_with_bus_name.invoke(this.parent, byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, l, this.bus_name);
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling controllerChange(int channel, int number, int value, String bus_name) with bus_name because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_controller_change_with_bus_name = null;
                }
            }
            if (this.method_controller_change_wcla != null) {
                try {
                    this.method_controller_change_wcla.invoke(this.parent, new ControlChange(byArray[0] & 0xF, byArray[1] & 0xFF, byArray[2] & 0xFF, l, this.bus_name));
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Disabling noteOff(Note note) because an unkown exception was thrown and caught");
                    exception.printStackTrace();
                    this.method_controller_change_wcla = null;
                }
            }
        }
        if (this.method_raw_midi != null) {
            try {
                this.method_raw_midi.invoke(this.parent, new Object[]{byArray});
            }
            catch (Exception exception) {
                System.err.println("\nThe MidiBus Warning: Disabling rawMidi(byte[] data) because an unkown exception was thrown and caught");
                exception.printStackTrace();
                this.method_raw_midi = null;
            }
        }
        if (this.method_raw_midi_with_bus_name != null) {
            try {
                this.method_raw_midi_with_bus_name.invoke(this.parent, byArray, l, this.bus_name);
            }
            catch (Exception exception) {
                System.err.println("\nThe MidiBus Warning: Disabling rawMidi(byte[] data, String bus_name) with bus_name because an unkown exception was thrown and caught");
                exception.printStackTrace();
                this.method_raw_midi_with_bus_name = null;
            }
        }
        if (this.method_midi_message != null) {
            try {
                this.method_midi_message.invoke(this.parent, midiMessage);
            }
            catch (Exception exception) {
                System.err.println("\nThe MidiBus Warning: Disabling midiMessage(MidiMessage message) because an unkown exception was thrown and caught");
                exception.printStackTrace();
                this.method_midi_message = null;
            }
        }
        if (this.method_midi_message_with_bus_name != null) {
            try {
                this.method_midi_message_with_bus_name.invoke(this.parent, midiMessage, l, this.bus_name);
            }
            catch (Exception exception) {
                System.err.println("\nThe MidiBus Warning: Disabling midiMessage(MidiMessage message, String bus_name) with bus_name because an unkown exception was thrown and caught");
                exception.printStackTrace();
                this.method_midi_message_with_bus_name = null;
            }
        }
    }

    public Object registerParent(Object object) {
        Object object2 = this.parent;
        if (object2 != null) {
            if (object2 instanceof PApplet) {
                ((PApplet)object).unregisterDispose((Object)this);
            }
            this.method_note_on = null;
            this.method_note_off = null;
            this.method_controller_change = null;
            this.method_raw_midi = null;
            this.method_midi_message = null;
            this.method_note_on_with_bus_name = null;
            this.method_note_off_with_bus_name = null;
            this.method_controller_change_with_bus_name = null;
            this.method_raw_midi_with_bus_name = null;
            this.method_midi_message_with_bus_name = null;
        }
        this.parent = object;
        if (object != null) {
            if (object instanceof PApplet) {
                ((PApplet)object).registerDispose((Object)this);
            }
            try {
                this.method_note_on = object.getClass().getMethod("noteOn", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_note_off = object.getClass().getMethod("noteOff", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_controller_change = object.getClass().getMethod("controllerChange", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_raw_midi = object.getClass().getMethod("rawMidi", byte[].class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_midi_message = object.getClass().getMethod("midiMessage", MidiMessage.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_note_on_with_bus_name = object.getClass().getMethod("noteOn", Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_note_off_with_bus_name = object.getClass().getMethod("noteOff", Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_controller_change_with_bus_name = object.getClass().getMethod("controllerChange", Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_raw_midi_with_bus_name = object.getClass().getMethod("rawMidi", byte[].class, Long.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_midi_message_with_bus_name = object.getClass().getMethod("midiMessage", MidiMessage.class, Long.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_note_on_wcla = object.getClass().getMethod("noteOn", Note.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_note_off_wcla = object.getClass().getMethod("noteOff", Note.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.method_controller_change_wcla = object.getClass().getMethod("controllerChange", ControlChange.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object2;
    }

    public boolean addMidiListener(MidiListener midiListener) {
        for (MidiListener midiListener2 : this.listeners) {
            if (midiListener2 != midiListener) continue;
            return false;
        }
        this.listeners.add(midiListener);
        return true;
    }

    public boolean removeMidiListener(MidiListener midiListener) {
        for (MidiListener midiListener2 : this.listeners) {
            if (midiListener2 != midiListener) continue;
            this.listeners.remove(midiListener);
            return true;
        }
        return false;
    }

    int constrain(int n, int n2, int n3) {
        if (n > n3) {
            n = n3;
        }
        if (n < n2) {
            n = n2;
        }
        return n;
    }

    public boolean sendTimestamps() {
        return this.sendTimestamps;
    }

    public void sendTimestamps(boolean bl) {
        this.sendTimestamps = bl;
    }

    public String getBusName() {
        return this.bus_name;
    }

    public void setBusName(String string) {
        this.bus_name = string;
    }

    public void generateBusName() {
        String string = new Formatter().format("%08d", System.currentTimeMillis() % 100000000L).toString();
        this.bus_name = "MidiBus_" + string;
    }

    public String toString() {
        String string = "MidiBus: " + this.bus_name + " [";
        string = string + this.input_devices.size() + " input(s), ";
        string = string + this.output_devices.size() + " output(s), ";
        string = string + this.listeners.size() + " listener(s)]";
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof MidiBus) {
            MidiBus midiBus = (MidiBus)object;
            if (!this.getBusName().equals(midiBus.getBusName())) {
                return false;
            }
            if (!this.input_devices.equals(midiBus.input_devices)) {
                return false;
            }
            if (!this.output_devices.equals(midiBus.output_devices)) {
                return false;
            }
            return this.listeners.equals(midiBus.listeners);
        }
        return false;
    }

    public MidiBus clone() {
        MidiBus midiBus = new MidiBus(this.parent, this.bus_name);
        for (InputDeviceContainer object : this.input_devices) {
            midiBus.addInput(object.info);
        }
        for (OutputDeviceContainer outputDeviceContainer : this.output_devices) {
            midiBus.addOutput(outputDeviceContainer.info);
        }
        for (MidiListener midiListener : this.listeners) {
            midiBus.addMidiListener(midiListener);
        }
        return midiBus;
    }

    public int hashCode() {
        return this.bus_name.hashCode() + this.input_devices.hashCode() + this.output_devices.hashCode() + this.listeners.hashCode();
    }

    protected void finalize() {
        this.close();
        if (this.parent instanceof PApplet) {
            ((PApplet)this.parent).unregisterDispose((Object)this);
        }
    }

    public void close() {
        this.closeAllMidiDevices();
    }

    public void stop() {
        this.close();
    }

    public void dispose() {
        this.close();
    }

    public static void list() {
        int n;
        String[] stringArray = MidiBus.availableInputs();
        String[] stringArray2 = MidiBus.availableOutputs();
        String[] stringArray3 = MidiBus.unavailableDevices();
        if (stringArray.length == 0 && stringArray2.length == 0 && stringArray3.length == 0) {
            return;
        }
        System.out.println("\nAvailable MIDI Devices:");
        if (stringArray.length != 0) {
            System.out.println("----------Input----------");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println("[" + n + "] \"" + stringArray[n] + "\"");
            }
        }
        if (stringArray2.length != 0) {
            System.out.println("----------Output----------");
            for (n = 0; n < stringArray2.length; ++n) {
                System.out.println("[" + n + "] \"" + stringArray2[n] + "\"");
            }
        }
        if (stringArray3.length != 0) {
            System.out.println("----------Unavailable----------");
            for (n = 0; n < stringArray3.length; ++n) {
                System.out.println("[" + n + "] \"" + stringArray3[n] + "\"");
            }
        }
    }

    public static void findMidiDevices() {
        available_devices = MidiSystem.getMidiDeviceInfo();
    }

    public static String[] availableInputs() {
        MidiDevice.Info[] infoArray = MidiBus.availableInputsMidiDeviceInfo();
        String[] stringArray = new String[infoArray.length];
        for (int i = 0; i < infoArray.length; ++i) {
            stringArray[i] = infoArray[i].getName();
        }
        return stringArray;
    }

    public static String[] availableOutputs() {
        MidiDevice.Info[] infoArray = MidiBus.availableOutputsMidiDeviceInfo();
        String[] stringArray = new String[infoArray.length];
        for (int i = 0; i < infoArray.length; ++i) {
            stringArray[i] = infoArray[i].getName();
        }
        return stringArray;
    }

    public static String[] unavailableDevices() {
        MidiDevice.Info[] infoArray = MidiBus.unavailableMidiDeviceInfo();
        String[] stringArray = new String[infoArray.length];
        for (int i = 0; i < infoArray.length; ++i) {
            stringArray[i] = infoArray[i].getName();
        }
        return stringArray;
    }

    static MidiDevice.Info[] availableInputsMidiDeviceInfo() {
        if (available_devices == null) {
            MidiBus.findMidiDevices();
        }
        Vector<MidiDevice.Info> vector = new Vector<MidiDevice.Info>();
        for (int i = 0; i < available_devices.length; ++i) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(available_devices[i]);
                if (midiDevice.getMaxTransmitters() == 0) continue;
                vector.add(available_devices[i]);
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        MidiDevice.Info[] infoArray = new MidiDevice.Info[vector.size()];
        vector.toArray(infoArray);
        return infoArray;
    }

    static MidiDevice.Info[] availableOutputsMidiDeviceInfo() {
        if (available_devices == null) {
            MidiBus.findMidiDevices();
        }
        Vector<MidiDevice.Info> vector = new Vector<MidiDevice.Info>();
        for (int i = 0; i < available_devices.length; ++i) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(available_devices[i]);
                if (midiDevice.getMaxReceivers() == 0) continue;
                vector.add(available_devices[i]);
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        MidiDevice.Info[] infoArray = new MidiDevice.Info[vector.size()];
        vector.toArray(infoArray);
        return infoArray;
    }

    static MidiDevice.Info[] unavailableMidiDeviceInfo() {
        if (available_devices == null) {
            MidiBus.findMidiDevices();
        }
        Vector<MidiDevice.Info> vector = new Vector<MidiDevice.Info>();
        for (int i = 0; i < available_devices.length; ++i) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(available_devices[i]);
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                vector.add(available_devices[i]);
            }
        }
        MidiDevice.Info[] infoArray = new MidiDevice.Info[vector.size()];
        vector.toArray(infoArray);
        return infoArray;
    }

    private class OutputDeviceContainer {
        MidiDevice.Info info;
        Receiver receiver;

        OutputDeviceContainer(MidiDevice midiDevice) {
            this.info = midiDevice.getDeviceInfo();
        }

        public boolean equals(Object object) {
            return object instanceof OutputDeviceContainer && ((OutputDeviceContainer)object).info.getName().equals(this.info.getName());
        }

        public int hashCode() {
            return this.info.getName().hashCode();
        }
    }

    private class InputDeviceContainer {
        MidiDevice.Info info;
        Transmitter transmitter;
        Receiver receiver;

        InputDeviceContainer(MidiDevice midiDevice) {
            this.info = midiDevice.getDeviceInfo();
        }

        public boolean equals(Object object) {
            return object instanceof InputDeviceContainer && ((InputDeviceContainer)object).info.getName().equals(this.info.getName());
        }

        public int hashCode() {
            return this.info.getName().hashCode();
        }
    }

    private class MReceiver
    implements Receiver {
        MReceiver() {
        }

        @Override
        public void close() {
        }

        @Override
        public void send(MidiMessage midiMessage, long l) {
            if (midiMessage.getStatus() == 144 && midiMessage.getMessage()[2] == 0) {
                try {
                    ShortMessage shortMessage = (ShortMessage)midiMessage;
                    shortMessage.setMessage(128, shortMessage.getData1(), shortMessage.getData2());
                    midiMessage = shortMessage;
                }
                catch (Exception exception) {
                    System.err.println("\nThe MidiBus Warning: Mystery error during noteOn (0 velocity) to noteOff conversion");
                }
            }
            MidiBus.this.notifyListeners(midiMessage, l);
            MidiBus.this.notifyParent(midiMessage, l);
        }
    }
}

