/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class MarkerSegment
implements Cloneable {
    protected static final int LENGTH_SIZE = 2;
    int tag;
    int length;
    byte[] data = null;
    boolean unknown = false;

    MarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        jPEGBuffer.loadBuf(3);
        this.tag = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.length = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.length |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.length -= 2;
        jPEGBuffer.bufAvail -= 3;
        jPEGBuffer.loadBuf(this.length);
    }

    MarkerSegment(int n) {
        this.tag = n;
        this.length = 0;
    }

    MarkerSegment(Node node) throws IIOInvalidTreeException {
        this.tag = MarkerSegment.getAttributeValue(node, null, "MarkerTag", 0, 255, true);
        this.length = 0;
        if (node instanceof IIOMetadataNode) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
            try {
                this.data = (byte[])iIOMetadataNode.getUserObject();
            }
            catch (Exception exception) {
                IIOInvalidTreeException iIOInvalidTreeException = new IIOInvalidTreeException("Can't get User Object", node);
                iIOInvalidTreeException.initCause(exception);
                throw iIOInvalidTreeException;
            }
        } else {
            throw new IIOInvalidTreeException("Node must have User Object", node);
        }
    }

    protected Object clone() {
        MarkerSegment markerSegment = null;
        try {
            markerSegment = (MarkerSegment)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.data != null) {
            markerSegment.data = (byte[])this.data.clone();
        }
        return markerSegment;
    }

    void loadData(JPEGBuffer jPEGBuffer) throws IOException {
        this.data = new byte[this.length];
        jPEGBuffer.readData(this.data);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("unknown");
        iIOMetadataNode.setAttribute("MarkerTag", Integer.toString(this.tag));
        iIOMetadataNode.setUserObject(this.data);
        return iIOMetadataNode;
    }

    static int getAttributeValue(Node node, NamedNodeMap namedNodeMap, String string, int n, int n2, boolean bl) throws IIOInvalidTreeException {
        if (namedNodeMap == null) {
            namedNodeMap = node.getAttributes();
        }
        String string2 = namedNodeMap.getNamedItem(string).getNodeValue();
        int n3 = -1;
        if (string2 == null) {
            if (bl) {
                throw new IIOInvalidTreeException(string + " attribute not found", node);
            }
        } else {
            n3 = Integer.parseInt(string2);
            if (n3 < n || n3 > n2) {
                throw new IIOInvalidTreeException(string + " attribute out of range", node);
            }
        }
        return n3;
    }

    void writeTag(ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.write(255);
        imageOutputStream.write(this.tag);
        MarkerSegment.write2bytes(imageOutputStream, this.length);
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
        this.length = 2 + (this.data != null ? this.data.length : 0);
        this.writeTag(imageOutputStream);
        if (this.data != null) {
            imageOutputStream.write(this.data);
        }
    }

    static void write2bytes(ImageOutputStream imageOutputStream, int n) throws IOException {
        imageOutputStream.write(n >> 8 & 0xFF);
        imageOutputStream.write(n & 0xFF);
    }

    void printTag(String string) {
        System.out.println(string + " marker segment - marker = 0x" + Integer.toHexString(this.tag));
        System.out.println("length: " + this.length);
    }

    void print() {
        this.printTag("Unknown");
        if (this.length > 10) {
            int n;
            System.out.print("First 5 bytes:");
            for (n = 0; n < 5; ++n) {
                System.out.print(" Ox" + Integer.toHexString(this.data[n]));
            }
            System.out.print("\nLast 5 bytes:");
            for (n = this.data.length - 5; n < this.data.length; ++n) {
                System.out.print(" Ox" + Integer.toHexString(this.data[n]));
            }
        } else {
            System.out.print("Data:");
            for (int i = 0; i < this.data.length; ++i) {
                System.out.print(" Ox" + Integer.toHexString(this.data[i]));
            }
        }
        System.out.println();
    }
}

