/*
 * Decompiled with CFR 0.152.
 */
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.DropdownList;
import controlP5.Knob;
import controlP5.Textarea;
import de.humatic.mmj.MidiOutput;
import de.humatic.mmj.MidiSystem;
import processing.core.PApplet;

public class PocketMikuEffector
extends PApplet {
    int period = 0;
    ControlP5 cp5;
    DropdownList reverb;
    DropdownList chorus;
    DropdownList variation;
    DropdownList vibrato;
    Knob reverbDepth;
    Knob chorusDepth;
    Knob variationSend;
    Knob variationReturn;
    Knob vibratoRate;
    Knob vibratoDelayMSB;
    Knob vibratoDelayLSB;
    Knob pitchBend;
    Knob fineTuneMSB;
    Knob fineTuneLSB;
    Knob midiDev;
    Textarea logArea;
    MidiOutput mo_vocaloid;
    MidiSystem ms;
    byte[] rtype0;
    byte[] rtype1;
    byte[] rtype29;
    byte[] ctype0;
    byte[] ctype1;
    byte[] ctype16;
    byte[] ctype24;
    byte[] vtype0;
    byte[] vtype1;
    byte[] vtype30;
    byte[] vtype63;
    byte[] vtype70;
    byte[] vtype75;
    byte[] vtype118;
    byte[] vibtypeMSBAd;
    byte[] vibtypeLSBAd;
    byte[] vibtypeMSBData0;
    byte[] vibtypeMSBData1;
    byte[] vibtypeMSBData2;
    byte[] vibtypeMSBData3;
    byte[] setSysEffect;
    byte[] setInsEffect;

    public PocketMikuEffector() {
        byte[] byArray = new byte[10];
        byArray[0] = -16;
        byArray[1] = 67;
        byArray[2] = 16;
        byArray[3] = 76;
        byArray[4] = 2;
        byArray[5] = 1;
        byArray[9] = -9;
        this.rtype0 = byArray;
        byte[] byArray2 = new byte[10];
        byArray2[0] = -16;
        byArray2[1] = 67;
        byArray2[2] = 16;
        byArray2[3] = 76;
        byArray2[4] = 2;
        byArray2[5] = 1;
        byArray2[7] = 1;
        byArray2[9] = -9;
        this.rtype1 = byArray2;
        byte[] byArray3 = new byte[10];
        byArray3[0] = -16;
        byArray3[1] = 67;
        byArray3[2] = 16;
        byArray3[3] = 76;
        byArray3[4] = 2;
        byArray3[5] = 1;
        byArray3[7] = 19;
        byArray3[9] = -9;
        this.rtype29 = byArray3;
        byte[] byArray4 = new byte[10];
        byArray4[0] = -16;
        byArray4[1] = 67;
        byArray4[2] = 16;
        byArray4[3] = 76;
        byArray4[4] = 2;
        byArray4[5] = 1;
        byArray4[6] = 32;
        byArray4[9] = -9;
        this.ctype0 = byArray4;
        this.ctype1 = new byte[]{-16, 67, 16, 76, 2, 1, 32, 66, 17, -9};
        this.ctype16 = new byte[]{-16, 67, 16, 76, 2, 1, 32, 67, 8, -9};
        this.ctype24 = new byte[]{-16, 67, 16, 76, 2, 1, 32, 66, 18, -9};
        byte[] byArray5 = new byte[10];
        byArray5[0] = -16;
        byArray5[1] = 67;
        byArray5[2] = 16;
        byArray5[3] = 76;
        byArray5[4] = 2;
        byArray5[5] = 1;
        byArray5[6] = 64;
        byArray5[9] = -9;
        this.vtype0 = byArray5;
        byte[] byArray6 = new byte[10];
        byArray6[0] = -16;
        byArray6[1] = 67;
        byArray6[2] = 16;
        byArray6[3] = 76;
        byArray6[4] = 2;
        byArray6[5] = 1;
        byArray6[6] = 64;
        byArray6[7] = 1;
        byArray6[9] = -9;
        this.vtype1 = byArray6;
        this.vtype30 = new byte[]{-16, 67, 16, 76, 2, 1, 64, 67, 8, -9};
        this.vtype63 = new byte[]{-16, 67, 16, 76, 2, 1, 64, 5, 16, -9};
        byte[] byArray7 = new byte[10];
        byArray7[0] = -16;
        byArray7[1] = 67;
        byArray7[2] = 16;
        byArray7[3] = 76;
        byArray7[4] = 2;
        byArray7[5] = 1;
        byArray7[6] = 64;
        byArray7[7] = 72;
        byArray7[9] = -9;
        this.vtype70 = byArray7;
        byte[] byArray8 = new byte[10];
        byArray8[0] = -16;
        byArray8[1] = 67;
        byArray8[2] = 16;
        byArray8[3] = 76;
        byArray8[4] = 2;
        byArray8[5] = 1;
        byArray8[6] = 64;
        byArray8[7] = 73;
        byArray8[9] = -9;
        this.vtype75 = byArray8;
        this.vtype118 = new byte[]{-16, 67, 16, 76, 2, 1, 64, 80, 16, -9};
        this.vibtypeMSBAd = new byte[]{-80, 99, 112};
        this.vibtypeLSBAd = new byte[]{-80, 98, 3};
        byte[] byArray9 = new byte[3];
        byArray9[0] = -80;
        byArray9[1] = 6;
        this.vibtypeMSBData0 = byArray9;
        this.vibtypeMSBData1 = new byte[]{-80, 6, 1};
        this.vibtypeMSBData2 = new byte[]{-80, 6, 2};
        this.vibtypeMSBData3 = new byte[]{-80, 6, 3};
        this.setSysEffect = new byte[]{-16, 67, 16, 76, 2, 1, 90, 1, -9};
        byte[] byArray10 = new byte[9];
        byArray10[0] = -16;
        byArray10[1] = 67;
        byArray10[2] = 16;
        byArray10[3] = 76;
        byArray10[4] = 2;
        byArray10[5] = 1;
        byArray10[6] = 90;
        byArray10[8] = -9;
        this.setInsEffect = byArray10;
    }

    public void setup() {
        this.size(800, 600);
        this.cp5 = new ControlP5((PApplet)this);
        this.reverb = ((DropdownList)this.cp5.addDropdownList("REVERB TYPE").setPosition(50.0f, 50.0f)).setSize(100, 100);
        this.customize(this.reverb);
        this.addItemReverb(this.reverb);
        this.chorus = ((DropdownList)this.cp5.addDropdownList("CHORUS TYPE").setPosition(200.0f, 50.0f)).setSize(100, 100);
        this.customize(this.chorus);
        this.addItemChorus(this.chorus);
        this.variation = ((DropdownList)this.cp5.addDropdownList("VARIATION TYPE").setPosition(350.0f, 50.0f)).setSize(100, 100);
        this.customize(this.variation);
        this.addItemVariation(this.variation);
        this.vibrato = ((DropdownList)this.cp5.addDropdownList("VIBRATO TYPE").setPosition(500.0f, 50.0f)).setSize(100, 100);
        this.customize(this.vibrato);
        this.addItemVibrato(this.vibrato);
        this.reverbDepth = (Knob)this.cp5.addKnob("REVERB_DEPTH").setRange(0.0f, 127.0f).setNumberOfTickMarks(10).setValue(64.0f).setPosition(60.0f, 150.0f);
        this.customizeKnob(this.reverbDepth);
        this.chorusDepth = (Knob)this.cp5.addKnob("CHORUS_DEPTH").setRange(0.0f, 127.0f).setNumberOfTickMarks(10).setValue(64.0f).setPosition(210.0f, 150.0f);
        this.customizeKnob(this.chorusDepth);
        this.variationSend = (Knob)this.cp5.addKnob("VARIATION_SEND").setRange(0.0f, 127.0f).setNumberOfTickMarks(10).setValue(0.0f).setPosition(360.0f, 150.0f);
        this.customizeKnob(this.variationSend);
        this.variationReturn = (Knob)this.cp5.addKnob("VARIATION_RETURN").setRange(0.0f, 127.0f).setNumberOfTickMarks(10).setValue(64.0f).setPosition(360.0f, 250.0f);
        this.customizeKnob(this.variationReturn);
        this.vibratoRate = (Knob)this.cp5.addKnob("VIBRATO_RATE").setRange(0.0f, 127.0f).setNumberOfTickMarks(10).setValue(64.0f).setPosition(510.0f, 150.0f);
        this.customizeKnob(this.vibratoRate);
        this.vibratoDelayMSB = (Knob)this.cp5.addKnob("VIBRATO_DELAY1").setRange(0.0f, 6.0f).setNumberOfTickMarks(6).setValue(0.0f).setPosition(510.0f, 250.0f);
        this.customizeKnob(this.vibratoDelayMSB);
        this.vibratoDelayLSB = (Knob)this.cp5.addKnob("VIBRATO_DELAY2").setRange(0.0f, 127.0f).setNumberOfTickMarks(10).setValue(0.0f).setPosition(510.0f, 350.0f);
        this.customizeKnob(this.vibratoDelayLSB);
        this.pitchBend = (Knob)this.cp5.addKnob("PITCH_BEND").setRange(0.0f, 24.0f).setNumberOfTickMarks(24).setValue(16.0f).setPosition(660.0f, 150.0f);
        this.customizeKnob(this.pitchBend);
        this.fineTuneMSB = (Knob)this.cp5.addKnob("FINE_TUNE1").setRange(0.0f, 127.0f).setNumberOfTickMarks(10).setValue(64.0f).setPosition(660.0f, 250.0f);
        this.customizeKnob(this.fineTuneMSB);
        this.fineTuneLSB = (Knob)this.cp5.addKnob("FINE_TUNE2").setRange(0.0f, 127.0f).setNumberOfTickMarks(10).setValue(0.0f).setPosition(660.0f, 350.0f);
        this.customizeKnob(this.fineTuneLSB);
        this.logArea = (Textarea)((Textarea)this.cp5.addTextarea("log").setPosition(625.0f, 30.0f)).setSize(155, 60).setFont(this.createFont("Helvetica", 14.0f)).setLineHeight(14).setColor(this.color(255, 255, 255)).setColorBackground(this.color(160, 0, 0)).setColorForeground(this.color(60));
        this.detectMidiDevices();
    }

    public void customizeKnob(Knob knob) {
        knob.setRadius(30.0f);
        knob.setTickMarkLength(4);
        knob.snapToTickMarks(true);
        knob.setColorForeground(this.color(200));
        knob.setColorBackground(this.color(0, 160, 100));
        knob.setColorActive(this.color(255, 255, 0));
        knob.setColorCaptionLabel(this.color(0, 160, 0));
        knob.setDragDirection(0);
    }

    public void customize(DropdownList dropdownList) {
        dropdownList.setBackgroundColor(this.color(190));
        dropdownList.setItemHeight(20);
        dropdownList.setBarHeight(15);
        dropdownList.captionLabel().style().marginTop = 3;
        dropdownList.captionLabel().style().marginLeft = 3;
        dropdownList.valueLabel().style().marginTop = 3;
        dropdownList.setColorBackground(this.color(60));
        dropdownList.setColorActive(this.color(255, 128));
    }

    public void addItemReverb(DropdownList dropdownList) {
        dropdownList.captionLabel().set("REVERB TYPE");
        dropdownList.addItem("OFF", 0);
        dropdownList.addItem("HALL1", 1);
        dropdownList.addItem("BASEMENT", 29);
    }

    public void addItemChorus(DropdownList dropdownList) {
        dropdownList.captionLabel().set("CHORUS TYPE");
        dropdownList.addItem("OFF", 0);
        dropdownList.addItem("CHORUS1", 1);
        dropdownList.addItem("FLANGER1", 16);
        dropdownList.addItem("ROTARY SP5", 24);
    }

    public void addItemVariation(DropdownList dropdownList) {
        dropdownList.captionLabel().set("VARIATION TYPE");
        dropdownList.addItem("OFF", 0);
        dropdownList.addItem("HALL1", 1);
        dropdownList.addItem("DELAY LCR1", 30);
        dropdownList.addItem("FLANGER1", 63);
        dropdownList.addItem("PHASER1", 70);
        dropdownList.addItem("DIST HEAVY", 75);
        dropdownList.addItem("PITCH CHG1", 118);
    }

    public void addItemVibrato(DropdownList dropdownList) {
        dropdownList.captionLabel().set("VIBRATO TYPE");
        dropdownList.addItem("NORMAL", 2);
        dropdownList.addItem("SLIGHT", 3);
        dropdownList.addItem("FAST", 1);
        dropdownList.addItem("EXTREME", 0);
    }

    public void draw() {
        this.background(255);
    }

    public void keyPressed() {
    }

    public void detectMidiDevices() {
        String[] stringArray = MidiSystem.getOutputs();
        String string = "NSX-39  - NSX-39 ";
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < MidiSystem.getNumberOfOutputs()) {
            PocketMikuEffector.println((int)n2);
            PocketMikuEffector.println((String)stringArray[n2]);
            if (stringArray[n2].equals(string)) {
                PocketMikuEffector.println((String)"NSX-39 OK");
                n = n2;
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            this.logArea.setText("NSX-39 is connected. Channel is " + n);
            this.logArea.setColorBackground(this.color(0, 0, 160));
        } else {
            this.logArea.setText("NSX-39 is not found");
            this.logArea.setColorBackground(this.color(160, 0, 0));
        }
        this.mo_vocaloid = MidiSystem.openMidiOutput((int)0);
        this.mo_vocaloid = MidiSystem.openMidiOutput((int)n);
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.isGroup()) {
            if (controlEvent.getGroup().getName() == "REVERB TYPE") {
                switch (PApplet.parseInt((float)controlEvent.getGroup().getValue())) {
                    case 0: {
                        this.mo_vocaloid.sendMidi(this.rtype0);
                        break;
                    }
                    case 1: {
                        this.mo_vocaloid.sendMidi(this.rtype1);
                        break;
                    }
                    case 29: {
                        this.mo_vocaloid.sendMidi(this.rtype29);
                        break;
                    }
                    default: {
                        this.mo_vocaloid.sendMidi(this.rtype0);
                    }
                }
            }
            if (controlEvent.getGroup().getName() == "CHORUS TYPE") {
                switch (PApplet.parseInt((float)controlEvent.getGroup().getValue())) {
                    case 0: {
                        this.mo_vocaloid.sendMidi(this.ctype0);
                        break;
                    }
                    case 1: {
                        this.mo_vocaloid.sendMidi(this.ctype1);
                        break;
                    }
                    case 16: {
                        this.mo_vocaloid.sendMidi(this.ctype16);
                        break;
                    }
                    case 24: {
                        this.mo_vocaloid.sendMidi(this.ctype24);
                        break;
                    }
                    default: {
                        this.mo_vocaloid.sendMidi(this.ctype0);
                    }
                }
            }
            if (controlEvent.getGroup().getName() == "VARIATION TYPE") {
                switch (PApplet.parseInt((float)controlEvent.getGroup().getValue())) {
                    case 0: {
                        this.mo_vocaloid.sendMidi(this.setInsEffect);
                        break;
                    }
                    case 1: {
                        this.mo_vocaloid.sendMidi(this.setSysEffect);
                        this.mo_vocaloid.sendMidi(this.vtype1);
                        break;
                    }
                    case 30: {
                        this.mo_vocaloid.sendMidi(this.setSysEffect);
                        this.mo_vocaloid.sendMidi(this.vtype30);
                        break;
                    }
                    case 63: {
                        this.mo_vocaloid.sendMidi(this.setSysEffect);
                        this.mo_vocaloid.sendMidi(this.vtype63);
                        break;
                    }
                    case 70: {
                        this.mo_vocaloid.sendMidi(this.setSysEffect);
                        this.mo_vocaloid.sendMidi(this.vtype70);
                        break;
                    }
                    case 75: {
                        this.mo_vocaloid.sendMidi(this.setSysEffect);
                        this.mo_vocaloid.sendMidi(this.vtype75);
                        break;
                    }
                    case 118: {
                        this.mo_vocaloid.sendMidi(this.setSysEffect);
                        this.mo_vocaloid.sendMidi(this.vtype118);
                        break;
                    }
                    default: {
                        this.mo_vocaloid.sendMidi(this.setSysEffect);
                        this.mo_vocaloid.sendMidi(this.vtype0);
                    }
                }
            }
            if (controlEvent.getGroup().getName() == "VIBRATO TYPE") {
                switch (PApplet.parseInt((float)controlEvent.getGroup().getValue())) {
                    case 0: {
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeLSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBData0);
                        break;
                    }
                    case 1: {
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeLSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBData1);
                        break;
                    }
                    case 2: {
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeLSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBData2);
                        break;
                    }
                    case 3: {
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeLSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBData3);
                        break;
                    }
                    default: {
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeLSBAd);
                        this.mo_vocaloid.sendMidi(this.vibtypeMSBData2);
                    }
                }
            }
        }
    }

    public void REVERB_DEPTH(int n) {
        this.mo_vocaloid.sendMidi(new byte[]{-80, 91, (byte)n});
    }

    public void CHORUS_DEPTH(int n) {
        this.mo_vocaloid.sendMidi(new byte[]{-80, 93, (byte)n});
    }

    public void VARIATION_SEND(int n) {
        this.mo_vocaloid.sendMidi(new byte[]{-80, 94, (byte)n});
    }

    public void VARIATION_RETURN(int n) {
        this.mo_vocaloid.sendMidi(new byte[]{-16, 67, 16, 76, 2, 1, 86, (byte)n, -9});
    }

    public void VIBRATO_RATE(int n) {
        this.mo_vocaloid.sendMidi(new byte[]{-80, 99, 112});
        this.mo_vocaloid.sendMidi(new byte[]{-80, 98, 4});
        this.mo_vocaloid.sendMidi(new byte[]{-80, 6, (byte)n});
    }

    public void VIBRATO_DELAY1(int n) {
        this.mo_vocaloid.sendMidi(new byte[]{-80, 99, 112});
        this.mo_vocaloid.sendMidi(new byte[]{-80, 98, 7});
        this.mo_vocaloid.sendMidi(new byte[]{-80, 6, (byte)n});
    }

    public void VIBRATO_DELAY2(int n) {
        this.mo_vocaloid.sendMidi(new byte[]{-80, 99, 112});
        this.mo_vocaloid.sendMidi(new byte[]{-80, 98, 7});
        this.mo_vocaloid.sendMidi(new byte[]{-80, 38, (byte)n});
    }

    public void PITCH_BEND(int n) {
        byte[] byArray = new byte[3];
        byArray[0] = -80;
        byArray[1] = 101;
        this.mo_vocaloid.sendMidi(byArray);
        byte[] byArray2 = new byte[3];
        byArray2[0] = -80;
        byArray2[1] = 100;
        this.mo_vocaloid.sendMidi(byArray2);
        this.mo_vocaloid.sendMidi(new byte[]{-80, 6, (byte)n});
    }

    public void FINE_TUNE1(int n) {
        byte[] byArray = new byte[3];
        byArray[0] = -80;
        byArray[1] = 101;
        this.mo_vocaloid.sendMidi(byArray);
        this.mo_vocaloid.sendMidi(new byte[]{-80, 100, 1});
        this.mo_vocaloid.sendMidi(new byte[]{-80, 6, (byte)n});
    }

    public void FINE_TUNE2(int n) {
        byte[] byArray = new byte[3];
        byArray[0] = -80;
        byArray[1] = 101;
        this.mo_vocaloid.sendMidi(byArray);
        this.mo_vocaloid.sendMidi(new byte[]{-80, 100, 1});
        this.mo_vocaloid.sendMidi(new byte[]{-80, 38, (byte)n});
    }

    public void exit() {
        this.mo_vocaloid.close();
        super.exit();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"PocketMikuEffector"};
        if (stringArray != null) {
            PApplet.main((String[])PocketMikuEffector.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }
}

