package test;

import poi.support.StringUtil;

public class StringUtilTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		System.out.println("--- replaceAll");

		System.out.println("abcdefg12345abcdefg".replaceAll("cde", "CDE"));
		System.out.println(StringUtil.replaceAll("abcdefg12345abcdefg", "cde",
				"CDE"));
		System.out.println("abcdefg12345abcdefg".replaceAll("cde", ""));
		System.out.println(StringUtil.replaceAll("abcdefg12345abcdefg", "cde",
				""));

		System.out.println("--- split(source, delim)");

		String[] ret;

		ret = "a/bc/def".split("/");
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = StringUtil.split("a/bc/def", "/");
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = "a\tbc\tdef".split("\t");
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = StringUtil.split("a\tbc\tdef", "\t");
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = "a bc def".split(" ");
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = StringUtil.split("a bc def", " ");
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		System.out.println("--- split(source, delim, limit)");

		ret = "aa,bc,,,def,,,,".split(",", 3);
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = StringUtil.split("aa,bc,,,def,,,,", ",", 3);
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = "aa,bc,,,def,,,,".split(",", 0);
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = StringUtil.split("aa,bc,,,def,,,,", ",", 0);
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = "aa,bc,,,def,,,,".split(",", -1);
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();

		ret = StringUtil.split("aa,bc,,,def,,,,", ",", -1);
		System.out.print("length=" + ret.length + " ");
		for (int i = 0; i < ret.length; i++) {
			System.out.print(i + "=" + ret[i] + " ");
		}
		System.out.println();
	}

}
