package test;

import java.util.Formatter;

import poi.support.POIFormatter;

public class POIFormatterUtilTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		int i1 = 12345;
		double v1 = 123.1415926535897932384626433832795028841971693;
		int i2 = 12345;
		String fmtStr = "--- d=%d, 3d=%3d, 03d=%03d, 9d=%9d, 09d=%09d, f=%f, .3f=%.3f, 1.9f=%1.9f, 12.3f=%012.3f, 012.3f=%012.3f, 1.0f=%1.0f, e=%e , .5e=%.5e, 1.5e=%1.5e, 12.3e=%12.3e, 012.3e=%012.3e, E=%E, .5E=%.5E, 1.5E=%1.5E, 12.3E=%12.3E, 012.3E=%012.3E, x=%x, 2x=%2x, 02x=%02x, 8x=%8x, 08x=%08x, %s, %5s ---%n---";
		Object[] values = new Object[] { new Long(i1), new Long(i1),
				new Long(i1), new Long(i1), new Long(i1), new Double(v1),
				new Double(v1), new Double(v1), new Double(v1), new Double(v1),
				new Double(v1), new Double(v1), new Double(v1), new Double(v1),
				new Double(v1), new Double(v1), new Double(v1), new Double(v1),
				new Double(v1), new Double(v1), new Double(v1), new Long(i2),
				new Long(i2), new Long(i2), new Long(i2), new Long(i2), "abc",
				"abc" };

		Formatter fmt15a = new Formatter(new StringBuffer());
		fmt15a.format(fmtStr, values);
		System.out.println("[java 1.5][a]" + fmt15a);

		POIFormatter fmt14a = new POIFormatter(new StringBuffer());
		fmt14a.format(fmtStr, values);
		System.out.println("[java 1.4][a]" + fmt14a);

		Formatter fmt15b = new Formatter(new StringBuffer());
		fmt15b.format(fmtStr, null);
		System.out.println("[java 1.5][b]" + fmt15b);

		POIFormatter fmt14b = new POIFormatter(new StringBuffer());
		fmt14b.format(fmtStr, null);
		System.out.println("[java 1.4][b]" + fmt14b);

		System.out.print("[java 1.5][c]");
		Formatter fmt15c = new Formatter(System.out);
		fmt15c.format(fmtStr, values);
		fmt15c.flush();
		// fmt15c.close();
		System.out.println("");

		System.out.print("[java 1.4][c]");
		POIFormatter fmt14c = new POIFormatter(System.out);
		fmt14c.format(fmtStr, values);
		fmt14c.flush();
		// fmt14c.close();
		System.out.println("");
	}
}
