package test;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import poi.support.NodeUtil;

public class NodeUtilTest {

	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {

		DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();

		Node html1 = doc.createElement("html");
		doc.appendChild(html1);
		Node head = doc.createElement("head");
		html1.appendChild(head);
		Node title = doc.createElement("title");
		head.appendChild(title);
		title.appendChild(doc.createTextNode("test2"));
		Node body = doc.createElement("body");
		html1.appendChild(body);
		body.appendChild(doc.createTextNode("_test2_"));
		Node button = doc.createElement("button");
		button.appendChild(doc.createTextNode("_button1_"));
		body.appendChild(button);

		Node html2 = html1.cloneNode(true);

		System.out.println("html1:" + html1.getTextContent());
		System.out.println("html2:" + NodeUtil.getTextContent(html2));

		String text = "add1<b><i>add2</i></b>";
		html1.getChildNodes().item(1).setTextContent(text);
		NodeUtil.setTextContent(html2.getChildNodes().item(1), text);

		System.out.println("html1:" + html1.getTextContent());
		System.out.println("html2:" + NodeUtil.getTextContent(html2));

	}

}
