package poi.support;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtil {

	private StringUtil() {
	}

	public static String replaceAll(String source, String target,
			String replacement) {
		StringBuffer sb = new StringBuffer(source);
		int repLen = target.length();
		int i = source.length();
		while (i >= 0) {
			i = source.lastIndexOf(target, i);
			if (i >= 0) {
				sb.replace(i, i + repLen, replacement);
				i--;
			}
		}
		return sb.toString();
	}

	public static String[] split(String source, String delim) {
		List list = new ArrayList();
		StringTokenizer st = new StringTokenizer(source, delim);
		while (st.hasMoreTokens()) {
			list.add(st.nextToken());
		}
		return (String[]) list.toArray(new String[0]);
	}

	public static String[] split(String source, String delim, int limit) {
		int index;
		int pos = 0;
		int delimLength = delim.length();
		List list = new ArrayList();
		if (limit > 0) {
			int i = limit - 1;
			while ((index = source.indexOf(delim, pos)) != -1 && i > 0) {
				list.add(source.substring(pos, index));
				pos = index + delimLength;
				i--;
			}
			list.add(source.substring(pos));
		} else if (limit < 0) {
			while ((index = source.indexOf(delim, pos)) != -1) {
				list.add(source.substring(pos, index));
				pos = index + delimLength;
			}
			list.add(source.substring(pos));
		} else {
			// limit = 0
			int len;
			int i = 0;
			int last = -1;

			while ((index = source.indexOf(delim, pos)) != -1) {
				String value = source.substring(pos, index);
				if (null != value && value.length() != 0) {
					last = i;
				}
				list.add(value);
				pos = index + delimLength;
				i++;
			}
			String value = source.substring(pos);
			if (null != value && value.length() != 0) {
				last = i;
			}
			list.add(value);
			if (last + 1 < list.size()) {
				pos = last + 1;
				for (i = pos, len = list.size(); i < len; i++) {
					list.remove(pos);
				}
			}
		}
		return (String[]) list.toArray(new String[0]);
	}
}
