/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */

package org.apache.poi.xwpf.usermodel;

import java.util.HashMap;
import java.util.Map;

/**
 * Specifies all types of alignment which are available to be applied to objects in a
 * WordprocessingML document
 *
 * @author Yegor Kozlov
 */
public class ParagraphAlignment {
    //YK: TODO document each alignment option

    public static final ParagraphAlignment LEFT = new ParagraphAlignment(1);
    public static final ParagraphAlignment CENTER = new ParagraphAlignment(2);
    public static final ParagraphAlignment RIGHT = new ParagraphAlignment(3);
    public static final ParagraphAlignment BOTH = new ParagraphAlignment(4);
    public static final ParagraphAlignment MEDIUM_KASHIDA = new ParagraphAlignment(5);
    public static final ParagraphAlignment DISTRIBUTE = new ParagraphAlignment(6);
    public static final ParagraphAlignment NUM_TAB = new ParagraphAlignment(7);
    public static final ParagraphAlignment HIGH_KASHIDA = new ParagraphAlignment(8);
    public static final ParagraphAlignment LOW_KASHIDA = new ParagraphAlignment(9);
    public static final ParagraphAlignment THAI_DISTRIBUTE = new ParagraphAlignment(10);

    private final int value;

    private ParagraphAlignment(int val){
        value = val;
    }

    public int getValue(){
        return value;
    }

    private static Map imap = new HashMap();
    static{
    	for (int i = 0; i < values().length; i++) {
			ParagraphAlignment p = values()[i];
            imap.put(new Integer(p.getValue()), p);
        }
    }

    public static ParagraphAlignment valueOf(int type){
        ParagraphAlignment err = (ParagraphAlignment) imap.get(new Integer(type));
        if(err == null) throw new IllegalArgumentException("Unknown paragraph alignment: " + type);
        return err;
    }

	public static ParagraphAlignment[] values() {
		return new ParagraphAlignment[] { LEFT, CENTER, RIGHT, BOTH,
				MEDIUM_KASHIDA, DISTRIBUTE, NUM_TAB, HIGH_KASHIDA, LOW_KASHIDA,
				THAI_DISTRIBUTE };
	}
}
