/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xslf.usermodel.XSLFTableStyle;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableStyleList;
import poi.support.Iterable;

public class XSLFTableStyles
extends POIXMLDocumentPart
implements Iterable {
    private CTTableStyleList _tblStyleLst;
    private List _styles;

    public XSLFTableStyles() {
    }

    public XSLFTableStyles(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        this._tblStyleLst = CTTableStyleList.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._styles = new ArrayList(this._tblStyleLst.sizeOfTblStyleArray());
        Iterator<CTTableStyle> iterator = Arrays.asList(this._tblStyleLst.getTblStyleArray()).iterator();
        while (iterator.hasNext()) {
            CTTableStyle c = iterator.next();
            this._styles.add(new XSLFTableStyle(c));
        }
    }

    public CTTableStyleList getXmlObject() {
        return this._tblStyleLst;
    }

    public Iterator iterator() {
        return this._styles.iterator();
    }

    public List getStyles() {
        return Collections.unmodifiableList(this._styles);
    }
}

