/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.format.CellFormatType;
import org.apache.poi.ss.format.CellFormatter;
import org.apache.poi.ss.format.CellTextFormatter;
import poi.support.POIFormatter;

public class CellNumberFormatter
extends CellFormatter {
    private final String desc;
    private String printfFmt;
    private double scale = 1.0;
    private Special decimalPoint;
    private Special slash;
    private Special exponent;
    private Special numerator;
    private Special afterInteger;
    private Special afterFractional;
    private boolean integerCommas;
    private final List specials = new LinkedList();
    private List integerSpecials;
    private List fractionalSpecials;
    private List numeratorSpecials;
    private List denominatorSpecials;
    private List exponentSpecials;
    private List exponentDigitSpecials;
    private int maxDenominator;
    private String numeratorFmt;
    private String denominatorFmt;
    private boolean improperFraction;
    private DecimalFormat decimalFmt;
    static final CellFormatter SIMPLE_NUMBER = new CellFormatter("General"){

        public void formatValue(StringBuffer toAppendTo, Object value) {
            if (value == null) {
                return;
            }
            if (value instanceof Number) {
                Number num = (Number)value;
                if (num.doubleValue() % 1.0 == 0.0) {
                    SIMPLE_INT.formatValue(toAppendTo, value);
                } else {
                    SIMPLE_FLOAT.formatValue(toAppendTo, value);
                }
            } else {
                CellTextFormatter.SIMPLE_TEXT.formatValue(toAppendTo, value);
            }
        }

        public void simpleValue(StringBuffer toAppendTo, Object value) {
            this.formatValue(toAppendTo, value);
        }
    };
    private static final CellFormatter SIMPLE_INT = new CellNumberFormatter("#");
    private static final CellFormatter SIMPLE_FLOAT = new CellNumberFormatter("#.#");

    public CellNumberFormatter(String format) {
        super(format);
        int precision;
        NumPartHandler partHandler = new NumPartHandler();
        StringBuffer descBuf = CellFormatPart.parseFormat(format, CellFormatType.NUMBER, partHandler);
        if ((this.decimalPoint != null || this.exponent != null) && this.slash != null) {
            this.slash = null;
            this.numerator = null;
        }
        this.interpretCommas(descBuf);
        int fractionPartWidth = 0;
        if (this.decimalPoint == null) {
            precision = 0;
        } else {
            precision = this.interpretPrecision();
            fractionPartWidth = 1 + precision;
            if (precision == 0) {
                this.specials.remove(this.decimalPoint);
                this.decimalPoint = null;
            }
        }
        this.fractionalSpecials = precision == 0 ? Collections.EMPTY_LIST : this.specials.subList(this.specials.indexOf(this.decimalPoint) + 1, this.fractionalEnd());
        if (this.exponent == null) {
            this.exponentSpecials = Collections.EMPTY_LIST;
        } else {
            int exponentPos = this.specials.indexOf(this.exponent);
            this.exponentSpecials = this.specialsFor(exponentPos, 2);
            this.exponentDigitSpecials = this.specialsFor(exponentPos + 2);
        }
        if (this.slash == null) {
            this.numeratorSpecials = Collections.EMPTY_LIST;
            this.denominatorSpecials = Collections.EMPTY_LIST;
        } else {
            this.numeratorSpecials = this.numerator == null ? Collections.EMPTY_LIST : this.specialsFor(this.specials.indexOf(this.numerator));
            this.denominatorSpecials = this.specialsFor(this.specials.indexOf(this.slash) + 1);
            if (this.denominatorSpecials.isEmpty()) {
                this.numeratorSpecials = Collections.EMPTY_LIST;
            } else {
                this.maxDenominator = CellNumberFormatter.maxValue(this.denominatorSpecials);
                this.numeratorFmt = CellNumberFormatter.singleNumberFormat(this.numeratorSpecials);
                this.denominatorFmt = CellNumberFormatter.singleNumberFormat(this.denominatorSpecials);
            }
        }
        this.integerSpecials = this.specials.subList(0, this.integerEnd());
        if (this.exponent == null) {
            StringBuffer fmtBuf = new StringBuffer("%");
            int integerPartWidth = this.calculateIntegerPartWidth();
            int totalWidth = integerPartWidth + fractionPartWidth;
            fmtBuf.append('0').append(totalWidth).append('.').append(precision);
            fmtBuf.append("f");
            this.printfFmt = fmtBuf.toString();
        } else {
            Special s;
            Iterator iterator;
            StringBuffer fmtBuf = new StringBuffer();
            boolean first = true;
            List specialList = this.integerSpecials;
            if (this.integerSpecials.size() == 1) {
                fmtBuf.append("0");
                first = false;
            } else {
                iterator = specialList.iterator();
                while (iterator.hasNext()) {
                    s = (Special)iterator.next();
                    if (!CellNumberFormatter.isDigitFmt(s)) continue;
                    fmtBuf.append(first ? (char)'#' : '0');
                    first = false;
                }
            }
            if (this.fractionalSpecials.size() > 0) {
                fmtBuf.append('.');
                iterator = this.fractionalSpecials.iterator();
                while (iterator.hasNext()) {
                    s = (Special)iterator.next();
                    if (!CellNumberFormatter.isDigitFmt(s)) continue;
                    if (!first) {
                        fmtBuf.append('0');
                    }
                    first = false;
                }
            }
            fmtBuf.append('E');
            CellNumberFormatter.placeZeros(fmtBuf, this.exponentSpecials.subList(2, this.exponentSpecials.size()));
            this.decimalFmt = new DecimalFormat(fmtBuf.toString());
        }
        if (this.exponent != null) {
            this.scale = 1.0;
        }
        this.desc = descBuf.toString();
    }

    private static void placeZeros(StringBuffer sb, List specials) {
        Iterator iterator = specials.iterator();
        while (iterator.hasNext()) {
            Special s = (Special)iterator.next();
            if (!CellNumberFormatter.isDigitFmt(s)) continue;
            sb.append('0');
        }
    }

    private static Special firstDigit(List specials) {
        Iterator iterator = specials.iterator();
        while (iterator.hasNext()) {
            Special s = (Special)iterator.next();
            if (!CellNumberFormatter.isDigitFmt(s)) continue;
            return s;
        }
        return null;
    }

    static StringMod insertMod(Special special, CharSequence toAdd, int where) {
        return new StringMod(special, toAdd, where);
    }

    static StringMod deleteMod(Special start, boolean startInclusive, Special end, boolean endInclusive) {
        return new StringMod(start, startInclusive, end, endInclusive);
    }

    static StringMod replaceMod(Special start, boolean startInclusive, Special end, boolean endInclusive, char withChar) {
        return new StringMod(start, startInclusive, end, endInclusive, withChar);
    }

    private static String singleNumberFormat(List numSpecials) {
        return "%0" + numSpecials.size() + "d";
    }

    private static int maxValue(List s) {
        return (int)Math.round(Math.pow(10.0, s.size()) - 1.0);
    }

    private List specialsFor(int pos, int takeFirst) {
        if (pos >= this.specials.size()) {
            return Collections.EMPTY_LIST;
        }
        ListIterator it = this.specials.listIterator(pos + takeFirst);
        Special last = (Special)it.next();
        int end = pos + takeFirst;
        while (it.hasNext()) {
            Special s = (Special)it.next();
            if (!CellNumberFormatter.isDigitFmt(s) || s.pos - last.pos > 1) break;
            ++end;
            last = s;
        }
        return this.specials.subList(pos, end + 1);
    }

    private List specialsFor(int pos) {
        return this.specialsFor(pos, 0);
    }

    private static boolean isDigitFmt(Special s) {
        return s.ch == '0' || s.ch == '?' || s.ch == '#';
    }

    private Special previousNumber() {
        ListIterator it = this.specials.listIterator(this.specials.size());
        while (it.hasPrevious()) {
            Special s = (Special)it.previous();
            if (!CellNumberFormatter.isDigitFmt(s)) continue;
            Special numStart = s;
            Special last = s;
            while (it.hasPrevious()) {
                s = (Special)it.previous();
                if (last.pos - s.pos > 1 || !CellNumberFormatter.isDigitFmt(s)) break;
                numStart = s;
                last = s;
            }
            return numStart;
        }
        return null;
    }

    private int calculateIntegerPartWidth() {
        ListIterator it = this.specials.listIterator();
        int digitCount = 0;
        while (it.hasNext()) {
            Special s = (Special)it.next();
            if (s == this.afterInteger) break;
            if (!CellNumberFormatter.isDigitFmt(s)) continue;
            ++digitCount;
        }
        return digitCount;
    }

    private int interpretPrecision() {
        if (this.decimalPoint == null) {
            return -1;
        }
        int precision = 0;
        ListIterator it = this.specials.listIterator(this.specials.indexOf(this.decimalPoint));
        if (it.hasNext()) {
            it.next();
        }
        while (it.hasNext()) {
            Special s = (Special)it.next();
            if (!CellNumberFormatter.isDigitFmt(s)) break;
            ++precision;
        }
        return precision;
    }

    private void interpretCommas(StringBuffer sb) {
        Special s;
        ListIterator it = this.specials.listIterator(this.integerEnd());
        boolean stillScaling = true;
        this.integerCommas = false;
        while (it.hasPrevious()) {
            s = (Special)it.previous();
            if (s.ch != ',') {
                stillScaling = false;
                continue;
            }
            if (stillScaling) {
                this.scale /= 1000.0;
                continue;
            }
            this.integerCommas = true;
        }
        if (this.decimalPoint != null) {
            it = this.specials.listIterator(this.fractionalEnd());
            while (it.hasPrevious()) {
                s = (Special)it.previous();
                if (s.ch != ',') break;
                this.scale /= 1000.0;
            }
        }
        it = this.specials.listIterator();
        int removed = 0;
        while (it.hasNext()) {
            Special s2 = (Special)it.next();
            s2.pos -= removed;
            if (s2.ch != ',') continue;
            ++removed;
            it.remove();
            sb.deleteCharAt(s2.pos);
        }
    }

    private int integerEnd() {
        this.afterInteger = this.decimalPoint != null ? this.decimalPoint : (this.exponent != null ? this.exponent : (this.numerator != null ? this.numerator : null));
        return this.afterInteger == null ? this.specials.size() : this.specials.indexOf(this.afterInteger);
    }

    private int fractionalEnd() {
        if (this.exponent != null) {
            this.afterFractional = this.exponent;
        } else if (this.numerator != null) {
            this.afterInteger = this.numerator;
        } else {
            this.afterFractional = null;
        }
        int end = this.afterFractional == null ? this.specials.size() : this.specials.indexOf(this.afterFractional);
        return end;
    }

    public void formatValue(StringBuffer toAppendTo, Object valueObject) {
        boolean negative;
        double value = ((Number)valueObject).doubleValue();
        boolean bl = negative = (value *= this.scale) < 0.0;
        if (negative) {
            value = -value;
        }
        double fractional = 0.0;
        if (this.slash != null) {
            if (this.improperFraction) {
                fractional = value;
                value = 0.0;
            } else {
                fractional = value % 1.0;
                value = (long)value;
            }
        }
        TreeSet mods = new TreeSet();
        StringBuffer output = new StringBuffer(this.desc);
        if (this.exponent != null) {
            this.writeScientific(value, output, mods);
        } else if (this.improperFraction) {
            this.writeFraction(value, null, fractional, output, mods);
        } else {
            StringBuffer result = new StringBuffer();
            POIFormatter f = new POIFormatter(result);
            f.format(this.printfFmt, new Object[]{new Double(value)});
            if (this.numerator == null) {
                this.writeFractional(result, output);
                this.writeInteger(result, output, this.integerSpecials, mods, this.integerCommas);
            } else {
                this.writeFraction(value, result, fractional, output, mods);
            }
        }
        ListIterator it = this.specials.listIterator();
        Iterator changes = mods.iterator();
        StringMod nextChange = changes.hasNext() ? changes.next() : null;
        int adjust = 0;
        BitSet deletedChars = new BitSet();
        while (it.hasNext()) {
            Special s = (Special)it.next();
            int adjustedPos = s.pos + adjust;
            if (!deletedChars.get(s.pos) && output.charAt(adjustedPos) == '#') {
                output.deleteCharAt(adjustedPos);
                --adjust;
                deletedChars.set(s.pos);
            }
            while (nextChange != null && s == nextChange.special) {
                int lenBefore = output.length();
                int modPos = s.pos + adjust;
                int posTweak = 0;
                switch (nextChange.op) {
                    case 2: {
                        if (nextChange.toAdd.equals(",") && deletedChars.get(s.pos)) break;
                        posTweak = 1;
                    }
                    case 1: {
                        output.insert(modPos + posTweak, (Object)nextChange.toAdd);
                        break;
                    }
                    case 3: {
                        int modEndPos;
                        int delPos = s.pos;
                        if (!nextChange.startInclusive) {
                            ++delPos;
                            ++modPos;
                        }
                        while (deletedChars.get(delPos)) {
                            ++delPos;
                            ++modPos;
                        }
                        int delEndPos = nextChange.end.pos;
                        if (nextChange.endInclusive) {
                            ++delEndPos;
                        }
                        if (modPos >= (modEndPos = delEndPos + adjust)) break;
                        if (nextChange.toAdd == "") {
                            output.delete(modPos, modEndPos);
                        } else {
                            char fillCh = nextChange.toAdd.charAt(0);
                            int i = modPos;
                            while (i < modEndPos) {
                                output.setCharAt(i, fillCh);
                                ++i;
                            }
                        }
                        deletedChars.set(delPos, delEndPos);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown op: " + nextChange.op);
                    }
                }
                adjust += output.length() - lenBefore;
                nextChange = changes.hasNext() ? (StringMod)changes.next() : null;
            }
        }
        if (negative) {
            toAppendTo.append('-');
        }
        toAppendTo.append(output);
    }

    private void writeScientific(double value, StringBuffer output, Set mods) {
        StringBuffer result = new StringBuffer();
        FieldPosition fractionPos = new FieldPosition(1);
        this.decimalFmt.format(value, result, fractionPos);
        this.writeInteger(result, output, this.integerSpecials, mods, this.integerCommas);
        this.writeFractional(result, output);
        int ePos = fractionPos.getEndIndex();
        int signPos = ePos + 1;
        char expSignRes = result.charAt(signPos);
        if (expSignRes != '-') {
            expSignRes = '+';
            result.insert(signPos, '+');
        }
        ListIterator it = this.exponentSpecials.listIterator(1);
        Special expSign = (Special)it.next();
        char expSignFmt = expSign.ch;
        if (expSignRes == '-' || expSignFmt == '+') {
            mods.add(CellNumberFormatter.replaceMod(expSign, true, expSign, true, expSignRes));
        } else {
            mods.add(CellNumberFormatter.deleteMod(expSign, true, expSign, true));
        }
        StringBuffer exponentNum = new StringBuffer(result.substring(signPos + 1));
        this.writeInteger(exponentNum, output, this.exponentDigitSpecials, mods, false);
    }

    private void writeFraction(double value, StringBuffer result, double fractional, StringBuffer output, Set mods) {
        if (!this.improperFraction) {
            boolean removeBecauseFraction;
            if (fractional == 0.0 && !CellNumberFormatter.hasChar('0', new List[]{this.numeratorSpecials})) {
                this.writeInteger(result, output, this.integerSpecials, mods, false);
                Special start = (Special)this.integerSpecials.get(this.integerSpecials.size() - 1);
                Special end = (Special)this.denominatorSpecials.get(this.denominatorSpecials.size() - 1);
                if (CellNumberFormatter.hasChar('?', new List[]{this.integerSpecials, this.numeratorSpecials, this.denominatorSpecials})) {
                    mods.add(CellNumberFormatter.replaceMod(start, false, end, true, ' '));
                } else {
                    mods.add(CellNumberFormatter.deleteMod(start, false, end, true));
                }
                return;
            }
            boolean allZero = value == 0.0 && fractional == 0.0;
            boolean willShowFraction = fractional != 0.0 || CellNumberFormatter.hasChar('0', new List[]{this.numeratorSpecials});
            boolean removeBecauseZero = allZero && (CellNumberFormatter.hasOnly('#', new List[]{this.integerSpecials}) || !CellNumberFormatter.hasChar('0', new List[]{this.numeratorSpecials}));
            boolean bl = removeBecauseFraction = !allZero && value == 0.0 && willShowFraction && !CellNumberFormatter.hasChar('0', new List[]{this.integerSpecials});
            if (removeBecauseZero || removeBecauseFraction) {
                Special start = (Special)this.integerSpecials.get(this.integerSpecials.size() - 1);
                if (CellNumberFormatter.hasChar('?', new List[]{this.integerSpecials, this.numeratorSpecials})) {
                    mods.add(CellNumberFormatter.replaceMod(start, true, this.numerator, false, ' '));
                } else {
                    mods.add(CellNumberFormatter.deleteMod(start, true, this.numerator, false));
                }
            } else {
                this.writeInteger(result, output, this.integerSpecials, mods, false);
            }
        }
        try {
            int d;
            int n;
            if (fractional == 0.0 || this.improperFraction && fractional % 1.0 == 0.0) {
                n = (int)Math.round(fractional);
                d = 1;
            } else {
                Fraction frac = new Fraction(fractional, this.maxDenominator);
                n = frac.getNumerator();
                d = frac.getDenominator();
            }
            if (this.improperFraction) {
                n = (int)((long)n + Math.round(value * (double)d));
            }
            this.writeSingleInteger(this.numeratorFmt, n, output, this.numeratorSpecials, mods);
            this.writeSingleInteger(this.denominatorFmt, d, output, this.denominatorSpecials, mods);
        }
        catch (RuntimeException ignored) {
            ignored.printStackTrace();
        }
    }

    private static boolean hasChar(char ch, List[] numSpecials) {
        int i = 0;
        while (i < numSpecials.length) {
            List specials = numSpecials[i];
            Iterator iterator = specials.iterator();
            while (iterator.hasNext()) {
                Special s = (Special)iterator.next();
                if (s.ch != ch) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasOnly(char ch, List[] numSpecials) {
        int i = 0;
        while (i < numSpecials.length) {
            List specials = numSpecials[i];
            Iterator iterator = specials.iterator();
            while (iterator.hasNext()) {
                Special s = (Special)iterator.next();
                if (s.ch == ch) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    private void writeSingleInteger(String fmt, int num, StringBuffer output, List numSpecials, Set mods) {
        StringBuffer sb = new StringBuffer();
        POIFormatter formatter = new POIFormatter(sb);
        formatter.format(fmt, new Object[]{new Integer(num)});
        this.writeInteger(sb, output, numSpecials, mods, false);
    }

    private void writeInteger(StringBuffer result, StringBuffer output, List numSpecials, Set mods, boolean showCommas) {
        int pos = result.indexOf(".") - 1;
        if (pos < 0) {
            pos = this.exponent != null && numSpecials == this.integerSpecials ? result.indexOf("E") - 1 : result.length() - 1;
        }
        int strip = 0;
        while (strip < pos) {
            char resultCh = result.charAt(strip);
            if (resultCh != '0' && resultCh != ',') break;
            ++strip;
        }
        ListIterator it = numSpecials.listIterator(numSpecials.size());
        boolean followWithComma = false;
        Special lastOutputIntegerDigit = null;
        int digit = 0;
        while (it.hasPrevious()) {
            char resultCh = pos >= 0 ? (char)result.charAt(pos) : (char)'0';
            Special s = (Special)it.previous();
            followWithComma = showCommas && digit > 0 && digit % 3 == 0;
            boolean zeroStrip = false;
            if (resultCh != '0' || s.ch == '0' || s.ch == '?' || pos >= strip) {
                zeroStrip = s.ch == '?' && pos < strip;
                output.setCharAt(s.pos, zeroStrip ? (char)' ' : resultCh);
                lastOutputIntegerDigit = s;
            }
            if (followWithComma) {
                mods.add(CellNumberFormatter.insertMod(s, zeroStrip ? " " : ",", 2));
                followWithComma = false;
            }
            ++digit;
            --pos;
        }
        StringBuffer extraLeadingDigits = new StringBuffer();
        if (pos >= 0) {
            extraLeadingDigits = new StringBuffer(result.substring(0, ++pos));
            if (showCommas) {
                while (pos > 0) {
                    if (digit > 0 && digit % 3 == 0) {
                        extraLeadingDigits.insert(pos, ',');
                    }
                    ++digit;
                    --pos;
                }
            }
            mods.add(CellNumberFormatter.insertMod(lastOutputIntegerDigit, extraLeadingDigits, 1));
        }
    }

    private void writeFractional(StringBuffer result, StringBuffer output) {
        if (this.fractionalSpecials.size() > 0) {
            int digit = result.indexOf(".") + 1;
            int strip = this.exponent != null ? result.indexOf("e") - 1 : result.length() - 1;
            while (strip > digit && result.charAt(strip) == '0') {
                --strip;
            }
            ListIterator it = this.fractionalSpecials.listIterator();
            while (it.hasNext()) {
                Special s = (Special)it.next();
                char resultCh = result.charAt(digit);
                if (resultCh != '0' || s.ch == '0' || digit < strip) {
                    output.setCharAt(s.pos, resultCh);
                } else if (s.ch == '?') {
                    output.setCharAt(s.pos, ' ');
                }
                ++digit;
            }
        }
    }

    public void simpleValue(StringBuffer toAppendTo, Object value) {
        SIMPLE_NUMBER.formatValue(toAppendTo, value);
    }

    private static class Fraction {
        private final int denominator;
        private final int numerator;

        private Fraction(double value, double epsilon, int maxDenominator, int maxIterations) {
            long q2;
            long p2;
            long overflow = Integer.MAX_VALUE;
            double r0 = value;
            long a0 = (long)Math.floor(r0);
            if (a0 > overflow) {
                throw new IllegalArgumentException("Overflow trying to convert " + value + " to fraction (" + a0 + "/" + 1L + ")");
            }
            if (Math.abs((double)a0 - value) < epsilon) {
                this.numerator = (int)a0;
                this.denominator = 1;
                return;
            }
            long p0 = 1L;
            long q0 = 0L;
            long p1 = a0;
            long q1 = 1L;
            int n = 0;
            boolean stop = false;
            do {
                ++n;
                double r1 = 1.0 / (r0 - (double)a0);
                long a1 = (long)Math.floor(r1);
                p2 = a1 * p1 + p0;
                q2 = a1 * q1 + q0;
                if (p2 > overflow || q2 > overflow) {
                    throw new RuntimeException("Overflow trying to convert " + value + " to fraction (" + p2 + "/" + q2 + ")");
                }
                double convergent = (double)p2 / (double)q2;
                if (n < maxIterations && Math.abs(convergent - value) > epsilon && q2 < (long)maxDenominator) {
                    p0 = p1;
                    p1 = p2;
                    q0 = q1;
                    q1 = q2;
                    a0 = a1;
                    r0 = r1;
                    continue;
                }
                stop = true;
            } while (!stop);
            if (n >= maxIterations) {
                throw new RuntimeException("Unable to convert " + value + " to fraction after " + maxIterations + " iterations");
            }
            if (q2 < (long)maxDenominator) {
                this.numerator = (int)p2;
                this.denominator = (int)q2;
            } else {
                this.numerator = (int)p1;
                this.denominator = (int)q1;
            }
        }

        public Fraction(double value, int maxDenominator) {
            this(value, 0.0, maxDenominator, 100);
        }

        public int getDenominator() {
            return this.denominator;
        }

        public int getNumerator() {
            return this.numerator;
        }
    }

    private class NumPartHandler
    implements CellFormatPart.PartHandler {
        private char insertSignForExponent;

        private NumPartHandler() {
        }

        public String handlePart(Matcher m, String part, CellFormatType type, StringBuffer desc) {
            int pos = desc.length();
            char firstCh = part.charAt(0);
            switch (firstCh) {
                case 'E': 
                case 'e': {
                    if (CellNumberFormatter.this.exponent != null || CellNumberFormatter.this.specials.size() <= 0) break;
                    List list = CellNumberFormatter.this.specials;
                    Special special = new Special('.', pos);
                    CellNumberFormatter.this.exponent = special;
                    list.add(special);
                    this.insertSignForExponent = part.charAt(1);
                    return part.substring(0, 1);
                }
                case '#': 
                case '0': 
                case '?': {
                    if (this.insertSignForExponent != '\u0000') {
                        CellNumberFormatter.this.specials.add(new Special(this.insertSignForExponent, pos));
                        desc.append(this.insertSignForExponent);
                        this.insertSignForExponent = '\u0000';
                        ++pos;
                    }
                    int i = 0;
                    while (i < part.length()) {
                        char ch = part.charAt(i);
                        CellNumberFormatter.this.specials.add(new Special(ch, pos + i));
                        ++i;
                    }
                    break;
                }
                case '.': {
                    if (CellNumberFormatter.this.decimalPoint != null || CellNumberFormatter.this.specials.size() <= 0) break;
                    List list = CellNumberFormatter.this.specials;
                    Special special = new Special('.', pos);
                    CellNumberFormatter.this.decimalPoint = special;
                    list.add(special);
                    break;
                }
                case '/': {
                    if (CellNumberFormatter.this.slash != null || CellNumberFormatter.this.specials.size() <= 0) break;
                    CellNumberFormatter.this.numerator = CellNumberFormatter.this.previousNumber();
                    if (CellNumberFormatter.this.numerator == CellNumberFormatter.firstDigit(CellNumberFormatter.this.specials)) {
                        CellNumberFormatter.this.improperFraction = true;
                    }
                    List list = CellNumberFormatter.this.specials;
                    Special special = new Special('.', pos);
                    CellNumberFormatter.this.slash = special;
                    list.add(special);
                    break;
                }
                case '%': {
                    CellNumberFormatter cellNumberFormatter = CellNumberFormatter.this;
                    cellNumberFormatter.scale = cellNumberFormatter.scale * 100.0;
                    break;
                }
                default: {
                    return null;
                }
            }
            return part;
        }
    }

    static class Special {
        final char ch;
        int pos;

        Special(char ch, int pos) {
            this.ch = ch;
            this.pos = pos;
        }

        public String toString() {
            return "'" + this.ch + "' @ " + this.pos;
        }
    }

    static class StringMod
    implements Comparable {
        final Special special;
        final int op;
        CharSequence toAdd;
        Special end;
        boolean startInclusive;
        boolean endInclusive;
        public static final int BEFORE = 1;
        public static final int AFTER = 2;
        public static final int REPLACE = 3;

        private StringMod(Special special, CharSequence toAdd, int op) {
            this.special = special;
            this.toAdd = toAdd;
            this.op = op;
        }

        public StringMod(Special start, boolean startInclusive, Special end, boolean endInclusive, char toAdd) {
            this(start, startInclusive, end, endInclusive);
            this.toAdd = String.valueOf(toAdd);
        }

        public StringMod(Special start, boolean startInclusive, Special end, boolean endInclusive) {
            this.special = start;
            this.startInclusive = startInclusive;
            this.end = end;
            this.endInclusive = endInclusive;
            this.op = 3;
            this.toAdd = "";
        }

        public int compareTo(Object that) {
            int diff = this.special.pos - ((StringMod)that).special.pos;
            if (diff != 0) {
                return diff;
            }
            return this.op - ((StringMod)that).op;
        }

        public boolean equals(Object that) {
            try {
                return this.compareTo((StringMod)that) == 0;
            }
            catch (RuntimeException ignored) {
                return false;
            }
        }

        public int hashCode() {
            return this.special.hashCode() + this.op;
        }
    }
}

