/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.util.LittleEndian;

public final class BATBlock
extends BigBlock {
    private int[] _values;
    private boolean _has_free_sectors;
    private int ourBlockIndex;

    private BATBlock(POIFSBigBlockSize bigBlockSize) {
        super(bigBlockSize);
        int _entries_per_block = bigBlockSize.getBATEntriesPerBlock();
        this._values = new int[_entries_per_block];
        this._has_free_sectors = true;
        Arrays.fill(this._values, -1);
    }

    private BATBlock(POIFSBigBlockSize bigBlockSize, int[] entries, int start_index, int end_index) {
        this(bigBlockSize);
        int k = start_index;
        while (k < end_index) {
            this._values[k - start_index] = entries[k];
            ++k;
        }
        if (end_index - start_index == this._values.length) {
            this.recomputeFree();
        }
    }

    private void recomputeFree() {
        boolean hasFree = false;
        int k = 0;
        while (k < this._values.length) {
            if (this._values[k] == -1) {
                hasFree = true;
                break;
            }
            ++k;
        }
        this._has_free_sectors = hasFree;
    }

    public static BATBlock createBATBlock(POIFSBigBlockSize bigBlockSize, ByteBuffer data) {
        BATBlock block = new BATBlock(bigBlockSize);
        byte[] buffer = new byte[4];
        int i = 0;
        while (i < block._values.length) {
            data.get(buffer);
            block._values[i] = LittleEndian.getInt(buffer);
            ++i;
        }
        block.recomputeFree();
        return block;
    }

    public static BATBlock createEmptyBATBlock(POIFSBigBlockSize bigBlockSize, boolean isXBAT) {
        BATBlock block = new BATBlock(bigBlockSize);
        if (isXBAT) {
            block.setXBATChain(bigBlockSize, -2);
        }
        return block;
    }

    public static BATBlock[] createBATBlocks(POIFSBigBlockSize bigBlockSize, int[] entries) {
        int block_count = BATBlock.calculateStorageRequirements(bigBlockSize, entries.length);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        int _entries_per_block = bigBlockSize.getBATEntriesPerBlock();
        int j = 0;
        while (j < entries.length) {
            blocks[index++] = new BATBlock(bigBlockSize, entries, j, remaining > _entries_per_block ? j + _entries_per_block : entries.length);
            remaining -= _entries_per_block;
            j += _entries_per_block;
        }
        return blocks;
    }

    public static BATBlock[] createXBATBlocks(POIFSBigBlockSize bigBlockSize, int[] entries, int startBlock) {
        int block_count = BATBlock.calculateXBATStorageRequirements(bigBlockSize, entries.length);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        int _entries_per_xbat_block = bigBlockSize.getXBATEntriesPerBlock();
        if (block_count != 0) {
            int j = 0;
            while (j < entries.length) {
                blocks[index++] = new BATBlock(bigBlockSize, entries, j, remaining > _entries_per_xbat_block ? j + _entries_per_xbat_block : entries.length);
                remaining -= _entries_per_xbat_block;
                j += _entries_per_xbat_block;
            }
            index = 0;
            while (index < blocks.length - 1) {
                blocks[index].setXBATChain(bigBlockSize, startBlock + index + 1);
                ++index;
            }
            blocks[index].setXBATChain(bigBlockSize, -2);
        }
        return blocks;
    }

    public static int calculateStorageRequirements(POIFSBigBlockSize bigBlockSize, int entryCount) {
        int _entries_per_block = bigBlockSize.getBATEntriesPerBlock();
        return (entryCount + _entries_per_block - 1) / _entries_per_block;
    }

    public static int calculateXBATStorageRequirements(POIFSBigBlockSize bigBlockSize, int entryCount) {
        int _entries_per_xbat_block = bigBlockSize.getXBATEntriesPerBlock();
        return (entryCount + _entries_per_xbat_block - 1) / _entries_per_xbat_block;
    }

    public static int calculateMaximumSize(POIFSBigBlockSize bigBlockSize, int numBATs) {
        int size = 1;
        return (size += numBATs * bigBlockSize.getBATEntriesPerBlock()) * bigBlockSize.getBigBlockSize();
    }

    public static int calculateMaximumSize(HeaderBlock header) {
        return BATBlock.calculateMaximumSize(header.getBigBlockSize(), header.getBATCount());
    }

    public static BATBlockAndIndex getBATBlockAndIndex(int offset, HeaderBlock header, List bats) {
        POIFSBigBlockSize bigBlockSize = header.getBigBlockSize();
        int whichBAT = (int)Math.floor(offset / bigBlockSize.getBATEntriesPerBlock());
        int index = offset % bigBlockSize.getBATEntriesPerBlock();
        return new BATBlockAndIndex(index, (BATBlock)bats.get(whichBAT));
    }

    public static BATBlockAndIndex getSBATBlockAndIndex(int offset, HeaderBlock header, List sbats) {
        POIFSBigBlockSize bigBlockSize = header.getBigBlockSize();
        int whichSBAT = (int)Math.floor(offset / bigBlockSize.getBATEntriesPerBlock());
        int index = offset % bigBlockSize.getBATEntriesPerBlock();
        return new BATBlockAndIndex(index, (BATBlock)sbats.get(whichSBAT));
    }

    private void setXBATChain(POIFSBigBlockSize bigBlockSize, int chainIndex) {
        int _entries_per_xbat_block = bigBlockSize.getXBATEntriesPerBlock();
        this._values[_entries_per_xbat_block] = chainIndex;
    }

    public boolean hasFreeSectors() {
        return this._has_free_sectors;
    }

    public int getValueAt(int relativeOffset) {
        if (relativeOffset >= this._values.length) {
            throw new ArrayIndexOutOfBoundsException("Unable to fetch offset " + relativeOffset + " as the " + "BAT only contains " + this._values.length + " entries");
        }
        return this._values[relativeOffset];
    }

    public void setValueAt(int relativeOffset, int value) {
        int oldValue = this._values[relativeOffset];
        this._values[relativeOffset] = value;
        if (value == -1) {
            this._has_free_sectors = true;
            return;
        }
        if (oldValue == -1) {
            this.recomputeFree();
        }
    }

    public void setOurBlockIndex(int index) {
        this.ourBlockIndex = index;
    }

    public int getOurBlockIndex() {
        return this.ourBlockIndex;
    }

    void writeData(OutputStream stream) throws IOException {
        stream.write(this.serialize());
    }

    void writeData(ByteBuffer block) throws IOException {
        block.put(this.serialize());
    }

    private byte[] serialize() {
        byte[] data = new byte[this.bigBlockSize.getBigBlockSize()];
        int offset = 0;
        int i = 0;
        while (i < this._values.length) {
            LittleEndian.putInt(data, offset, this._values[i]);
            offset += 4;
            ++i;
        }
        return data;
    }

    public static class BATBlockAndIndex {
        private final int index;
        private final BATBlock block;

        private BATBlockAndIndex(int index, BATBlock block) {
            this.index = index;
            this.block = block;
        }

        public int getIndex() {
            return this.index;
        }

        public BATBlock getBlock() {
            return this.block;
        }
    }
}

